/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.rmi;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Iterator;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.io.ObjectStream;

@ThreadSafe
final class IteratorWrapper<E>
implements ObjectStream<E> {
    private final Iterator<E> iterator;

    public IteratorWrapper(Iterator<E> iterator) {
        this.iterator = iterator;
    }

    @Override
    public synchronized E next() throws IOException {
        try {
            while (this.iterator.hasNext()) {
                E e = this.iterator.next();
                if (e == null) continue;
                return e;
            }
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            Throwable throwable = undeclaredThrowableException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw undeclaredThrowableException;
        }
        return null;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.iterator instanceof Closeable) {
            ((Closeable)((Object)this.iterator)).close();
        }
    }
}

