/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Exceptions;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.PeriodDuration;
import org.opengis.temporal.TemporalFactory;
import org.opengis.util.InternationalString;

public final class TemporalUtilities
extends Static {
    private static volatile boolean warningLogged;

    private TemporalUtilities() {
    }

    private static Instant createInstant(TemporalFactory temporalFactory, Date date) {
        return temporalFactory.createInstant(temporalFactory.createPosition(date));
    }

    public static Instant createInstant(Date date) throws FactoryNotFoundException {
        return TemporalUtilities.createInstant(FactoryFinder.getTemporalFactory(null), date);
    }

    public static Period createPeriod(Date date, Date date2) throws FactoryNotFoundException {
        TemporalFactory temporalFactory = FactoryFinder.getTemporalFactory(null);
        return temporalFactory.createPeriod(TemporalUtilities.createInstant(temporalFactory, date), TemporalUtilities.createInstant(temporalFactory, date2));
    }

    public static PeriodDuration createPeriodDuration(InternationalString internationalString, InternationalString internationalString2, InternationalString internationalString3, InternationalString internationalString4, InternationalString internationalString5, InternationalString internationalString6, InternationalString internationalString7) throws FactoryNotFoundException {
        TemporalFactory temporalFactory = FactoryFinder.getTemporalFactory(null);
        return temporalFactory.createPeriodDuration(internationalString, internationalString2, internationalString3, internationalString4, internationalString5, internationalString6, internationalString7);
    }

    public static LogRecord createLog(FactoryNotFoundException factoryNotFoundException) {
        Level level = Level.FINE;
        if (!warningLogged) {
            warningLogged = true;
            level = Level.WARNING;
        }
        LogRecord logRecord = new LogRecord(level, Errors.format(118, "geotk-temporal"));
        logRecord.setMessage(Exceptions.formatChainedMessages(logRecord.getMessage(), factoryNotFoundException));
        return logRecord;
    }
}

