/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.logging.Level;
import org.geotoolkit.internal.DaemonThread;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.util.Disposable;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;

public class ReferenceQueueConsumer<T>
extends DaemonThread {
    public static final ReferenceQueueConsumer<Object> DEFAULT = new ReferenceQueueConsumer("ReferenceQueueConsumer");
    public final ReferenceQueue<T> queue = new ReferenceQueue();

    protected ReferenceQueueConsumer(String string) {
        super(Threads.RESOURCE_DISPOSERS, string);
        this.setPriority(8);
    }

    protected void process(Reference<? extends T> reference) {
        ((Disposable)((Object)reference)).dispose();
    }

    @Override
    public final void run() {
        ReferenceQueue<T> referenceQueue;
        Level level = Level.SEVERE;
        while ((referenceQueue = this.queue) != null) {
            Reference<T> reference;
            if (this.isKillRequested()) {
                level = Level.INFO;
                break;
            }
            try {
                reference = referenceQueue.remove();
                if (reference == null) {
                    ReferenceQueueConsumer.sleep(15000L);
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            try {
                this.process(reference);
            }
            catch (Exception exception) {
                Logging.unexpectedException(this.getClass(), "run", exception);
            }
            catch (AssertionError assertionError) {
                Logging.unexpectedException(this.getClass(), "run", (Throwable)((Object)assertionError));
            }
        }
        Logging.getLogger(this.getClass()).log(level, "{0} daemon stopped.", Classes.getShortClassName(this));
    }

    static {
        DEFAULT.start();
    }
}

