/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.logging.Logging;
import org.opengis.annotation.UML;
import org.opengis.util.CodeList;

public final class CodeLists
extends Static
implements CodeList.Filter {
    private final String codename;
    private final boolean canCreate;

    private CodeLists(String string, boolean bl) {
        this.codename = string;
        this.canCreate = bl;
    }

    public static String classname(CodeList<?> codeList) {
        String string;
        if (codeList == null) {
            return null;
        }
        Class<?> clazz = codeList.getClass();
        UML uML = clazz.getAnnotation(UML.class);
        if (uML != null && (string = uML.identifier()) != null && !(string = string.trim()).isEmpty()) {
            return string;
        }
        return clazz.getSimpleName();
    }

    public static String identifier(CodeList<?> codeList) {
        if (codeList == null) {
            return null;
        }
        String string = codeList.identifier();
        if (string == null || (string = string.trim()).isEmpty()) {
            string = codeList.name();
        }
        return string;
    }

    public static String[] identifiers(Class<? extends CodeList<?>> clazz) {
        CodeList[] codeListArray = CodeLists.values(clazz);
        String[] stringArray = new String[codeListArray.length];
        for (int i = 0; i < codeListArray.length; ++i) {
            stringArray[i] = CodeLists.identifier(codeListArray[i]);
        }
        return stringArray;
    }

    public static String sentence(CodeList<?> codeList) {
        if (codeList == null) {
            return null;
        }
        String string = codeList.identifier();
        String string2 = codeList.name();
        if (string == null) {
            string = string2;
        }
        for (String string3 : codeList.names()) {
            if (string3.equals(string2) || string3.length() < string.length()) continue;
            string = string3;
        }
        return Strings.camelCaseToSentence(string);
    }

    public static String localize(CodeList<?> codeList, Locale locale) {
        if (codeList == null) {
            return null;
        }
        if (locale != null) {
            String string = CodeLists.classname(codeList) + '.' + CodeLists.identifier(codeList);
            try {
                return ResourceBundle.getBundle("org.opengis.metadata.CodeLists", locale).getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                Logging.recoverableException(CodeLists.class, "localize", missingResourceException);
            }
        }
        return CodeLists.sentence(codeList);
    }

    public static <T extends CodeList<?>> T[] values(Class<T> clazz) {
        Object object;
        try {
            object = clazz.getMethod("values", null).invoke(null, (Object[])null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
        catch (Exception exception) {
            object = Array.newInstance(clazz, 0);
        }
        return (CodeList[])object;
    }

    public static <T extends CodeList<T>> T valueOf(Class<T> clazz, String string) {
        return CodeLists.valueOf(clazz, string, true);
    }

    public static <T extends CodeList<T>> T valueOf(Class<T> clazz, String string, boolean bl) {
        if (string == null || (string = string.trim()).isEmpty()) {
            return null;
        }
        String string2 = clazz.getName();
        try {
            Class.forName(string2, true, clazz.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException(string2, classNotFoundException);
        }
        return (T)CodeList.valueOf(clazz, (CodeList.Filter)new CodeLists(string, bl));
    }

    public String codename() {
        return this.canCreate ? this.codename : null;
    }

    public boolean accept(CodeList<?> codeList) {
        for (String string : codeList.names()) {
            if (!CodeLists.matches(string, this.codename)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(String string, String string2) {
        int n = string2.length();
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (!CodeLists.isSignificant(c2)) continue;
            do {
                if (n3 < n) continue;
                return false;
            } while (!CodeLists.isSignificant(c = string2.charAt(n3++)));
            if (c2 == c || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
            return false;
        }
        while (n3 < n) {
            if (!CodeLists.isSignificant(string2.charAt(n3++))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSignificant(char c) {
        return !Character.isWhitespace(c);
    }
}

