/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gui.swing.tree;

import java.io.Flushable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.geotoolkit.gui.swing.tree.DefaultMutableTreeNode;
import org.geotoolkit.gui.swing.tree.MutableTreeNode;
import org.geotoolkit.gui.swing.tree.TreeTableNode;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.io.ExpandedTabWriter;
import org.geotoolkit.io.LineReader;
import org.geotoolkit.io.LineReaders;
import org.geotoolkit.io.LineWriter;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.collection.BackingStoreException;

public class TreeFormat
extends Format {
    private static final long serialVersionUID = -4476366905386037025L;
    private int indentation = 4;
    private int verticalLinePosition;
    private String lineSeparator;
    private char columnSeparator = (char)8230;
    private boolean isTableFormatEnabled;
    private transient String treeBlank;
    private transient String treeLine;
    private transient String treeCross;
    private transient String treeEnd;
    private transient Writer lineWriter;
    private transient StringBuffer lineBuffer;

    public TreeFormat() {
        this.lineSeparator = System.getProperty("line.separator", "\n");
    }

    private void clearTreeSymbols() {
        this.treeBlank = null;
        this.treeLine = null;
        this.treeCross = null;
        this.treeEnd = null;
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int n) throws IllegalArgumentException {
        ArgumentChecks.ensurePositive("indentation", n);
        this.indentation = n;
        if (this.verticalLinePosition > n) {
            this.verticalLinePosition = n;
        }
        this.clearTreeSymbols();
    }

    public int getVerticalLinePosition() {
        return this.verticalLinePosition;
    }

    public void setVerticalLinePosition(int n) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween("verticalLinePosition", 0, this.indentation, n);
        this.verticalLinePosition = n;
        this.clearTreeSymbols();
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String string) {
        ArgumentChecks.ensureNonNull("separator", string);
        this.lineSeparator = string;
    }

    public char getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(char c) {
        this.columnSeparator = c;
    }

    public boolean isTableFormatEnabled() {
        return this.isTableFormatEnabled;
    }

    public void setTableFormatEnabled(boolean bl) {
        this.isTableFormatEnabled = bl;
    }

    private static boolean hasTreeTableNode(TreeNode treeNode) {
        if (treeNode instanceof TreeTableNode) {
            return true;
        }
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                if (!TreeFormat.hasTreeTableNode(enumeration.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public MutableTreeNode parseObject(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        string = string.substring(n);
        try {
            MutableTreeNode mutableTreeNode = this.parseObject(string);
            parsePosition.setIndex(n + string.length());
            return mutableTreeNode;
        }
        catch (ParseException parseException) {
            parsePosition.setErrorIndex(n + parseException.getErrorOffset());
            return null;
        }
    }

    @Override
    public MutableTreeNode parseObject(String string) throws ParseException {
        try {
            return this.parse(LineReaders.wrap(string));
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.getLocalizedMessage(), 0);
        }
    }

    public MutableTreeNode parse(LineReader lineReader) throws IOException {
        String string;
        int n = 0;
        int[] nArray = new int[16];
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        while ((string = lineReader.readLine()) != null) {
            int n2;
            boolean bl = false;
            int n3 = string.length();
            for (n2 = 0; n2 < n3; ++n2) {
                char c = string.charAt(n2);
                if (Character.isSpaceChar(c)) continue;
                bl = true;
                if ("\u2500\u2502\u2514\u251c".indexOf(c) < 0) break;
            }
            if (!bl) continue;
            while (n2 != 0 && Character.isSpaceChar(string.charAt(n2 - 1))) {
                --n2;
            }
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string.substring(n2).trim());
            if (defaultMutableTreeNode == null) {
                nArray[0] = n2;
                defaultMutableTreeNode = defaultMutableTreeNode3;
            } else {
                int n4;
                while (n2 < (n4 = nArray[n])) {
                    if (--n < 0) {
                        throw new ContentFormatException(Errors.format(124, defaultMutableTreeNode3));
                    }
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                }
                if (n2 == n4) {
                    DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                    if (defaultMutableTreeNode4 == null) {
                        throw new ContentFormatException(Errors.format(124, defaultMutableTreeNode3));
                    }
                    defaultMutableTreeNode4.add(defaultMutableTreeNode3);
                } else if (n2 > n4) {
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    if (++n == nArray.length) {
                        nArray = Arrays.copyOf(nArray, n * 2);
                    }
                    nArray[n] = n2;
                }
            }
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
        }
        return defaultMutableTreeNode;
    }

    private void ensureInitialized() {
        if (this.treeBlank == null) {
            int n = this.indentation;
            int n2 = this.verticalLinePosition;
            char[] cArray = new char[n];
            block6: for (int i = 0; i < 4; ++i) {
                char c;
                int n3;
                if ((i & 2) == 0) {
                    n3 = (i & 1) == 0 ? 160 : 9474;
                    c = '\u00a0';
                } else {
                    n3 = (i & 1) == 0 ? 9492 : 9500;
                    c = '\u2500';
                }
                Arrays.fill(cArray, 0, n2, '\u00a0');
                cArray[n2] = n3;
                Arrays.fill(cArray, n2 + 1, n, c);
                String string = String.valueOf(cArray);
                switch (i) {
                    case 0: {
                        this.treeBlank = string;
                        continue block6;
                    }
                    case 1: {
                        this.treeLine = string;
                        continue block6;
                    }
                    case 2: {
                        this.treeEnd = string;
                        continue block6;
                    }
                    case 3: {
                        this.treeCross = string;
                        continue block6;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
            }
        }
    }

    private String toString(Object object) throws IOException {
        Object object2;
        Writer writer = this.lineWriter;
        if (writer == null) {
            object2 = new StringWriter();
            this.lineWriter = writer = new ExpandedTabWriter(new LineWriter((Writer)object2, " \u00b6 "));
            this.lineBuffer = ((StringWriter)object2).getBuffer();
        }
        writer.write(String.valueOf(object));
        object2 = this.lineBuffer.toString();
        writer.write(10);
        this.lineBuffer.setLength(0);
        return object2;
    }

    private boolean[] format(TreeModel treeModel, Object object, Appendable appendable, int n, boolean[] blArray) throws IOException {
        int n2;
        for (int i = 0; i < n; ++i) {
            n2 = blArray[i];
            appendable.append(i != n - 1 ? (n2 != 0 ? this.treeBlank : this.treeLine) : (n2 != 0 ? this.treeEnd : this.treeCross));
        }
        if (object instanceof TreeTableNode && appendable instanceof TableWriter) {
            TreeTableNode treeTableNode = (TreeTableNode)object;
            n2 = treeTableNode.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                Object object2;
                if (i != 0) {
                    ((TableWriter)appendable.append(this.columnSeparator)).nextColumn(this.columnSeparator);
                }
                if ((object2 = treeTableNode.getValueAt(i)) == null) continue;
                appendable.append(this.toString(object2));
            }
        } else {
            appendable.append(this.toString(object));
        }
        appendable.append(this.lineSeparator);
        if (n >= blArray.length) {
            blArray = Arrays.copyOf(blArray, n * 2);
        }
        int n3 = treeModel.getChildCount(object);
        for (n2 = 0; n2 < n3; ++n2) {
            blArray[n] = n2 == n3 - 1;
            blArray = this.format(treeModel, treeModel.getChild(object, n2), appendable, n + 1, blArray);
        }
        return blArray;
    }

    public void format(TreeModel treeModel, Appendable appendable) throws IOException {
        Object object = treeModel.getRoot();
        if (object != null) {
            StringWriter stringWriter = null;
            Appendable appendable2 = appendable;
            if (this.isTableFormatEnabled && object instanceof TreeNode && TreeFormat.hasTreeTableNode((TreeNode)object)) {
                Writer writer;
                if (appendable instanceof Writer) {
                    writer = (Writer)appendable;
                } else {
                    stringWriter = new StringWriter();
                    writer = stringWriter;
                }
                appendable2 = new TableWriter((Writer)new LineWriter(writer, this.lineSeparator), " ");
            }
            this.ensureInitialized();
            this.format(treeModel, object, appendable2, 0, new boolean[64]);
            if (appendable2 != appendable) {
                ((Flushable)((Object)appendable2)).flush();
            }
            if (stringWriter != null) {
                appendable.append(((Object)stringWriter).toString());
            }
        }
    }

    public final void format(TreeModel treeModel, StringBuilder stringBuilder) {
        try {
            this.format(treeModel, (Appendable)stringBuilder);
        }
        catch (IOException iOException) {
            throw new BackingStoreException(iOException);
        }
    }

    public void format(TreeNode treeNode, Appendable appendable) throws IOException {
        this.format((TreeModel)new DefaultTreeModel(treeNode, true), appendable);
    }

    public final void format(TreeNode treeNode, StringBuilder stringBuilder) {
        try {
            this.format(treeNode, (Appendable)stringBuilder);
        }
        catch (IOException iOException) {
            throw new BackingStoreException(iOException);
        }
    }

    public void format(Iterable<?> iterable, Appendable appendable) throws IOException {
        this.ensureInitialized();
        Iterator<?> iterator = iterable.iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            String string;
            String string2;
            String[] stringArray = Strings.getLinesFromMultilines(String.valueOf(iterator.next()));
            bl = iterator.hasNext();
            if (bl) {
                string2 = this.treeCross;
                string = this.treeLine;
            } else {
                string2 = this.treeEnd;
                string = this.treeBlank;
            }
            for (String string3 : stringArray) {
                if (string3.isEmpty()) continue;
                appendable.append(string2).append(string3).append(this.lineSeparator);
                string2 = string;
            }
        }
    }

    public final void format(Iterable<?> iterable, StringBuilder stringBuilder) {
        try {
            this.format(iterable, (Appendable)stringBuilder);
        }
        catch (IOException iOException) {
            throw new BackingStoreException(iOException);
        }
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        block5: {
            ArgumentChecks.ensureNonNull("tree", object);
            try {
                if (object instanceof TreeModel) {
                    this.format((TreeModel)object, (Appendable)stringBuffer);
                    break block5;
                }
                if (object instanceof TreeNode) {
                    this.format((TreeNode)object, (Appendable)stringBuffer);
                    break block5;
                }
                if (object instanceof Iterable) {
                    this.format((Iterable)object, (Appendable)stringBuffer);
                    break block5;
                }
                throw new IllegalArgumentException(Errors.format(256, "tree", object.getClass(), TreeModel.class));
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
        return stringBuffer;
    }
}

