/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.io.wkt.Formattable;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.AffineTransform2D;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform;
import org.geotoolkit.referencing.operation.transform.Parameterized;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.WeakHashSet;
import org.geotoolkit.util.logging.Logging;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

@ThreadSafe
public abstract class AbstractMathTransform2D
extends AbstractMathTransform
implements MathTransform2D {
    protected AbstractMathTransform2D() {
    }

    @Override
    public final int getSourceDimensions() {
        return 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 2;
    }

    @Override
    public Point2D transform(Point2D point2D, Point2D point2D2) throws TransformException {
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        this.transform(dArray, 0, dArray, 0, false);
        if (point2D2 != null) {
            point2D2.setLocation(dArray[0], dArray[1]);
            return point2D2;
        }
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public MathTransform2D inverse() throws NoninvertibleTransformException {
        return (MathTransform2D)super.inverse();
    }

    private static Object unwrap(Object object, boolean bl) {
        return bl ? ((Inverse)object).inverse() : object;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        Parameters parameters = this.getUnmarshalledParameters();
        return parameters != null ? parameters.getParameterDescriptors() : null;
    }

    protected Parameters getUnmarshalledParameters() {
        return null;
    }

    @Override
    final int beforeFormat(List<Object> list, int n, boolean bl) {
        Object object;
        Object object2;
        assert (AbstractMathTransform2D.unwrap(list.get(n), bl) == this) : this.getName();
        Parameters parameters = this.getUnmarshalledParameters();
        if (parameters == null) {
            return n;
        }
        AffineTransform affineTransform = null;
        AffineTransform affineTransform2 = null;
        if (n != 0 && (object2 = list.get(n - 1)) instanceof AffineTransform) {
            affineTransform = (AffineTransform)object2;
        }
        if (n + 1 < list.size() && (object2 = list.get(n + 1)) instanceof AffineTransform) {
            affineTransform2 = (AffineTransform)object2;
        }
        boolean bl2 = affineTransform != null;
        boolean bl3 = affineTransform2 != null;
        AffineTransform2D affineTransform2D = new AffineTransform2D(parameters.normalize(!bl));
        affineTransform2D.mutable = true;
        if (!bl) {
            try {
                affineTransform2D.invert();
            }
            catch (java.awt.geom.NoninvertibleTransformException noninvertibleTransformException) {
                AbstractMathTransform2D.unexpectedException(noninvertibleTransformException);
                return n;
            }
        }
        if (bl2) {
            affineTransform2D.concatenate(affineTransform);
        }
        if (affineTransform2D.isIdentity(1.0E-9)) {
            affineTransform = null;
            affineTransform2D.setTransform(parameters.normalize(bl));
        } else {
            AbstractMathTransform2D.roundIfAlmostInteger(affineTransform2D, false);
            affineTransform2D.forcePositiveZeros();
            affineTransform2D.mutable = false;
            affineTransform = affineTransform2D;
            affineTransform2D = new AffineTransform2D(parameters.normalize(bl));
            affineTransform2D.mutable = true;
        }
        if (!bl) {
            try {
                affineTransform2D.invert();
            }
            catch (java.awt.geom.NoninvertibleTransformException noninvertibleTransformException) {
                AbstractMathTransform2D.unexpectedException(noninvertibleTransformException);
                return n;
            }
        }
        if (bl3) {
            affineTransform2D.preConcatenate(affineTransform2);
        }
        if (affineTransform2D.isIdentity(1.0E-9)) {
            affineTransform2 = null;
        } else {
            AbstractMathTransform2D.roundIfAlmostInteger(affineTransform2D, true);
            affineTransform2D.forcePositiveZeros();
            affineTransform2D.mutable = false;
            affineTransform2 = affineTransform2D;
        }
        if (affineTransform == null) {
            if (bl2) {
                object = list.remove(--n);
                assert (object instanceof AffineTransform);
            }
        } else if (bl2) {
            object = list.set(n - 1, affineTransform);
            assert (object instanceof AffineTransform);
        } else {
            list.add(n++, affineTransform);
        }
        Parameters parameters2 = parameters;
        parameters2.getClass();
        object = list.set(n, parameters2.new Parameters.WKT(bl));
        assert (AbstractMathTransform2D.unwrap(object, bl) == this) : object.getClass();
        if (affineTransform2 == null) {
            if (bl3) {
                object = list.remove(n + 1);
                assert (object instanceof AffineTransform);
            }
        } else {
            ++n;
            if (bl3) {
                object = list.set(n, affineTransform2);
                assert (object instanceof AffineTransform);
            } else {
                list.add(n, affineTransform2);
            }
        }
        return n;
    }

    private static void roundIfAlmostInteger(AffineTransform affineTransform, boolean bl) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            double d = InternalUtilities.adjustForRoundingError((double)dArray[i]);
            if (i >= 4) {
                double d2 = Math.rint(d);
                double d3 = 1.0E-9;
                if (bl) {
                    d3 *= Math.hypot(dArray[i - 4], dArray[i - 2]);
                }
                if (Math.abs(d - d2) <= d3) {
                    d = d2;
                }
            }
            dArray[i] = d;
        }
        affineTransform.setTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    private static void unexpectedException(java.awt.geom.NoninvertibleTransformException noninvertibleTransformException) {
        Logging.recoverableException(ConcatenatedTransform.class, (String)"formatWKT", (Throwable)noninvertibleTransformException);
    }

    protected static abstract class Parameters
    implements Parameterized,
    Serializable {
        private static final long serialVersionUID = 4899134192407586472L;
        private static final WeakHashSet<AffineTransform2D> POOL = WeakHashSet.newInstance(AffineTransform2D.class);
        private final ParameterDescriptorGroup descriptor;
        private AffineTransform normalize;
        private AffineTransform denormalize;

        protected Parameters(ParameterDescriptorGroup parameterDescriptorGroup) {
            AbstractMathTransform.ensureNonNull("descriptor", parameterDescriptorGroup);
            this.descriptor = parameterDescriptorGroup;
            this.normalize = new AffineTransform();
            this.denormalize = new AffineTransform();
        }

        public final AffineTransform normalize(boolean bl) {
            return bl ? this.normalize : this.denormalize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MathTransform2D createConcatenatedTransform(MathTransform2D mathTransform2D) {
            AffineTransform2D affineTransform2D;
            AffineTransform2D affineTransform2D2;
            Parameters parameters = this;
            synchronized (parameters) {
                if (this.denormalize instanceof AffineTransform2D) {
                    affineTransform2D2 = (AffineTransform2D)this.normalize;
                    affineTransform2D = (AffineTransform2D)this.denormalize;
                } else {
                    affineTransform2D2 = new AffineTransform2D(this.normalize);
                    affineTransform2D = new AffineTransform2D(this.denormalize);
                    affineTransform2D2 = (AffineTransform2D)POOL.unique((Object)affineTransform2D2);
                    this.normalize = affineTransform2D2;
                    affineTransform2D = (AffineTransform2D)POOL.unique((Object)affineTransform2D);
                    this.denormalize = affineTransform2D;
                }
            }
            return MathTransforms.concatenate(affineTransform2D2, mathTransform2D, affineTransform2D);
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return this.descriptor;
        }

        @Override
        public abstract ParameterValueGroup getParameterValues();

        public int hashCode() {
            return Utilities.hash((Object)this.normalize, (int)this.denormalize.hashCode()) ^ 0x5D6CA6A8;
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass() == this.getClass()) {
                Parameters parameters = (Parameters)object;
                return Utilities.equals((Object)this.descriptor, (Object)parameters.descriptor) && Utilities.equals((Object)this.normalize, (Object)parameters.normalize) && Utilities.equals((Object)this.denormalize, (Object)parameters.denormalize);
            }
            return false;
        }

        public String toString() {
            return this.getParameterValues().toString();
        }

        final class WKT
        implements Formattable,
        Parameterized {
            private boolean inverse;

            WKT(boolean bl) {
                this.inverse = bl;
            }

            @Override
            public ParameterDescriptorGroup getParameterDescriptors() {
                return Parameters.this.getParameterDescriptors();
            }

            @Override
            public ParameterValueGroup getParameterValues() {
                return Parameters.this.getParameterValues();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String formatWKT(Formatter formatter) {
                if (!this.inverse) {
                    ParameterValueGroup parameterValueGroup = this.getParameterValues();
                    formatter.append(formatter.getName((IdentifiedObject)parameterValueGroup.getDescriptor()));
                    formatter.append((GeneralParameterValue)parameterValueGroup);
                    return "PARAM_MT";
                }
                this.inverse = false;
                try {
                    formatter.append(this);
                }
                finally {
                    this.inverse = true;
                }
                return "INVERSE_MT";
            }
        }
    }

    protected abstract class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform2D {
        private static final long serialVersionUID = 5751908928042026412L;

        protected Inverse() {
        }

        public MathTransform2D inverse() {
            return (MathTransform2D)super.inverse();
        }

        @Override
        final int beforeFormat(List<Object> list, int n, boolean bl) {
            return AbstractMathTransform2D.this.beforeFormat(list, n, !bl);
        }
    }
}

