/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.projection.Mercator;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.Mercator1SP;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class PseudoMercator
extends MapProjection {
    private static final long serialVersionUID = -8126827491349984471L;
    static final ParameterDescriptor<Double> CENTRAL_MERIDIAN = Mercator1SP.CENTRAL_MERIDIAN;
    static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = Mercator1SP.LATITUDE_OF_ORIGIN;
    static final ParameterDescriptor<Double> FALSE_EASTING = Mercator1SP.FALSE_EASTING;
    static final ParameterDescriptor<Double> FALSE_NORTHING = Mercator1SP.FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS;

    public PseudoMercator() {
        super(PARAMETERS);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return Mercator.create(this.getParameters(), parameterValueGroup);
    }

    static {
        Citation[] citationArray = new Citation[]{Citations.ESRI, Citations.NETCDF, Citations.GEOTIFF, Citations.PROJ4};
        PARAMETERS = UniversalParameters.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier((Citation)Citations.EPSG, "Popular Visualisation Pseudo Mercator"), new IdentifierCode((Citation)Citations.EPSG, 1024), PseudoMercator.sameNameAs(Citations.GEOTOOLKIT, (GeneralParameterDescriptor)Mercator1SP.PARAMETERS)}, citationArray, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, FALSE_EASTING, FALSE_NORTHING}, 1);
    }
}

