/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class Polyconic
extends MapProjection {
    private static final long serialVersionUID = 1681887819214500096L;
    static final ParameterDescriptor<Double> CENTRAL_MERIDIAN;
    static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    static final ParameterDescriptor<Double> FALSE_EASTING;
    static final ParameterDescriptor<Double> FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS;

    public Polyconic() {
        super(PARAMETERS);
    }

    public Class<ConicProjection> getOperationType() {
        return ConicProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return org.geotoolkit.referencing.operation.projection.Polyconic.create(this.getParameters(), parameterValueGroup);
    }

    static {
        Citation[] citationArray = new Citation[]{Citations.ESRI, Citations.NETCDF, Citations.PROJ4};
        CENTRAL_MERIDIAN = UniversalParameters.CENTRAL_MERIDIAN.select(citationArray, "Longitude of natural origin", "central_meridian", "NatOriginLong");
        LATITUDE_OF_ORIGIN = UniversalParameters.LATITUDE_OF_ORIGIN.select(citationArray, "Latitude of natural origin", "latitude_of_origin", "NatOriginLat");
        FALSE_EASTING = UniversalParameters.FALSE_EASTING.select(citationArray, "False easting", "FalseEasting");
        FALSE_NORTHING = UniversalParameters.FALSE_NORTHING.select(citationArray, "False northing", "FalseNorthing");
        PARAMETERS = UniversalParameters.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Polyconic"), new NamedIdentifier((Citation)Citations.EPSG, "American Polyconic"), new IdentifierCode((Citation)Citations.EPSG, 9818), new NamedIdentifier(Citations.GEOTIFF, "CT_Polyconic"), new IdentifierCode(Citations.GEOTIFF, 22)}, citationArray, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, FALSE_EASTING, FALSE_NORTHING}, 1);
    }
}

