/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import java.io.IOException;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.io.Installation;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.geotoolkit.referencing.operation.transform.NadconTransform;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@Immutable
public class NADCON
extends MathTransformProvider {
    private static final long serialVersionUID = -4707304160205218546L;
    @Deprecated
    public static final ParameterDescriptor<String> LAT_DIFF_FILE = new DefaultParameterDescriptor<String>((Citation)Citations.EPSG, "Latitude difference file", String.class, null, "conus.las", null, null, null, true);
    @Deprecated
    public static final ParameterDescriptor<String> LONG_DIFF_FILE = new DefaultParameterDescriptor<String>((Citation)Citations.EPSG, "Longitude difference file", String.class, null, "conus.los", null, null, null, true);
    public static final ParameterDescriptorGroup PARAMETERS = UniversalParameters.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier((Citation)Citations.EPSG, "NADCON"), new IdentifierCode((Citation)Citations.EPSG, 9613), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)199))}, null, new ParameterDescriptor[]{LAT_DIFF_FILE, LONG_DIFF_FILE}, 0);

    public NADCON() {
        super(2, 2, PARAMETERS);
    }

    public static boolean isAvailable() {
        try {
            return Installation.NADCON.exists(NadconTransform.class, "conus.las") && Installation.NADCON.exists(NadconTransform.class, "conus.los");
        }
        catch (IOException iOException) {
            Logging.recoverableException(NADCON.class, (String)"isAvailable", (Throwable)iOException);
            return false;
        }
    }

    public Class<Transformation> getOperationType() {
        return Transformation.class;
    }

    @Override
    protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws FactoryException {
        String string = Parameters.stringValue(LAT_DIFF_FILE, parameterValueGroup);
        String string2 = Parameters.stringValue(LONG_DIFF_FILE, parameterValueGroup);
        return new NadconTransform(string2, string);
    }
}

