/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.Stereographic;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class ObliqueStereographic
extends Stereographic {
    private static final long serialVersionUID = -1454098847621943639L;
    private static final double ITERATION_TOLERANCE = 1.0E-14;
    private final double C;
    private final double K;
    private final double ratexp;
    private final double phic0;
    private final double cosc0;
    private final double sinc0;

    protected ObliqueStereographic(UnitaryProjection.Parameters parameters) {
        super(parameters, parameters.latitudeOfOrigin);
        double d = this.cos\u03c60 * this.cos\u03c60;
        double d2 = 2.0 * Math.sqrt(1.0 - this.excentricitySquared) / (1.0 - this.excentricitySquared * (this.sin\u03c60 * this.sin\u03c60));
        this.C = Math.sqrt(1.0 + this.excentricitySquared * (d * d) / (1.0 - this.excentricitySquared));
        this.phic0 = Math.asin(this.sin\u03c60 / this.C);
        this.sinc0 = Math.sin(this.phic0);
        this.cosc0 = Math.cos(this.phic0);
        this.ratexp = 0.5 * this.C * this.excentricity;
        this.K = Math.tan(0.5 * this.phic0 + 0.7853981633974483) / (Math.pow(Math.tan(0.5 * this.\u03c60 + 0.7853981633974483), this.C) * ObliqueStereographic.srat(this.excentricity * this.sin\u03c60, this.ratexp));
        parameters.normalize(true).scale(this.C, 1.0);
        parameters.validate();
        parameters.normalize(false).scale(d2, d2);
        this.finish();
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = this.rollLongitude(dArray[n]);
        double d6 = dArray[n + 1];
        double d7 = Math.sin(d5);
        double d8 = Math.cos(d5);
        if (dArray2 != null) {
            d4 = 2.0 * Math.atan(this.K * Math.pow(Math.tan(0.5 * d6 + 0.7853981633974483), this.C) * ObliqueStereographic.srat(this.excentricity * Math.sin(d6), this.ratexp)) - 1.5707963267948966;
            d3 = Math.sin(d4);
            d2 = Math.cos(d4);
            d = 1.0 + this.sinc0 * d3 + this.cosc0 * d2 * d8;
            dArray2[n2] = d2 * d7 / d;
            dArray2[n2 + 1] = (this.cosc0 * d3 - this.sinc0 * d2 * d8) / d;
        }
        if (!bl) {
            return null;
        }
        d4 = Math.sin(0.5 * d6 + 0.7853981633974483);
        d3 = Math.cos(0.5 * d6 + 0.7853981633974483);
        d2 = this.excentricity * Math.sin(d6);
        d = this.excentricity * Math.cos(d6);
        double d9 = Math.pow(d4 / d3, this.C);
        double d10 = 0.5 * this.C / (d4 * d3);
        double d11 = this.K * d9 * ObliqueStereographic.srat(d2, this.ratexp);
        double d12 = d11 + 1.0 / d11;
        double d13 = d11 - 1.0 / d11;
        double d14 = d13 * this.sinc0;
        double d15 = d13 * this.cosc0;
        double d16 = 2.0 * (d10 + ObliqueStereographic.dsrat_d\u03c6(d2, d, this.ratexp)) / d12;
        double d17 = d14 + 2.0 * d8 * this.cosc0 + d12;
        double d18 = d15 - 2.0 * d8 * this.sinc0;
        double d19 = 2.0 * this.sinc0 - d8 * d15;
        double d20 = 2.0 * this.cosc0 + d8 * d14;
        double d21 = d17 * d17;
        return new Matrix2(2.0 * (d8 * (d12 + d14) + 2.0 * this.cosc0) / d21, -d16 * d7 * (d13 * d17 + d19 * 2.0) / d21, 2.0 * d7 * (this.sinc0 * d17 + this.cosc0 * d18) / d21, d16 * (d20 * d17 - d19 * d18) / d21);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = dArray[n];
        double d6 = dArray[n + 1];
        double d7 = Math.hypot(d5, d6);
        if (Math.abs(d7) < 1.0E-6) {
            d4 = 0.0;
            d3 = this.phic0;
        } else {
            d2 = 2.0 * Math.atan(d7);
            double d8 = Math.sin(d2);
            double d9 = Math.cos(d2);
            d4 = Math.atan2(d5 * d8, d7 * this.cosc0 * d9 - d6 * this.sinc0 * d8);
            d3 = d9 * this.sinc0 + d6 * d8 * this.cosc0 / d7;
            d3 = Math.abs(d3) >= 1.0 ? Math.copySign(1.5707963267948966, d3) : Math.asin(d3);
        }
        d2 = Math.pow(Math.tan(0.5 * d3 + 0.7853981633974483) / this.K, 1.0 / this.C);
        int n3 = 15;
        while (!(Math.abs((d = 2.0 * Math.atan(d2 * ObliqueStereographic.srat(this.excentricity * Math.sin(d3), -0.5 * this.excentricity)) - 1.5707963267948966) - d3) < 1.0E-14)) {
            d3 = d;
            if (--n3 >= 0) continue;
            throw new ProjectionException(152);
        }
        dArray2[n2] = this.unrollLongitude(d4);
        dArray2[n2 + 1] = d3;
    }

    private static double srat(double d, double d2) {
        return Math.pow((1.0 - d) / (1.0 + d), d2);
    }

    private static double dsrat_d\u03c6(double d, double d2, double d3) {
        return -2.0 * d3 * d2 / (1.0 - d * d);
    }
}

