/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.math.XMath;
import org.geotoolkit.measure.Angle;
import org.geotoolkit.measure.Latitude;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.referencing.operation.provider.HotineObliqueMercator;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ComparisonMode;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class ObliqueMercator
extends UnitaryProjection {
    private static final long serialVersionUID = 5382294977124711214L;
    private static final double EPSILON = 1.0E-6;
    private static final double FINER_EPSILON = 1.0E-10;
    private final double B;
    private final double E;
    private final double v_pole_n;
    private final double v_pole_s;
    private final double singamma0;
    private final double cosgamma0;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        Parameters parameters = new Parameters(parameterDescriptorGroup, parameterValueGroup);
        ObliqueMercator obliqueMercator = new ObliqueMercator(parameters);
        return obliqueMercator.createConcatenatedTransform();
    }

    protected ObliqueMercator(Parameters parameters) {
        super(parameters);
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        boolean bl = parameters.usesTwoPoints();
        parameters.validate(bl);
        double d6 = Math.toRadians(parameters.latitudeOfCentre);
        double d7 = Math.sqrt(1.0 - this.excentricitySquared);
        double d8 = Math.sin(d6);
        double d9 = Math.cos(d6);
        double d10 = d9 * d9;
        this.B = Math.sqrt(1.0 + this.excentricitySquared * (d10 * d10) / (1.0 - this.excentricitySquared));
        double d11 = 1.0 - this.excentricitySquared * (d8 * d8);
        double d12 = this.B * d7 / d11;
        double d13 = this.B * d7 / (d9 * Math.sqrt(d11));
        double d14 = d13 * d13 - 1.0;
        d14 = d14 < 0.0 ? 0.0 : Math.copySign(Math.sqrt(d14), d6);
        this.E = (d14 += d13) * Math.pow(this.tsfn(d6, d8), this.B);
        double d15 = Math.toRadians(parameters.longitudeOfCentre);
        if (bl) {
            d5 = Math.toRadians(parameters.latitudeOf1stPoint);
            double d16 = Math.toRadians(parameters.latitudeOf2ndPoint);
            double d17 = Math.toRadians(parameters.longitudeOf1stPoint);
            double d18 = Math.toRadians(parameters.longitudeOf2ndPoint);
            double d19 = Math.pow(this.tsfn(d5, Math.sin(d5)), this.B);
            double d20 = Math.pow(this.tsfn(d16, Math.sin(d16)), this.B);
            double d21 = this.E / d19;
            double d22 = (d20 - d19) / (d20 + d19);
            double d23 = this.E * this.E;
            d23 = (d23 - d20 * d19) / (d23 + d20 * d19);
            double d24 = d17 - d18;
            if (Math.abs(d24) > Math.PI) {
                d18 = Math.toRadians(parameters.longitudeOf2ndPoint += Math.copySign(360.0, d24));
                d24 = d17 - d18;
            }
            d10 = 0.5 * (d17 + d18);
            d4 = ObliqueMercator.rollLongitude(d10 -= Math.atan(d23 * Math.tan(0.5 * this.B * d24) / d22) / this.B, Math.PI);
            d24 = ObliqueMercator.rollLongitude(d17 - d4, Math.PI);
            d3 = Math.atan(2.0 * Math.sin(this.B * d24) / (d21 - 1.0 / d21));
            d = d2 = Math.asin(d13 * Math.sin(d3));
            parameters.azimuth = parameters.rectifiedGridAngle = Math.toDegrees(d2);
        } else {
            d = Math.toRadians(parameters.azimuth);
            if (d > -4.71238898038469 && d < -1.5707963267948966 || d > 1.5707963267948966 && d < 4.71238898038469) {
                String string = UniversalParameters.AZIMUTH.getName().getCode();
                Angle angle = new Angle(parameters.azimuth);
                throw new InvalidParameterValueException(Errors.format((int)73, (Object)string, (Object)angle), string, (Object)angle);
            }
            if (Double.isNaN(parameters.rectifiedGridAngle)) {
                parameters.rectifiedGridAngle = parameters.azimuth;
            }
            d2 = Math.toRadians(parameters.rectifiedGridAngle);
            d3 = Math.asin(Math.sin(d) / d13);
            d10 = 0.5 * (d14 - 1.0 / d14) * Math.tan(d3);
            if (Math.abs(d10) > 1.0) {
                if (Math.abs(Math.abs(d10) - 1.0) > 1.0E-6) {
                    throw new IllegalArgumentException(Errors.format((int)199));
                }
                d10 = Math.copySign(1.0, d10);
            }
            d4 = d15 - Math.asin(d10) / this.B;
        }
        parameters.centralMeridian = Math.toDegrees(d4);
        this.singamma0 = Math.sin(d3);
        this.cosgamma0 = Math.cos(d3);
        this.v_pole_n = Math.log(Math.tan(0.5 * (1.5707963267948966 - d3)));
        this.v_pole_s = Math.log(Math.tan(0.5 * (1.5707963267948966 + d3)));
        d5 = d12 / this.B;
        parameters.validate();
        AffineTransform affineTransform = parameters.normalize(false);
        affineTransform.rotate(-d2);
        if (!parameters.nameMatches(HotineObliqueMercator.PARAMETERS) && !parameters.nameMatches(HotineObliqueMercator.TwoPoint.PARAMETERS)) {
            double d25 = Math.abs(Math.abs(d) - 1.5707963267948966) < 1.0E-10 ? d12 * (d15 - d4) : Math.copySign(d5 * Math.atan2(Math.sqrt(d13 * d13 - 1.0), Math.cos(d)), d6);
            affineTransform.translate(0.0, -d25);
        }
        affineTransform.scale(d5, d5);
        this.finish();
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d;
        double d2;
        double d3 = this.rollLongitude(dArray[n]);
        double d4 = dArray[n + 1];
        Matrix2 matrix2 = null;
        if (Math.abs(Math.abs(d4) - 1.5707963267948966) > 1.0E-6) {
            double d5 = Math.sin(d4);
            double d6 = this.E / Math.pow(this.tsfn(d4, d5), this.B);
            double d7 = 1.0 / d6;
            double d8 = 0.5 * (d6 - d7);
            double d9 = 0.5 * (d6 + d7);
            double d10 = Math.sin(this.B * d3);
            double d11 = (d8 * this.singamma0 - d10 * this.cosgamma0) / d9;
            if (Math.abs(Math.abs(d11) - 1.0) < 1.0E-6) {
                throw new ProjectionException(97, "v");
            }
            double d12 = Math.cos(this.B * d3);
            d2 = Math.abs(d12) < 1.0E-10 ? d3 * (this.B * this.B) : Math.atan2(d8 * this.cosgamma0 + d10 * this.singamma0, d12);
            d = XMath.atanh((double)(-d11));
            if (bl) {
                double d13;
                double d14;
                double d15;
                double d16 = -this.B * d6 * this.dtsfn_d\u03c6(d4, d5, Math.cos(d4));
                double d17 = -this.B * (this.cosgamma0 / d9) * d12;
                double d18 = d16 * (this.singamma0 + (this.singamma0 + d11) / (d6 * d6) - d11) / (2.0 * d9);
                if (Math.abs(d12) < 1.0E-10) {
                    d15 = this.B * this.B;
                    d14 = 0.0;
                } else {
                    d13 = 0.5 * d16 * (1.0 + 1.0 / (d6 * d6));
                    double d19 = d8 * this.cosgamma0 + d10 * this.singamma0;
                    double d20 = Math.hypot(d12, d19);
                    double d21 = d20 + d12;
                    double d22 = d21 * d21 + d19 * d19;
                    d15 = 2.0 * this.B * (d12 * (this.singamma0 * d21 + (d10 - this.singamma0 * d19) * d19 / d20) + d10 * d19) / d22;
                    d14 = 2.0 * this.cosgamma0 * d13 * (d21 - d19 * d19 / d20) / d22;
                }
                d13 = d11 * d11 - 1.0;
                matrix2 = new Matrix2(d17 / d13, d18 / d13, d15, d14);
            }
        } else {
            d = d4 > 0.0 ? this.v_pole_n : this.v_pole_s;
            d2 = d4;
            if (bl) {
                matrix2 = new Matrix2(0.0, 0.0, 0.0, 1.0);
            }
        }
        if (dArray2 != null) {
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }
        return matrix2;
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3 = dArray[n];
        double d4 = dArray[n + 1];
        double d5 = Math.exp(-d3);
        double d6 = 1.0 / d5;
        double d7 = 0.5 * (d5 - d6);
        double d8 = Math.sin(d4);
        double d9 = (d8 * this.cosgamma0 + d7 * this.singamma0) / (0.5 * (d5 + d6));
        if (Math.abs(Math.abs(d9) - 1.0) < 1.0E-6) {
            d2 = 0.0;
            d = Math.copySign(1.5707963267948966, d9);
        } else {
            d2 = -Math.atan2(d7 * this.cosgamma0 - d8 * this.singamma0, Math.cos(d4)) / this.B;
            d = this.cphi2(Math.pow(this.E / Math.sqrt((1.0 + d9) / (1.0 - d9)), 1.0 / this.B));
        }
        dArray2[n2] = this.unrollLongitude(d2);
        dArray2[n2 + 1] = d;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            ObliqueMercator obliqueMercator = (ObliqueMercator)object;
            return InternalUtilities.epsilonEqual((double)this.B, (double)obliqueMercator.B, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.E, (double)obliqueMercator.E, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.singamma0, (double)obliqueMercator.singamma0, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.cosgamma0, (double)obliqueMercator.cosgamma0, (ComparisonMode)comparisonMode);
        }
        return false;
    }

    protected static class Parameters
    extends UnitaryProjection.Parameters {
        private static final long serialVersionUID = -5356116159749775517L;
        public double latitudeOfCentre;
        public double longitudeOfCentre;
        public double rectifiedGridAngle;
        public double latitudeOf1stPoint;
        public double longitudeOf1stPoint;
        public double latitudeOf2ndPoint;
        public double longitudeOf2ndPoint;

        public Parameters(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            super(parameterDescriptorGroup, parameterValueGroup);
            List list = parameterDescriptorGroup.descriptors();
            this.latitudeOfCentre = this.latitudeOfOrigin;
            this.longitudeOfCentre = this.centralMeridian;
            this.rectifiedGridAngle = Parameters.doubleValue(list, UniversalParameters.RECTIFIED_GRID_ANGLE, parameterValueGroup);
            this.latitudeOf1stPoint = Parameters.doubleValue(list, UniversalParameters.LAT_OF_1ST_POINT, parameterValueGroup);
            this.longitudeOf1stPoint = Parameters.doubleValue(list, UniversalParameters.LONG_OF_1ST_POINT, parameterValueGroup);
            this.latitudeOf2ndPoint = Parameters.doubleValue(list, UniversalParameters.LAT_OF_2ND_POINT, parameterValueGroup);
            this.longitudeOf2ndPoint = Parameters.doubleValue(list, UniversalParameters.LONG_OF_2ND_POINT, parameterValueGroup);
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            ParameterValueGroup parameterValueGroup = super.getParameterValues();
            ParameterDescriptorGroup parameterDescriptorGroup = this.getParameterDescriptors();
            List list = parameterDescriptorGroup.descriptors();
            Parameters.set(list, UniversalParameters.RECTIFIED_GRID_ANGLE, parameterValueGroup, this.rectifiedGridAngle);
            Parameters.set(list, UniversalParameters.LAT_OF_1ST_POINT, parameterValueGroup, this.latitudeOf1stPoint);
            Parameters.set(list, UniversalParameters.LONG_OF_1ST_POINT, parameterValueGroup, this.longitudeOf1stPoint);
            Parameters.set(list, UniversalParameters.LAT_OF_2ND_POINT, parameterValueGroup, this.latitudeOf2ndPoint);
            Parameters.set(list, UniversalParameters.LONG_OF_2ND_POINT, parameterValueGroup, this.longitudeOf2ndPoint);
            return parameterValueGroup;
        }

        public boolean usesTwoPoints() throws IllegalArgumentException {
            String string;
            boolean bl;
            boolean bl2 = bl = Double.isNaN(this.azimuth) && Double.isNaN(this.rectifiedGridAngle);
            if (bl == Double.isNaN(this.latitudeOf1stPoint)) {
                string = "latitudeOf1stPoint";
            } else if (bl == Double.isNaN(this.longitudeOf1stPoint)) {
                string = "longitudeOf1stPoint";
            } else if (bl == Double.isNaN(this.latitudeOf2ndPoint)) {
                string = "latitudeOf2ndPoint";
            } else if (bl == Double.isNaN(this.longitudeOf2ndPoint)) {
                string = "longitudeOf2ndPoint";
            } else {
                return bl;
            }
            if (bl) {
                throw new ParameterNotFoundException(Errors.format((int)119, (Object)string), string);
            }
            throw new InvalidParameterNameException(Errors.format((int)210, (Object)string), string);
        }

        final void validate(boolean bl) throws IllegalArgumentException {
            String string;
            UniversalParameters universalParameters;
            Parameters.ensureLatitudeInRange(org.geotoolkit.referencing.operation.provider.ObliqueMercator.LATITUDE_OF_CENTRE, this.latitudeOfCentre, false);
            Parameters.ensureLongitudeInRange(org.geotoolkit.referencing.operation.provider.ObliqueMercator.LONGITUDE_OF_CENTRE, this.longitudeOfCentre, true);
            if (!bl) {
                return;
            }
            Parameters.ensureLatitudeInRange(UniversalParameters.LAT_OF_1ST_POINT, this.latitudeOf1stPoint, false);
            Parameters.ensureLongitudeInRange(UniversalParameters.LONG_OF_1ST_POINT, this.longitudeOf1stPoint, true);
            Parameters.ensureLatitudeInRange(UniversalParameters.LAT_OF_2ND_POINT, this.latitudeOf2ndPoint, true);
            Parameters.ensureLongitudeInRange(UniversalParameters.LONG_OF_2ND_POINT, this.longitudeOf2ndPoint, true);
            if (Math.abs(this.latitudeOf1stPoint - this.latitudeOf2ndPoint) < 1.0E-10) {
                universalParameters = UniversalParameters.LAT_OF_1ST_POINT;
                string = UniversalParameters.LAT_OF_2ND_POINT.getName().getCode();
            } else if (Math.abs(this.latitudeOf1stPoint) < 1.0E-10) {
                universalParameters = UniversalParameters.LAT_OF_1ST_POINT;
                string = new Latitude(this.latitudeOf1stPoint);
            } else if (Math.abs(this.latitudeOf2ndPoint + 90.0) < 1.0E-10) {
                universalParameters = UniversalParameters.LAT_OF_2ND_POINT;
                string = new Latitude(this.latitudeOf2ndPoint);
            } else {
                return;
            }
            String string2 = universalParameters.getName().getCode();
            throw new InvalidParameterValueException(Errors.format((int)73, (Object)string2, (Object)string), string2, (Object)string);
        }
    }
}

