/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.referencing.operation.provider.Mercator1SP;
import org.geotoolkit.referencing.operation.provider.Mercator2SP;
import org.geotoolkit.referencing.operation.provider.MillerCylindrical;
import org.geotoolkit.referencing.operation.provider.PseudoMercator;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

@Immutable
public class Mercator
extends UnitaryProjection {
    private static final long serialVersionUID = 2564172914329253286L;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        Mercator mercator = parameters.isSpherical() ? new Spherical(parameters) : (parameters.nameMatches(PseudoMercator.PARAMETERS) ? new Spherical(parameters, true) : new Mercator(parameters));
        return mercator.createConcatenatedTransform();
    }

    protected Mercator(UnitaryProjection.Parameters parameters) {
        super(parameters);
        double d;
        boolean bl = parameters.nameMatches(MillerCylindrical.PARAMETERS);
        switch (parameters.standardParallels.length) {
            default: {
                throw Mercator.unknownParameter(UniversalParameters.STANDARD_PARALLEL_2);
            }
            case 0: {
                break;
            }
            case 1: {
                double d2 = Math.abs(parameters.standardParallels[0]);
                UnitaryProjection.Parameters.ensureLatitudeInRange(Mercator2SP.STANDARD_PARALLEL, d2, false);
                parameters.standardParallels[0] = d2;
                d2 = Math.toRadians(d2);
                if (parameters.isSpherical()) {
                    parameters.scaleFactor *= Math.cos(d2);
                    break;
                }
                parameters.scaleFactor *= this.msfn(Math.sin(d2), Math.cos(d2));
                break;
            }
        }
        parameters.validate();
        AffineTransform affineTransform = parameters.normalize(true);
        AffineTransform affineTransform2 = parameters.normalize(false);
        double d3 = Math.toRadians(parameters.latitudeOfOrigin);
        double d4 = Math.sin(d3);
        double d5 = Math.cos(d3) / Math.sqrt(1.0 - this.excentricitySquared * (d4 * d4));
        affineTransform2.scale(d5, bl ? d5 * 1.25 : d5);
        if (Boolean.FALSE.equals(parameters.rollLongitude) && (d = affineTransform.getTranslateX()) != 0.0 && affineTransform.getShearX() == 0.0 && affineTransform.getShearY() == 0.0) {
            affineTransform.setTransform(affineTransform.getScaleX(), 0.0, 0.0, affineTransform.getScaleY(), 0.0, affineTransform.getTranslateY());
            affineTransform2.translate(d, 0.0);
        }
        if (bl) {
            affineTransform.scale(1.0, 0.8);
        }
        this.finish();
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Mercator1SP.PARAMETERS;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d;
        double d2 = this.rollLongitude(dArray[n]);
        double d3 = dArray[n + 1];
        double d4 = Math.sin(d3);
        double d5 = d4 == 0.0 ? d3 : ((d = Math.abs(d3)) < 1.5707963267948966 ? -Math.log(this.tsfn(d3, d4)) : Math.copySign(d <= 1.5707973267948965 ? Double.POSITIVE_INFINITY : Double.NaN, d3));
        if (dArray2 != null) {
            dArray2[n2] = d2;
            dArray2[n2 + 1] = d5;
        }
        if (!bl) {
            return null;
        }
        d = Math.cos(d3);
        double d6 = d4 * this.excentricity;
        double d7 = (1.0 - d4) / d;
        return new Matrix2(1.0, 0.0, 0.0, 0.5 * (d7 + 1.0 / d7) - this.excentricitySquared * d / (1.0 - d6 * d6));
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (dArray != dArray2 || n != n2 || this.rollLongitude()) {
            super.transform(dArray, n, dArray2, n2, n3);
            return;
        }
        --n2;
        while (--n3 >= 0) {
            double d = dArray2[n2 += 2];
            if (d == 0.0) continue;
            double d2 = Math.abs(d);
            d = d2 < 1.5707963267948966 ? -Math.log(this.tsfn(d, Math.sin(d))) : Math.copySign(d2 <= 1.5707973267948965 ? Double.POSITIVE_INFINITY : Double.NaN, d);
            dArray2[n2] = d;
        }
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n + 1];
        dArray2[n2] = this.unrollLongitude(dArray[n]);
        dArray2[n2 + 1] = this.cphi2(Math.exp(-d));
    }

    @Immutable
    static final class Spherical
    extends Mercator {
        private static final long serialVersionUID = 2383414176395616561L;
        private final boolean pseudo;

        protected Spherical(UnitaryProjection.Parameters parameters) {
            this(parameters, false);
        }

        Spherical(UnitaryProjection.Parameters parameters, boolean bl) {
            super(parameters);
            this.pseudo = bl;
            if (!bl) {
                parameters.ensureSpherical();
            }
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return this.pseudo ? PseudoMercator.PARAMETERS : super.getParameterDescriptors();
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
            double d;
            double d2 = this.rollLongitude(dArray[n]);
            double d3 = dArray[n + 1];
            double d4 = d3 == 0.0 ? d3 : ((d = Math.abs(d3)) < 1.5707963267948966 ? Math.log(Math.tan(0.7853981633974483 + 0.5 * d3)) : Math.copySign(d <= 1.5707973267948965 ? Double.POSITIVE_INFINITY : Double.NaN, d3));
            Matrix2 matrix2 = null;
            if (bl) {
                matrix2 = new Matrix2(1.0, 0.0, 0.0, 1.0 / Math.cos(d3));
            }
            assert (this.pseudo || Assertions.checkDerivative(matrix2, super.transform(dArray, n, dArray2, n2, bl)) && Assertions.checkTransform(dArray2, n2, d2, d4));
            if (dArray2 != null) {
                dArray2[n2] = d2;
                dArray2[n2 + 1] = d4;
            }
            return matrix2;
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            if (dArray != dArray2 || n != n2 || this.rollLongitude()) {
                super.transform(dArray, n, dArray2, n2, n3);
                return;
            }
            --n2;
            while (--n3 >= 0) {
                double d = dArray2[n2 += 2];
                if (d == 0.0) continue;
                double d2 = Math.abs(d);
                d = d2 < 1.5707963267948966 ? Math.log(Math.tan(0.7853981633974483 + 0.5 * d)) : Math.copySign(d2 <= 1.5707973267948965 ? Double.POSITIVE_INFINITY : Double.NaN, d);
                dArray2[n2] = d;
            }
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = this.unrollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            d2 = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-d2));
            assert (this.pseudo || this.checkInverseTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.inverseTransform(dArray, n, dArray2, n2);
            return Assertions.checkInverseTransform(dArray2, n2, d, d2);
        }
    }
}

