/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.matrix;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.geotoolkit.math.XMath;
import org.geotoolkit.resources.Errors;

public class XAffineTransform
extends AffineTransform {
    private static final long serialVersionUID = 5215291166450556451L;

    protected XAffineTransform() {
    }

    public XAffineTransform(AffineTransform affineTransform) {
        super(affineTransform);
    }

    public XAffineTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        super(d, d2, d3, d4, d5, d6);
    }

    protected void checkPermission() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(Errors.format((int)228));
    }

    @Override
    public void translate(double d, double d2) {
        this.checkPermission();
        super.translate(d, d2);
    }

    @Override
    public void rotate(double d) {
        this.checkPermission();
        super.rotate(d);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.checkPermission();
        super.rotate(d, d2, d3);
    }

    @Override
    public void rotate(double d, double d2) {
        this.checkPermission();
        super.rotate(d, d2);
    }

    @Override
    public void rotate(double d, double d2, double d3, double d4) {
        this.checkPermission();
        super.rotate(d, d2, d3, d4);
    }

    @Override
    public void quadrantRotate(int n) {
        this.checkPermission();
        super.quadrantRotate(n);
    }

    @Override
    public void quadrantRotate(int n, double d, double d2) {
        this.checkPermission();
        super.quadrantRotate(n, d, d2);
    }

    @Override
    public void scale(double d, double d2) {
        this.checkPermission();
        super.scale(d, d2);
    }

    @Override
    public void shear(double d, double d2) {
        this.checkPermission();
        super.shear(d, d2);
    }

    @Override
    public void setToIdentity() {
        this.checkPermission();
        super.setToIdentity();
    }

    @Override
    public void setToTranslation(double d, double d2) {
        this.checkPermission();
        super.setToTranslation(d, d2);
    }

    @Override
    public void setToRotation(double d) {
        this.checkPermission();
        super.setToRotation(d);
    }

    @Override
    public void setToRotation(double d, double d2, double d3) {
        this.checkPermission();
        super.setToRotation(d, d2, d3);
    }

    @Override
    public void setToRotation(double d, double d2) {
        this.checkPermission();
        super.setToRotation(d, d2);
    }

    @Override
    public void setToRotation(double d, double d2, double d3, double d4) {
        this.checkPermission();
        super.setToRotation(d, d2, d3, d4);
    }

    @Override
    public void setToQuadrantRotation(int n) {
        this.checkPermission();
        super.setToQuadrantRotation(n);
    }

    @Override
    public void setToQuadrantRotation(int n, double d, double d2) {
        this.checkPermission();
        super.setToQuadrantRotation(n, d, d2);
    }

    @Override
    public void setToScale(double d, double d2) {
        this.checkPermission();
        super.setToScale(d, d2);
    }

    @Override
    public void setToShear(double d, double d2) {
        this.checkPermission();
        super.setToShear(d, d2);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.checkPermission();
        super.setTransform(affineTransform);
    }

    @Override
    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.checkPermission();
        super.setTransform(d, d2, d3, d4, d5, d6);
    }

    @Override
    public void concatenate(AffineTransform affineTransform) {
        this.checkPermission();
        super.concatenate(affineTransform);
    }

    @Override
    public void preConcatenate(AffineTransform affineTransform) {
        this.checkPermission();
        super.preConcatenate(affineTransform);
    }

    @Override
    public void invert() throws NoninvertibleTransformException {
        this.checkPermission();
        super.invert();
    }

    public boolean isIdentity(double d) {
        return XAffineTransform.isIdentity(this, d);
    }

    public static boolean isIdentity(AffineTransform affineTransform, double d) {
        if (affineTransform.isIdentity()) {
            return true;
        }
        d = Math.abs(d);
        return Math.abs(affineTransform.getScaleX() - 1.0) <= d && Math.abs(affineTransform.getScaleY() - 1.0) <= d && Math.abs(affineTransform.getShearX()) <= d && Math.abs(affineTransform.getShearY()) <= d && Math.abs(affineTransform.getTranslateX()) <= d && Math.abs(affineTransform.getTranslateY()) <= d;
    }

    public static Shape transform(AffineTransform affineTransform, Shape shape, boolean bl) {
        int n = affineTransform.getType();
        if (n == 0) {
            return shape;
        }
        if ((n & 0x30) == 0) {
            if (shape instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)shape;
                return XAffineTransform.transform(affineTransform, rectangle2D, bl ? rectangle2D : null);
            }
            if ((n & 0x58) == 0 && shape instanceof RectangularShape) {
                RectangularShape rectangularShape = (RectangularShape)shape;
                if (!bl) {
                    rectangularShape = (RectangularShape)rectangularShape.clone();
                }
                Rectangle2D rectangle2D = rectangularShape.getFrame();
                rectangularShape.setFrame(XAffineTransform.transform(affineTransform, rectangle2D, rectangle2D));
                return rectangularShape;
            }
        }
        if (shape instanceof Path2D) {
            Path2D path2D = (Path2D)shape;
            if (bl) {
                path2D.transform(affineTransform);
            } else {
                shape = path2D.createTransformedShape(affineTransform);
            }
        } else if (shape instanceof Area) {
            Area area = (Area)shape;
            if (bl) {
                area.transform(affineTransform);
            } else {
                shape = area.createTransformedArea(affineTransform);
            }
        } else {
            shape = new Path2D.Double(shape, affineTransform);
        }
        return shape;
    }

    public static Rectangle2D transform(AffineTransform affineTransform, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        Point2D.Double double_ = new Point2D.Double();
        for (int i = 0; i < 4; ++i) {
            double_.x = (i & 1) == 0 ? rectangle2D.getMinX() : rectangle2D.getMaxX();
            double_.y = (i & 2) == 0 ? rectangle2D.getMinY() : rectangle2D.getMaxY();
            affineTransform.transform(double_, double_);
            if (double_.x < d) {
                d = double_.x;
            }
            if (double_.x > d3) {
                d3 = double_.x;
            }
            if (double_.y < d2) {
                d2 = double_.y;
            }
            if (!(double_.y > d4)) continue;
            d4 = double_.y;
        }
        if (rectangle2D2 != null) {
            rectangle2D2.setRect(d, d2, d3 - d, d4 - d2);
            return rectangle2D2;
        }
        return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
    }

    public static Rectangle2D inverseTransform(AffineTransform affineTransform, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws NoninvertibleTransformException {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        Point2D.Double double_ = new Point2D.Double();
        for (int i = 0; i < 4; ++i) {
            double_.x = (i & 1) == 0 ? rectangle2D.getMinX() : rectangle2D.getMaxX();
            double_.y = (i & 2) == 0 ? rectangle2D.getMinY() : rectangle2D.getMaxY();
            affineTransform.inverseTransform(double_, double_);
            if (double_.x < d) {
                d = double_.x;
            }
            if (double_.x > d3) {
                d3 = double_.x;
            }
            if (double_.y < d2) {
                d2 = double_.y;
            }
            if (!(double_.y > d4)) continue;
            d4 = double_.y;
        }
        if (rectangle2D2 != null) {
            rectangle2D2.setRect(d, d2, d3 - d, d4 - d2);
            return rectangle2D2;
        }
        return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
    }

    public static Point2D inverseDeltaTransform(AffineTransform affineTransform, Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        double d;
        double d2;
        double d3;
        double d4 = affineTransform.getScaleX();
        double d5 = d4 * (d3 = affineTransform.getScaleY()) - (d2 = affineTransform.getShearX()) * (d = affineTransform.getShearY());
        if (!(Math.abs(d5) > Double.MIN_VALUE)) {
            return affineTransform.createInverse().deltaTransform(point2D, point2D2);
        }
        double d6 = point2D.getX();
        double d7 = point2D.getY();
        double d8 = (d6 * d3 - d7 * d2) / d5;
        double d9 = (d7 * d4 - d6 * d) / d5;
        if (point2D2 != null) {
            point2D2.setLocation(d8, d9);
            return point2D2;
        }
        return new Point2D.Double(d8, d9);
    }

    public static int getSwapXY(AffineTransform affineTransform) {
        int n = XAffineTransform.getFlip(affineTransform);
        if (n != 0) {
            double d = XAffineTransform.getScaleX0(affineTransform);
            double d2 = XAffineTransform.getScaleY0(affineTransform) * (double)n;
            double d3 = Math.abs(affineTransform.getShearY() / d2 - affineTransform.getShearX() / d);
            double d4 = Math.abs(affineTransform.getScaleY() / d2 + affineTransform.getScaleX() / d);
            if (d4 > d3) {
                return 1;
            }
            if (d4 < d3) {
                return -1;
            }
        }
        return 0;
    }

    public static double getRotation(AffineTransform affineTransform) {
        int n = XAffineTransform.getFlip(affineTransform);
        if (n != 0) {
            double d = XAffineTransform.getScaleX0(affineTransform);
            double d2 = XAffineTransform.getScaleY0(affineTransform) * (double)n;
            return Math.atan2(affineTransform.getShearY() / d2 - affineTransform.getShearX() / d, affineTransform.getScaleY() / d2 + affineTransform.getScaleX() / d);
        }
        return Double.NaN;
    }

    public static int getFlip(AffineTransform affineTransform) {
        int n = XMath.sgn((double)affineTransform.getScaleX());
        int n2 = XMath.sgn((double)affineTransform.getScaleY());
        int n3 = XMath.sgn((double)affineTransform.getShearX());
        int n4 = XMath.sgn((double)affineTransform.getShearY());
        if (n == n2 && n3 == -n4) {
            return 1;
        }
        if (n == -n2 && n3 == n4) {
            return -1;
        }
        return 0;
    }

    public static double getScaleX0(AffineTransform affineTransform) {
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getShearX();
        if (d2 == 0.0) {
            return Math.abs(d);
        }
        if (d == 0.0) {
            return Math.abs(d2);
        }
        return Math.hypot(d, d2);
    }

    public static double getScaleY0(AffineTransform affineTransform) {
        double d = affineTransform.getScaleY();
        double d2 = affineTransform.getShearY();
        if (d2 == 0.0) {
            return Math.abs(d);
        }
        if (d == 0.0) {
            return Math.abs(d2);
        }
        return Math.hypot(d, d2);
    }

    public static double getScale(AffineTransform affineTransform) {
        return 0.5 * (XAffineTransform.getScaleX0(affineTransform) + XAffineTransform.getScaleY0(affineTransform));
    }

    public static AffineTransform getScaleInstance(double d, double d2, double d3, double d4) {
        return new AffineTransform(d, 0.0, 0.0, d2, (1.0 - d) * d3, (1.0 - d2) * d4);
    }

    public static void roundIfAlmostInteger(AffineTransform affineTransform, double d) {
        double d2;
        double d3 = affineTransform.getScaleX();
        double d4 = Math.rint(d3);
        if (Math.abs(d2 - d3) <= d) {
            double d5;
            d3 = affineTransform.getShearX();
            double d6 = Math.rint(d3);
            if (Math.abs(d5 - d3) <= d) {
                double d7;
                d3 = affineTransform.getScaleY();
                double d8 = Math.rint(d3);
                if (Math.abs(d7 - d3) <= d) {
                    double d9;
                    d3 = affineTransform.getShearY();
                    double d10 = Math.rint(d3);
                    if (!(!(Math.abs(d9 - d3) <= d) || d4 == 0.0 && d6 == 0.0 || d10 == 0.0 && d8 == 0.0)) {
                        double d11;
                        double d12;
                        double d13 = affineTransform.getTranslateX();
                        d3 = Math.rint(d13);
                        if (Math.abs(d12 - d13) <= d) {
                            d13 = d3;
                        }
                        double d14 = affineTransform.getTranslateY();
                        d3 = Math.rint(d14);
                        if (Math.abs(d11 - d14) <= d) {
                            d14 = d3;
                        }
                        affineTransform.setTransform(d4, d10, d6, d8, d13, d14);
                    }
                }
            }
        }
    }
}

