/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.matrix;

import javax.vecmath.Matrix4d;
import org.geotoolkit.math.XMath;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ComparisonMode;
import org.opengis.referencing.operation.Matrix;

public class Matrix4
extends Matrix4d
implements XMatrix {
    private static final long serialVersionUID = 5685762518066856310L;
    public static final int SIZE = 4;

    public Matrix4() {
        this.setIdentity();
    }

    public Matrix4(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        super(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16);
    }

    public Matrix4(double[] dArray) {
        super(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9], dArray[10], dArray[11], dArray[12], dArray[13], dArray[14], dArray[15]);
        if (dArray.length != 16) {
            throw new IllegalArgumentException(Errors.format((int)109));
        }
    }

    public Matrix4(Matrix matrix) throws IllegalArgumentException {
        if (matrix.getNumRow() != 4 || matrix.getNumCol() != 4) {
            throw new IllegalArgumentException(Errors.format((int)85));
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.setElement(i, j, matrix.getElement(i, j));
            }
        }
    }

    public final int getNumRow() {
        return 4;
    }

    public final int getNumCol() {
        return 4;
    }

    public final boolean isIdentity() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.getElement(i, j) == (double)(j == i ? 1 : 0)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean isIdentity(double d) {
        return GeneralMatrix.isIdentity(this, d);
    }

    @Override
    public final boolean isAffine() {
        return this.m30 == 0.0 && this.m31 == 0.0 && this.m32 == 0.0 && this.m33 == 1.0;
    }

    @Override
    public final void multiply(Matrix matrix) {
        Object object = matrix instanceof Matrix4d ? (Matrix4d)matrix : new Matrix4(matrix);
        this.mul((Matrix4d)object);
    }

    @Override
    public final void normalizeColumns() {
        double[] dArray = new double[]{this.m00, this.m10, this.m20, this.m30};
        double d = XMath.magnitude((double[])dArray);
        this.m00 /= d;
        this.m10 /= d;
        this.m20 /= d;
        this.m30 /= d;
        dArray[0] = this.m01;
        dArray[1] = this.m11;
        dArray[2] = this.m21;
        dArray[3] = this.m31;
        d = XMath.magnitude((double[])dArray);
        this.m01 /= d;
        this.m11 /= d;
        this.m21 /= d;
        this.m31 /= d;
        dArray[0] = this.m02;
        dArray[1] = this.m12;
        dArray[2] = this.m22;
        dArray[3] = this.m32;
        d = XMath.magnitude((double[])dArray);
        this.m02 /= d;
        this.m12 /= d;
        this.m22 /= d;
        this.m32 /= d;
        dArray[0] = this.m03;
        dArray[1] = this.m13;
        dArray[2] = this.m23;
        dArray[3] = this.m33;
        d = XMath.magnitude((double[])dArray);
        this.m03 /= d;
        this.m13 /= d;
        this.m23 /= d;
        this.m33 /= d;
    }

    @Override
    public boolean equals(Matrix matrix, double d) {
        return Matrices.equals(this, matrix, d, false);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        return object instanceof Matrix && Matrices.equals(this, (Matrix)object, comparisonMode);
    }

    public String toString() {
        return GeneralMatrix.toString(this);
    }

    @Override
    public Matrix4 clone() {
        return (Matrix4)super.clone();
    }
}

