/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.lang.Buffered;
import org.geotoolkit.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.Cache;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.util.FactoryException;

@Buffered
@ThreadSafe
public class CachingCoordinateOperationFactory
extends AbstractCoordinateOperationFactory {
    private volatile CoordinateOperationFactory factory;
    private final Cache<CRSPair, CoordinateOperation> cache = new Cache();

    public CachingCoordinateOperationFactory() {
        super(EMPTY_HINTS);
    }

    public CachingCoordinateOperationFactory(Hints hints) {
        this(CachingCoordinateOperationFactory.getBackingFactory(hints), hints);
    }

    private CachingCoordinateOperationFactory(CoordinateOperationFactory coordinateOperationFactory, Hints hints) {
        super(coordinateOperationFactory, hints);
        this.factory = coordinateOperationFactory;
        CachingCoordinateOperationFactory.ensureNonNull("factory", coordinateOperationFactory);
    }

    private static CoordinateOperationFactory getBackingFactory(Hints hints) {
        for (CoordinateOperationFactory coordinateOperationFactory : FactoryFinder.getCoordinateOperationFactories((Hints)hints)) {
            if (coordinateOperationFactory instanceof CachingCoordinateOperationFactory) continue;
            return coordinateOperationFactory;
        }
        throw new FactoryNotFoundException(Errors.format((int)63, CoordinateOperationFactory.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final CoordinateOperationFactory getBackingFactory() {
        CoordinateOperationFactory coordinateOperationFactory = this.factory;
        if (coordinateOperationFactory == null) {
            CachingCoordinateOperationFactory cachingCoordinateOperationFactory = this;
            synchronized (cachingCoordinateOperationFactory) {
                coordinateOperationFactory = this.factory;
                if (coordinateOperationFactory == null) {
                    this.factory = coordinateOperationFactory = CachingCoordinateOperationFactory.getBackingFactory(EMPTY_HINTS);
                }
            }
        }
        return coordinateOperationFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinateOperation createOperation(CRSPair cRSPair) throws OperationNotFoundException, FactoryException {
        CoordinateOperation coordinateOperation = (CoordinateOperation)this.cache.peek((Object)cRSPair);
        if (coordinateOperation == null) {
            Cache.Handler handler = this.cache.lock((Object)cRSPair);
            try {
                coordinateOperation = (CoordinateOperation)handler.peek();
                if (coordinateOperation == null) {
                    coordinateOperation = this.getBackingFactory().createOperation(cRSPair.sourceCRS, cRSPair.targetCRS);
                }
            }
            finally {
                handler.putAndUnlock((Object)coordinateOperation);
            }
        }
        return coordinateOperation;
    }

    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws OperationNotFoundException, FactoryException {
        CachingCoordinateOperationFactory.ensureNonNull("sourceCRS", coordinateReferenceSystem);
        CachingCoordinateOperationFactory.ensureNonNull("targetCRS", coordinateReferenceSystem2);
        return this.createOperation(new CRSPair(coordinateReferenceSystem, coordinateReferenceSystem2, null));
    }

    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, OperationMethod operationMethod) throws OperationNotFoundException, FactoryException {
        CachingCoordinateOperationFactory.ensureNonNull("sourceCRS", coordinateReferenceSystem);
        CachingCoordinateOperationFactory.ensureNonNull("targetCRS", coordinateReferenceSystem2);
        CachingCoordinateOperationFactory.ensureNonNull("method", operationMethod);
        return this.createOperation(new CRSPair(coordinateReferenceSystem, coordinateReferenceSystem2, operationMethod));
    }

    @Override
    public OperationMethod createOperationMethod(Map<String, ?> map, Integer n, Integer n2, ParameterDescriptorGroup parameterDescriptorGroup) throws FactoryException {
        return this.getBackingFactory().createOperationMethod(map, n, n2, parameterDescriptorGroup);
    }

    @Override
    public OperationMethod getOperationMethod(String string) throws FactoryException {
        return this.getBackingFactory().getOperationMethod(string);
    }

    private static final class CRSPair {
        private final int hash;
        final CoordinateReferenceSystem sourceCRS;
        final CoordinateReferenceSystem targetCRS;
        private final OperationMethod method;

        public CRSPair(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, OperationMethod operationMethod) {
            this.sourceCRS = coordinateReferenceSystem;
            this.targetCRS = coordinateReferenceSystem2;
            this.method = operationMethod;
            int n = coordinateReferenceSystem.hashCode() * 31 + coordinateReferenceSystem2.hashCode();
            if (operationMethod != null) {
                n = n * 31 + operationMethod.hashCode();
            }
            this.hash = n;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CRSPair) {
                CRSPair cRSPair = (CRSPair)object;
                return Utilities.equals((Object)this.sourceCRS, (Object)cRSPair.sourceCRS) && Utilities.equals((Object)this.targetCRS, (Object)cRSPair.targetCRS) && Utilities.equals((Object)this.method, (Object)cRSPair.method);
            }
            return false;
        }
    }
}

