/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.epsg;

import java.awt.RenderingHints;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NoInitialContextException;
import javax.sql.DataSource;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.JNDI;
import org.geotoolkit.internal.io.Installation;
import org.geotoolkit.internal.referencing.factory.ImplementationHints;
import org.geotoolkit.internal.sql.DefaultDataSource;
import org.geotoolkit.internal.sql.Dialect;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.NoSuchFactoryException;
import org.geotoolkit.referencing.factory.ReferencingFactoryContainer;
import org.geotoolkit.referencing.factory.ThreadedAuthorityFactory;
import org.geotoolkit.referencing.factory.epsg.AnsiDialectEpsgFactory;
import org.geotoolkit.referencing.factory.epsg.DirectEpsgFactory;
import org.geotoolkit.referencing.factory.epsg.EmbeddedDataSource;
import org.geotoolkit.referencing.factory.epsg.HsqlDialectEpsgFactory;
import org.geotoolkit.referencing.factory.epsg.OracleDialectEpsgFactory;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.FactoryException;

@ThreadSafe
@ImplementationHints(forceLongitudeFirst=false)
public class ThreadedEpsgFactory
extends ThreadedAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    public static final String CONFIGURATION_FILE = "EPSG-DataSource.properties";
    private final ReferencingFactoryContainer factories;
    private DataSource datasource;
    protected String schema;
    protected String user;
    protected String password;
    private transient Map<String, String> toANSI;

    public ThreadedEpsgFactory() {
        this(EMPTY_HINTS);
        this.hints.put(Hints.EPSG_DATA_SOURCE, Hints.getSystemDefault((RenderingHints.Key)Hints.EPSG_DATA_SOURCE));
    }

    public ThreadedEpsgFactory(DataSource dataSource) {
        this(EMPTY_HINTS);
        ThreadedEpsgFactory.ensureNonNull("source", dataSource);
        this.hints.put(Hints.EPSG_DATA_SOURCE, dataSource);
    }

    public ThreadedEpsgFactory(Hints hints) {
        super(hints);
        this.factories = ReferencingFactoryContainer.instance(hints);
        this.hints.put(Hints.EPSG_DATA_SOURCE, hints != null ? hints.get((Object)Hints.EPSG_DATA_SOURCE) : null);
        this.setKeyCollisionAllowed(true);
        this.setTimeout(15000L);
    }

    public static String getDefaultURL() {
        try {
            return ThreadedEpsgFactory.getDefaultURL(false);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    static String getDefaultURL(boolean bl) throws IOException {
        File file = bl ? Installation.EPSG.validDirectory(true) : Installation.EPSG.directory(true);
        String string = "derby";
        if (!Dialect.DERBY.isDriverRegistered()) {
            try {
                Class.forName(Dialect.HSQL.driverClass);
                file = new File(file, "HSQL");
                string = "hsqldb";
                bl = false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        StringBuilder stringBuilder = new StringBuilder("jdbc:").append(string).append(':').append(file.getPath().replace(File.separatorChar, '/')).append('/').append("7.09");
        if (bl) {
            stringBuilder.append(";create=true");
        }
        return stringBuilder.toString();
    }

    private static Properties properties() throws FactoryException {
        File file = new File(CONFIGURATION_FILE);
        if (!(file.isFile() || (file = new File(System.getProperty("user.home", "."), CONFIGURATION_FILE)).isFile() || (file = new File(Installation.EPSG.directory(true), "DataSource.properties")).isFile())) {
            return null;
        }
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            throw new FactoryException(Errors.format((int)31, (Object)file), (Throwable)iOException);
        }
        return properties;
    }

    protected synchronized DataSource getDataSource() throws FactoryException {
        DataSource dataSource = this.datasource;
        if (dataSource == null) {
            this.password = null;
            this.user = null;
            this.schema = null;
            Object v = this.hints.get(Hints.EPSG_DATA_SOURCE);
            if (v == null) {
                Properties properties = ThreadedEpsgFactory.properties();
                if (properties != null) {
                    this.schema = properties.getProperty("schema");
                    this.user = properties.getProperty("user");
                    this.password = properties.getProperty("password");
                }
                dataSource = this.createDataSource(properties);
            } else if (v instanceof DataSource) {
                dataSource = (DataSource)v;
            } else {
                try {
                    Object object;
                    Hints hints = EMPTY_HINTS.clone();
                    hints.putAll(this.hints);
                    InitialContext initialContext = JNDI.getInitialContext((Hints)hints);
                    if (v instanceof Name) {
                        object = initialContext.lookup((Name)v);
                    } else {
                        String string = v.toString();
                        string = JNDI.fixName((Context)initialContext, (String)string);
                        object = initialContext.lookup(string);
                    }
                    dataSource = (DataSource)object;
                }
                catch (NoInitialContextException noInitialContextException) {
                    throw new NoSuchFactoryException(Errors.format((int)154), noInitialContextException);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    throw new NoSuchFactoryException(Errors.format((int)154), nameNotFoundException);
                }
                catch (Exception exception) {
                    throw new FactoryException(Errors.format((int)29, v), (Throwable)exception);
                }
            }
            if (dataSource == null) {
                throw new NoSuchFactoryException(Errors.format((int)154));
            }
            this.datasource = dataSource;
        }
        return dataSource;
    }

    protected DataSource createDataSource(Properties properties) throws FactoryException {
        if (properties != null) {
            String string = properties.getProperty("URL");
            if (string != null) {
                return new DefaultDataSource(string);
            }
        } else {
            String string;
            boolean bl = ThreadedEpsgFactory.class.getResource("Data.sql") != null;
            try {
                string = ThreadedEpsgFactory.getDefaultURL(bl);
            }
            catch (IOException iOException) {
                throw new FactoryException((Throwable)iOException);
            }
            if (bl) {
                return EmbeddedDataSource.instance(string);
            }
            return new DefaultDataSource(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAuthorityFactory createBackingStore(Hints hints) throws FactoryException, SQLException {
        AnsiDialectEpsgFactory ansiDialectEpsgFactory;
        Map<String, String> map;
        String string;
        String string2;
        String string3;
        DataSource dataSource = this.getDataSource();
        Object object = this;
        synchronized (object) {
            string3 = this.user;
            string2 = this.password;
            string = this.schema;
            map = this.toANSI;
        }
        Connection connection = string3 != null && string2 != null ? dataSource.getConnection(string3, string2) : dataSource.getConnection();
        connection.setReadOnly(true);
        object = connection.getMetaData();
        switch (Dialect.guess((DatabaseMetaData)object)) {
            case ACCESS: {
                return new DirectEpsgFactory(hints, connection);
            }
            default: {
                if (map != null) {
                    return new AnsiDialectEpsgFactory(hints, connection, map);
                }
                ansiDialectEpsgFactory = new AnsiDialectEpsgFactory(hints, connection);
                break;
            }
            case HSQL: {
                if (map != null) {
                    return new HsqlDialectEpsgFactory(hints, connection, map);
                }
                ansiDialectEpsgFactory = new HsqlDialectEpsgFactory(hints, connection);
                break;
            }
            case ORACLE: {
                if (map != null) {
                    return new OracleDialectEpsgFactory(hints, connection, map);
                }
                ansiDialectEpsgFactory = new OracleDialectEpsgFactory(hints, connection);
            }
        }
        if (string != null) {
            ansiDialectEpsgFactory.setSchema(string, object.getIdentifierQuoteString(), true);
        }
        ansiDialectEpsgFactory.autoconfig((DatabaseMetaData)object);
        ThreadedEpsgFactory threadedEpsgFactory = this;
        synchronized (threadedEpsgFactory) {
            this.toANSI = ansiDialectEpsgFactory.toANSI;
        }
        return ansiDialectEpsgFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory;
        boolean bl = LOGGER.isLoggable(Level.INFO);
        String string = null;
        String string2 = null;
        Hints hints = EMPTY_HINTS.clone();
        Object object = this;
        synchronized (object) {
            hints.putAll(this.hints);
        }
        hints.putAll(this.factories.getImplementationHints());
        try {
            abstractAuthorityFactory = this.createBackingStore(hints);
            if (bl && abstractAuthorityFactory instanceof DirectEpsgFactory) {
                object = ((DirectEpsgFactory)abstractAuthorityFactory).connection.getMetaData();
                string = object.getDatabaseProductName();
                string2 = object.getURL();
            }
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            Throwable throwable;
            String string3 = Errors.format((int)23, (Object)"EPSG");
            String string4 = sQLException.getSQLState();
            if ("08001".equals(string4) || "XJ004".equals(string4)) {
                throw new NoSuchFactoryException(string3, sQLException);
            }
            while ((throwable = sQLException2.getCause()) instanceof SQLException) {
                sQLException2 = (SQLException)throwable;
            }
            throw new FactoryException(string3, (Throwable)sQLException2);
        }
        if (bl) {
            if (string == null) {
                string = '<' + Vocabulary.format((int)309) + '>';
            }
            if (string2 == null) {
                string2 = string;
            }
            object = Loggings.format((Level)Level.INFO, (int)16, (Object)string2, (Object)string);
            ((LogRecord)object).setSourceClassName(ThreadedEpsgFactory.class.getName());
            ((LogRecord)object).setSourceMethodName("createBackingStore");
            ((LogRecord)object).setLoggerName(LOGGER.getName());
            LOGGER.log((LogRecord)object);
        }
        if (abstractAuthorityFactory instanceof DirectEpsgFactory) {
            ((DirectEpsgFactory)abstractAuthorityFactory).buffered = this;
        }
        return abstractAuthorityFactory;
    }

    @Override
    protected boolean canDisposeBackingStore(AbstractAuthorityFactory abstractAuthorityFactory) {
        if (abstractAuthorityFactory instanceof DirectEpsgFactory) {
            return ((DirectEpsgFactory)abstractAuthorityFactory).canDispose();
        }
        return super.canDisposeBackingStore(abstractAuthorityFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(boolean bl) {
        super.dispose(bl);
        ThreadedEpsgFactory threadedEpsgFactory = this;
        synchronized (threadedEpsgFactory) {
            if (bl && this.datasource instanceof DefaultDataSource) {
                ((DefaultDataSource)this.datasource).shutdown();
            }
            this.password = null;
            this.user = null;
            this.schema = null;
            this.datasource = null;
        }
    }
}

