/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.awt.RenderingHints;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.CachingAuthorityFactory;
import org.geotoolkit.referencing.factory.NoSuchFactoryException;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.converter.Classes;
import org.opengis.util.FactoryException;

@ThreadSafe
public abstract class ThreadedAuthorityFactory
extends CachingAuthorityFactory {
    private final Deque<Store> stores;
    private int remainingBackingStores;
    private final ThreadLocal<Usage> current = new ThreadLocal<Usage>(){

        @Override
        protected Usage initialValue() {
            return new Usage();
        }
    };
    private long timeout = 86400000L;
    static final long TIMEOUT_RESOLUTION = 100L;
    private final Runnable disposerTask = new Runnable(){

        @Override
        public void run() {
            ThreadedAuthorityFactory.this.disposeExpired();
        }
    };
    private boolean isActive;
    private volatile boolean hintsInitialized;

    protected ThreadedAuthorityFactory(Hints hints) {
        this(hints, 100, 16);
    }

    protected ThreadedAuthorityFactory(Hints hints, int n, int n2) {
        super(hints, n);
        ThreadedAuthorityFactory.ensureNotSmaller("maxBackingStores", n2, 1);
        this.stores = new LinkedList<Store>();
        this.remainingBackingStores = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        if (!this.hintsInitialized && !this.unavailable()) {
            AbstractAuthorityFactory abstractAuthorityFactory = null;
            try {
                abstractAuthorityFactory = this.getBackingStore();
                try {
                    Map map = abstractAuthorityFactory.getImplementationHints();
                    ThreadedAuthorityFactory threadedAuthorityFactory = this;
                    synchronized (threadedAuthorityFactory) {
                        if (!this.hintsInitialized) {
                            this.hintsInitialized = true;
                            this.hints.putAll(map);
                        }
                    }
                }
                finally {
                    this.release();
                }
            }
            catch (FactoryException factoryException) {
                ThreadedAuthorityFactory threadedAuthorityFactory = this;
                synchronized (threadedAuthorityFactory) {
                    this.unavailable(factoryException, abstractAuthorityFactory);
                    this.hintsInitialized = true;
                }
            }
        }
        return super.getImplementationHints();
    }

    final synchronized int countBackingStores() {
        return this.stores.size();
    }

    protected abstract AbstractAuthorityFactory createBackingStore() throws NoSuchFactoryException, FactoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final AbstractAuthorityFactory getBackingStore() throws FactoryException {
        Usage usage = this.current.get();
        AbstractAuthorityFactory abstractAuthorityFactory = usage.factory;
        if (abstractAuthorityFactory == null) {
            ThreadedAuthorityFactory threadedAuthorityFactory = this;
            synchronized (threadedAuthorityFactory) {
                while (this.remainingBackingStores == 0) {
                    try {
                        ((Object)((Object)this)).wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new FactoryException(interruptedException.getLocalizedMessage(), (Throwable)interruptedException);
                    }
                }
                Store store = this.stores.pollLast();
                if (store != null) {
                    abstractAuthorityFactory = store.factory;
                }
                --this.remainingBackingStores;
            }
            try {
                assert (usage.count == 0);
                if (abstractAuthorityFactory == null && (abstractAuthorityFactory = this.createBackingStore()) == null) {
                    throw new NoSuchFactoryException(Errors.format((int)154));
                }
                usage.factory = abstractAuthorityFactory;
            }
            finally {
                if (abstractAuthorityFactory == null) {
                    threadedAuthorityFactory = this;
                    synchronized (threadedAuthorityFactory) {
                        ++this.remainingBackingStores;
                    }
                }
            }
        }
        ++usage.count;
        return abstractAuthorityFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void release() {
        Usage usage = this.current.get();
        if (--usage.count == 0) {
            ThreadedAuthorityFactory threadedAuthorityFactory = this;
            synchronized (threadedAuthorityFactory) {
                ++this.remainingBackingStores;
                AbstractAuthorityFactory abstractAuthorityFactory = usage.factory;
                usage.factory = null;
                this.stores.addLast(new Store(abstractAuthorityFactory));
                if (!this.isActive) {
                    this.isActive = true;
                    Threads.executeDisposal((Runnable)this.disposerTask, (long)this.timeout);
                }
                ((Object)((Object)this)).notify();
            }
        }
        assert (usage.count >= 0 && usage.factory == null == (usage.count == 0)) : usage.count;
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    public synchronized long getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(long l) {
        ArgumentChecks.ensureStrictlyPositive((String)"delay", (long)l);
        this.timeout = l;
    }

    protected boolean canDisposeBackingStore(AbstractAuthorityFactory abstractAuthorityFactory) {
        return true;
    }

    private void dispose(AbstractAuthorityFactory abstractAuthorityFactory, boolean bl) {
        if (bl || this.canDisposeBackingStore(abstractAuthorityFactory)) {
            abstractAuthorityFactory.dispose(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(boolean bl) {
        AbstractAuthorityFactory[] abstractAuthorityFactoryArray;
        int n = 0;
        ThreadedAuthorityFactory threadedAuthorityFactory = this;
        synchronized (threadedAuthorityFactory) {
            Store store;
            super.dispose(bl);
            this.remainingBackingStores = 0;
            abstractAuthorityFactoryArray = new AbstractAuthorityFactory[this.stores.size()];
            while ((store = this.stores.pollFirst()) != null) {
                abstractAuthorityFactoryArray[n++] = store.factory;
            }
        }
        while (--n >= 0) {
            this.dispose(abstractAuthorityFactoryArray[n], bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disposeExpired() {
        AbstractAuthorityFactory[] abstractAuthorityFactoryArray;
        long l = System.currentTimeMillis();
        int n = 0;
        ThreadedAuthorityFactory threadedAuthorityFactory = this;
        synchronized (threadedAuthorityFactory) {
            abstractAuthorityFactoryArray = new AbstractAuthorityFactory[this.stores.size()];
            Iterator<Store> iterator = this.stores.iterator();
            while (iterator.hasNext()) {
                Store store = iterator.next();
                long l2 = this.timeout - (l - store.timestamp);
                if (l2 > 100L) {
                    Threads.executeDisposal((Runnable)this.disposerTask, (long)l2);
                    break;
                }
                abstractAuthorityFactoryArray[n++] = store.factory;
                iterator.remove();
            }
            this.isActive = !this.stores.isEmpty();
        }
        while (--n >= 0) {
            this.dispose(abstractAuthorityFactoryArray[n], false);
        }
    }

    private static final class Usage {
        AbstractAuthorityFactory factory;
        int count;

        private Usage() {
        }

        public String toString() {
            return "Usage[" + Classes.getShortClassName((Object)((Object)this.factory)) + ": " + this.count + ']';
        }
    }

    private static final class Store {
        final AbstractAuthorityFactory factory;
        final long timestamp;

        Store(AbstractAuthorityFactory abstractAuthorityFactory) {
            this.factory = abstractAuthorityFactory;
            this.timestamp = System.currentTimeMillis();
        }

        public String toString() {
            return String.format("Store[%s at %tT]", Classes.getShortClassName((Object)((Object)this.factory)), this.timestamp);
        }
    }
}

