/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.awt.RenderingHints;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.io.wkt.ReferencingParser;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.lang.Buffered;
import org.geotoolkit.referencing.crs.DefaultCompoundCRS;
import org.geotoolkit.referencing.crs.DefaultDerivedCRS;
import org.geotoolkit.referencing.crs.DefaultEngineeringCRS;
import org.geotoolkit.referencing.crs.DefaultGeocentricCRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.crs.DefaultImageCRS;
import org.geotoolkit.referencing.crs.DefaultProjectedCRS;
import org.geotoolkit.referencing.crs.DefaultTemporalCRS;
import org.geotoolkit.referencing.crs.DefaultVerticalCRS;
import org.geotoolkit.referencing.cs.DefaultAffineCS;
import org.geotoolkit.referencing.cs.DefaultCartesianCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.cs.DefaultCylindricalCS;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.cs.DefaultLinearCS;
import org.geotoolkit.referencing.cs.DefaultPolarCS;
import org.geotoolkit.referencing.cs.DefaultSphericalCS;
import org.geotoolkit.referencing.cs.DefaultTimeCS;
import org.geotoolkit.referencing.cs.DefaultUserDefinedCS;
import org.geotoolkit.referencing.cs.DefaultVerticalCS;
import org.geotoolkit.referencing.datum.DefaultEllipsoid;
import org.geotoolkit.referencing.datum.DefaultEngineeringDatum;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.referencing.datum.DefaultImageDatum;
import org.geotoolkit.referencing.datum.DefaultPrimeMeridian;
import org.geotoolkit.referencing.datum.DefaultTemporalDatum;
import org.geotoolkit.referencing.datum.DefaultVerticalDatum;
import org.geotoolkit.referencing.factory.DatumAliases;
import org.geotoolkit.referencing.factory.ReferencingFactory;
import org.geotoolkit.referencing.operation.DefaultMathTransformFactory;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.util.collection.WeakHashSet;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

@Buffered
@ThreadSafe
public class ReferencingObjectFactory
extends ReferencingFactory
implements CSFactory,
DatumFactory,
CRSFactory {
    private volatile MathTransformFactory mtFactory;
    private DatumFactory datumFactory;
    private final ThreadLocal<ReferencingParser> parser;
    private final WeakHashSet<IdentifiedObject> pool = WeakHashSet.newInstance(IdentifiedObject.class);

    public ReferencingObjectFactory() {
        this(EMPTY_HINTS);
    }

    public ReferencingObjectFactory(Hints hints) {
        this.parser = new ThreadLocal();
        if (!XCollections.isNullOrEmpty((Map)hints)) {
            this.mtFactory = FactoryFinder.getMathTransformFactory((Hints)hints);
        }
    }

    private synchronized DatumFactory getDatumFactory() {
        if (this.datumFactory == null) {
            this.datumFactory = this;
            for (DatumFactory datumFactory : FactoryFinder.getDatumFactories((Hints)EMPTY_HINTS)) {
                if (!(datumFactory instanceof DatumAliases) || ((DatumAliases)datumFactory).getDatumFactory() != this) continue;
                this.datumFactory = datumFactory;
                break;
            }
        }
        return this.datumFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MathTransformFactory getMathTransformFactory() {
        MathTransformFactory mathTransformFactory = this.mtFactory;
        if (mathTransformFactory == null) {
            MathTransformFactory mathTransformFactory2 = FactoryFinder.getMathTransformFactory((Hints)EMPTY_HINTS);
            ReferencingObjectFactory referencingObjectFactory = this;
            synchronized (referencingObjectFactory) {
                mathTransformFactory = this.mtFactory;
                if (mathTransformFactory == null) {
                    this.mtFactory = mathTransformFactory = mathTransformFactory2;
                    this.hints.put(Hints.MATH_TRANSFORM_FACTORY, mathTransformFactory);
                }
            }
        }
        return mathTransformFactory;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        this.getMathTransformFactory();
        return super.getImplementationHints();
    }

    public Ellipsoid createEllipsoid(Map<String, ?> map, double d, double d2, Unit<Length> unit) throws FactoryException {
        DefaultEllipsoid defaultEllipsoid;
        try {
            defaultEllipsoid = DefaultEllipsoid.createEllipsoid(map, d, d2, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultEllipsoid = (Ellipsoid)this.pool.unique((Object)defaultEllipsoid);
        return defaultEllipsoid;
    }

    public Ellipsoid createFlattenedSphere(Map<String, ?> map, double d, double d2, Unit<Length> unit) throws FactoryException {
        DefaultEllipsoid defaultEllipsoid;
        try {
            defaultEllipsoid = DefaultEllipsoid.createFlattenedSphere(map, d, d2, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultEllipsoid = (Ellipsoid)this.pool.unique((Object)defaultEllipsoid);
        return defaultEllipsoid;
    }

    public PrimeMeridian createPrimeMeridian(Map<String, ?> map, double d, Unit<Angle> unit) throws FactoryException {
        DefaultPrimeMeridian defaultPrimeMeridian;
        try {
            defaultPrimeMeridian = new DefaultPrimeMeridian(map, d, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultPrimeMeridian = (PrimeMeridian)this.pool.unique((Object)defaultPrimeMeridian);
        return defaultPrimeMeridian;
    }

    public GeodeticDatum createGeodeticDatum(Map<String, ?> map, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) throws FactoryException {
        DefaultGeodeticDatum defaultGeodeticDatum;
        try {
            defaultGeodeticDatum = new DefaultGeodeticDatum(map, ellipsoid, primeMeridian);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultGeodeticDatum = (GeodeticDatum)this.pool.unique((Object)defaultGeodeticDatum);
        return defaultGeodeticDatum;
    }

    public VerticalDatum createVerticalDatum(Map<String, ?> map, VerticalDatumType verticalDatumType) throws FactoryException {
        DefaultVerticalDatum defaultVerticalDatum;
        try {
            defaultVerticalDatum = new DefaultVerticalDatum(map, verticalDatumType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultVerticalDatum = (VerticalDatum)this.pool.unique((Object)defaultVerticalDatum);
        return defaultVerticalDatum;
    }

    public TemporalDatum createTemporalDatum(Map<String, ?> map, Date date) throws FactoryException {
        DefaultTemporalDatum defaultTemporalDatum;
        try {
            defaultTemporalDatum = new DefaultTemporalDatum(map, date);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultTemporalDatum = (TemporalDatum)this.pool.unique((Object)defaultTemporalDatum);
        return defaultTemporalDatum;
    }

    public EngineeringDatum createEngineeringDatum(Map<String, ?> map) throws FactoryException {
        DefaultEngineeringDatum defaultEngineeringDatum;
        try {
            defaultEngineeringDatum = new DefaultEngineeringDatum(map);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultEngineeringDatum = (EngineeringDatum)this.pool.unique((Object)defaultEngineeringDatum);
        return defaultEngineeringDatum;
    }

    public ImageDatum createImageDatum(Map<String, ?> map, PixelInCell pixelInCell) throws FactoryException {
        DefaultImageDatum defaultImageDatum;
        try {
            defaultImageDatum = new DefaultImageDatum(map, pixelInCell);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultImageDatum = (ImageDatum)this.pool.unique((Object)defaultImageDatum);
        return defaultImageDatum;
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit) throws FactoryException {
        DefaultCoordinateSystemAxis defaultCoordinateSystemAxis;
        try {
            defaultCoordinateSystemAxis = new DefaultCoordinateSystemAxis(map, string, axisDirection, unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultCoordinateSystemAxis = (CoordinateSystemAxis)this.pool.unique((Object)defaultCoordinateSystemAxis);
        return defaultCoordinateSystemAxis;
    }

    public CartesianCS createCartesianCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        DefaultCartesianCS defaultCartesianCS;
        try {
            defaultCartesianCS = new DefaultCartesianCS(map, coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultCartesianCS = (CartesianCS)this.pool.unique((Object)defaultCartesianCS);
        return defaultCartesianCS;
    }

    public CartesianCS createCartesianCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        DefaultCartesianCS defaultCartesianCS;
        try {
            defaultCartesianCS = new DefaultCartesianCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultCartesianCS = (CartesianCS)this.pool.unique((Object)defaultCartesianCS);
        return defaultCartesianCS;
    }

    public AffineCS createAffineCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        DefaultAffineCS defaultAffineCS;
        try {
            defaultAffineCS = new DefaultAffineCS(map, coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultAffineCS = (AffineCS)this.pool.unique((Object)defaultAffineCS);
        return defaultAffineCS;
    }

    public AffineCS createAffineCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        DefaultAffineCS defaultAffineCS;
        try {
            defaultAffineCS = new DefaultAffineCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultAffineCS = (AffineCS)this.pool.unique((Object)defaultAffineCS);
        return defaultAffineCS;
    }

    public PolarCS createPolarCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        DefaultPolarCS defaultPolarCS;
        try {
            defaultPolarCS = new DefaultPolarCS(map, coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultPolarCS = (PolarCS)this.pool.unique((Object)defaultPolarCS);
        return defaultPolarCS;
    }

    public CylindricalCS createCylindricalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        DefaultCylindricalCS defaultCylindricalCS;
        try {
            defaultCylindricalCS = new DefaultCylindricalCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultCylindricalCS = (CylindricalCS)this.pool.unique((Object)defaultCylindricalCS);
        return defaultCylindricalCS;
    }

    public SphericalCS createSphericalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        DefaultSphericalCS defaultSphericalCS;
        try {
            defaultSphericalCS = new DefaultSphericalCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultSphericalCS = (SphericalCS)this.pool.unique((Object)defaultSphericalCS);
        return defaultSphericalCS;
    }

    public EllipsoidalCS createEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        DefaultEllipsoidalCS defaultEllipsoidalCS;
        try {
            defaultEllipsoidalCS = new DefaultEllipsoidalCS(map, coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultEllipsoidalCS = (EllipsoidalCS)this.pool.unique((Object)defaultEllipsoidalCS);
        return defaultEllipsoidalCS;
    }

    public EllipsoidalCS createEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        DefaultEllipsoidalCS defaultEllipsoidalCS;
        try {
            defaultEllipsoidalCS = new DefaultEllipsoidalCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultEllipsoidalCS = (EllipsoidalCS)this.pool.unique((Object)defaultEllipsoidalCS);
        return defaultEllipsoidalCS;
    }

    public VerticalCS createVerticalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        DefaultVerticalCS defaultVerticalCS;
        try {
            defaultVerticalCS = new DefaultVerticalCS(map, coordinateSystemAxis);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultVerticalCS = (VerticalCS)this.pool.unique((Object)defaultVerticalCS);
        return defaultVerticalCS;
    }

    public TimeCS createTimeCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        DefaultTimeCS defaultTimeCS;
        try {
            defaultTimeCS = new DefaultTimeCS(map, coordinateSystemAxis);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultTimeCS = (TimeCS)this.pool.unique((Object)defaultTimeCS);
        return defaultTimeCS;
    }

    public LinearCS createLinearCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        DefaultLinearCS defaultLinearCS;
        try {
            defaultLinearCS = new DefaultLinearCS(map, coordinateSystemAxis);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultLinearCS = (LinearCS)this.pool.unique((Object)defaultLinearCS);
        return defaultLinearCS;
    }

    public UserDefinedCS createUserDefinedCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) throws FactoryException {
        DefaultUserDefinedCS defaultUserDefinedCS;
        try {
            defaultUserDefinedCS = new DefaultUserDefinedCS(map, coordinateSystemAxis, coordinateSystemAxis2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultUserDefinedCS = (UserDefinedCS)this.pool.unique((Object)defaultUserDefinedCS);
        return defaultUserDefinedCS;
    }

    public UserDefinedCS createUserDefinedCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) throws FactoryException {
        DefaultUserDefinedCS defaultUserDefinedCS;
        try {
            defaultUserDefinedCS = new DefaultUserDefinedCS(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultUserDefinedCS = (UserDefinedCS)this.pool.unique((Object)defaultUserDefinedCS);
        return defaultUserDefinedCS;
    }

    public CompoundCRS createCompoundCRS(Map<String, ?> map, CoordinateReferenceSystem ... coordinateReferenceSystemArray) throws FactoryException {
        DefaultCompoundCRS defaultCompoundCRS;
        try {
            defaultCompoundCRS = new DefaultCompoundCRS(map, coordinateReferenceSystemArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultCompoundCRS = (CompoundCRS)this.pool.unique((Object)defaultCompoundCRS);
        return defaultCompoundCRS;
    }

    public EngineeringCRS createEngineeringCRS(Map<String, ?> map, EngineeringDatum engineeringDatum, CoordinateSystem coordinateSystem) throws FactoryException {
        DefaultEngineeringCRS defaultEngineeringCRS;
        try {
            defaultEngineeringCRS = new DefaultEngineeringCRS(map, engineeringDatum, coordinateSystem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultEngineeringCRS = (EngineeringCRS)this.pool.unique((Object)defaultEngineeringCRS);
        return defaultEngineeringCRS;
    }

    public ImageCRS createImageCRS(Map<String, ?> map, ImageDatum imageDatum, AffineCS affineCS) throws FactoryException {
        DefaultImageCRS defaultImageCRS;
        try {
            defaultImageCRS = new DefaultImageCRS(map, imageDatum, affineCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultImageCRS = (ImageCRS)this.pool.unique((Object)defaultImageCRS);
        return defaultImageCRS;
    }

    public TemporalCRS createTemporalCRS(Map<String, ?> map, TemporalDatum temporalDatum, TimeCS timeCS) throws FactoryException {
        DefaultTemporalCRS defaultTemporalCRS;
        try {
            defaultTemporalCRS = new DefaultTemporalCRS(map, temporalDatum, timeCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultTemporalCRS = (TemporalCRS)this.pool.unique((Object)defaultTemporalCRS);
        return defaultTemporalCRS;
    }

    public VerticalCRS createVerticalCRS(Map<String, ?> map, VerticalDatum verticalDatum, VerticalCS verticalCS) throws FactoryException {
        DefaultVerticalCRS defaultVerticalCRS;
        try {
            defaultVerticalCRS = new DefaultVerticalCRS(map, verticalDatum, verticalCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultVerticalCRS = (VerticalCRS)this.pool.unique((Object)defaultVerticalCRS);
        return defaultVerticalCRS;
    }

    public GeocentricCRS createGeocentricCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, CartesianCS cartesianCS) throws FactoryException {
        DefaultGeocentricCRS defaultGeocentricCRS;
        try {
            defaultGeocentricCRS = new DefaultGeocentricCRS(map, geodeticDatum, cartesianCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultGeocentricCRS = (GeocentricCRS)this.pool.unique((Object)defaultGeocentricCRS);
        return defaultGeocentricCRS;
    }

    public GeocentricCRS createGeocentricCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, SphericalCS sphericalCS) throws FactoryException {
        DefaultGeocentricCRS defaultGeocentricCRS;
        try {
            defaultGeocentricCRS = new DefaultGeocentricCRS(map, geodeticDatum, sphericalCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultGeocentricCRS = (GeocentricCRS)this.pool.unique((Object)defaultGeocentricCRS);
        return defaultGeocentricCRS;
    }

    public GeographicCRS createGeographicCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, EllipsoidalCS ellipsoidalCS) throws FactoryException {
        DefaultGeographicCRS defaultGeographicCRS;
        try {
            defaultGeographicCRS = new DefaultGeographicCRS(map, geodeticDatum, ellipsoidalCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        defaultGeographicCRS = (GeographicCRS)this.pool.unique((Object)defaultGeographicCRS);
        return defaultGeographicCRS;
    }

    public DerivedCRS createDerivedCRS(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, Conversion conversion, CoordinateSystem coordinateSystem) throws FactoryException {
        Object object;
        MathTransform mathTransform = conversion.getMathTransform();
        if (mathTransform == null) {
            object = conversion.getParameterValues();
            MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
            mathTransform = mathTransformFactory.createParameterizedTransform(object);
        }
        try {
            object = new DefaultDerivedCRS(map, conversion, coordinateReferenceSystem, mathTransform, coordinateSystem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        object = (DerivedCRS)this.pool.unique(object);
        return object;
    }

    public ProjectedCRS createProjectedCRS(Map<String, ?> map, GeographicCRS geographicCRS, Conversion conversion, CartesianCS cartesianCS) throws FactoryException {
        Object object;
        MathTransform mathTransform;
        MathTransform mathTransform2 = conversion.getMathTransform();
        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
        if (mathTransform2 != null && mathTransformFactory instanceof DefaultMathTransformFactory) {
            mathTransform = ((DefaultMathTransformFactory)mathTransformFactory).createBaseToDerived((CoordinateReferenceSystem)geographicCRS, mathTransform2, (CoordinateSystem)cartesianCS);
        } else {
            object = conversion.getParameterValues();
            mathTransform = mathTransformFactory.createBaseToDerived((CoordinateReferenceSystem)geographicCRS, object, (CoordinateSystem)cartesianCS);
            OperationMethod operationMethod = conversion.getMethod();
            if (!(operationMethod instanceof MathTransformProvider) && !map.containsKey("conversionType") && (operationMethod = mathTransformFactory.getLastMethodUsed()) instanceof MathTransformProvider) {
                HashMap hashMap = new HashMap(map);
                hashMap.put("conversionType", ((MathTransformProvider)operationMethod).getOperationType());
                map = hashMap;
            }
            if (mathTransform2 != null && mathTransform2.equals(mathTransform)) {
                mathTransform = mathTransform2;
            }
        }
        try {
            object = new DefaultProjectedCRS(map, conversion, geographicCRS, mathTransform, cartesianCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        object = (ProjectedCRS)this.pool.unique(object);
        return object;
    }

    public CoordinateReferenceSystem createFromXML(String string) throws FactoryException {
        throw new FactoryException("Not yet implemented");
    }

    public CoordinateReferenceSystem createFromWKT(String string) throws FactoryException {
        ReferencingParser referencingParser = this.parser.get();
        if (referencingParser == null) {
            referencingParser = new ReferencingParser(Symbols.DEFAULT, this.getDatumFactory(), this, this, this.getMathTransformFactory());
            referencingParser.setISOConform(true);
            this.parser.set(referencingParser);
        }
        try {
            return referencingParser.parseCoordinateReferenceSystem(string);
        }
        catch (ParseException parseException) {
            Throwable throwable = parseException.getCause();
            if (throwable instanceof FactoryException) {
                throw (FactoryException)throwable;
            }
            throw new FactoryException((Throwable)parseException);
        }
    }
}

