/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.unit.Unit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.lang.Buffered;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.AuthorityFactoryProxy;
import org.geotoolkit.referencing.factory.CacheRecord;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.referencing.factory.NoSuchFactoryException;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Exceptions;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.Cache;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

@Buffered
@ThreadSafe
public class CachingAuthorityFactory
extends AbstractAuthorityFactory {
    static final int DEFAULT_MAX = 100;
    private final AbstractAuthorityFactory backingStore;
    private volatile transient Object status;
    private volatile transient Citation authority;
    private final Cache<Object, Object> cache;
    @GuardedBy(value="self")
    private final Map<IdentifiedObject, Map<ComparisonMode, IdentifiedObject>> findPool = new WeakHashMap<IdentifiedObject, Map<ComparisonMode, IdentifiedObject>>();

    protected CachingAuthorityFactory(AbstractAuthorityFactory abstractAuthorityFactory) {
        this(abstractAuthorityFactory, 100);
    }

    protected CachingAuthorityFactory(AbstractAuthorityFactory abstractAuthorityFactory, int n) {
        super(abstractAuthorityFactory);
        if (abstractAuthorityFactory instanceof CachingAuthorityFactory) {
            LOGGER.warning("Factory is already caching.");
        }
        this.backingStore = abstractAuthorityFactory;
        CachingAuthorityFactory.ensureNotSmaller("maxStrongReferences", n, 0);
        this.cache = new Cache(20, (long)n, false);
        Map map = this.hints;
        if (abstractAuthorityFactory instanceof DatumAuthorityFactory) {
            map.put(Hints.DATUM_AUTHORITY_FACTORY, abstractAuthorityFactory);
        }
        if (abstractAuthorityFactory instanceof CSAuthorityFactory) {
            map.put(Hints.CS_AUTHORITY_FACTORY, abstractAuthorityFactory);
        }
        if (abstractAuthorityFactory instanceof CRSAuthorityFactory) {
            map.put(Hints.CRS_AUTHORITY_FACTORY, abstractAuthorityFactory);
        }
        if (abstractAuthorityFactory instanceof CoordinateOperationAuthorityFactory) {
            map.put(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, abstractAuthorityFactory);
        }
    }

    CachingAuthorityFactory(Hints hints, int n) {
        super(hints);
        CachingAuthorityFactory.ensureNotSmaller("maxStrongReferences", n, 0);
        this.cache = new Cache(20, (long)n, false);
        this.backingStore = null;
    }

    static void ensureNotSmaller(String string, int n, int n2) {
        if (n < n2) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)string, (Object)n));
        }
    }

    @Override
    final Collection<? super AuthorityFactory> dependencies() {
        Object object;
        try {
            AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
            this.release();
            object = abstractAuthorityFactory;
        }
        catch (FactoryException factoryException) {
            object = factoryException;
        }
        return Collections.singleton(object);
    }

    AbstractAuthorityFactory getBackingStore() throws FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory = this.backingStore;
        if (abstractAuthorityFactory == null) {
            throw new FactoryException(Errors.format((int)51));
        }
        return abstractAuthorityFactory;
    }

    void release() {
    }

    final boolean unavailable() {
        Object object = this.status;
        return object != null && !Boolean.TRUE.equals(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConformanceResult availability() {
        Object object = this.status;
        if (object == null) {
            AbstractAuthorityFactory abstractAuthorityFactory = null;
            try {
                abstractAuthorityFactory = this.getBackingStore();
                try {
                    ConformanceResult conformanceResult = abstractAuthorityFactory.availability();
                    if (conformanceResult instanceof Factory.Availability) {
                        object = ((Factory.Availability)conformanceResult).getFailureCause();
                    }
                    if (object == null) {
                        object = conformanceResult.pass();
                    }
                }
                finally {
                    this.release();
                }
            }
            catch (FactoryException factoryException) {
                this.unavailable(factoryException, abstractAuthorityFactory);
                object = factoryException;
            }
            this.status = object;
        }
        if (object instanceof Throwable) {
            return new Factory.Availability((Factory)this, (Throwable)object);
        }
        return new Factory.Availability(){

            public Boolean pass() {
                return Boolean.TRUE.equals(CachingAuthorityFactory.this.status) && super.pass() != false;
            }
        };
    }

    final void unavailable(FactoryException factoryException, AbstractAuthorityFactory abstractAuthorityFactory) {
        Object object;
        Level level = factoryException instanceof NoSuchFactoryException ? Level.CONFIG : Level.WARNING;
        Citation citation = abstractAuthorityFactory != null ? abstractAuthorityFactory.getAuthority() : CachingAuthorityFactory.getAuthority(((Object)((Object)this)).getClass());
        InternationalString internationalString = null;
        if (citation != null) {
            internationalString = citation.getTitle();
            object = citation.getAlternateTitles();
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    InternationalString internationalString2 = (InternationalString)iterator.next();
                    if (internationalString != null && internationalString2.length() <= internationalString.length()) continue;
                    internationalString = internationalString2;
                }
            }
        }
        if (internationalString == null) {
            internationalString = Vocabulary.formatInternational((int)311);
        }
        object = new LogRecord(level, Exceptions.formatChainedMessages((String)Loggings.getResources(null).getString(51, (Object)internationalString), (Throwable)factoryException));
        ((LogRecord)object).setSourceClassName(((Object)((Object)this)).getClass().getCanonicalName());
        ((LogRecord)object).setSourceMethodName("availability");
        ((LogRecord)object).setThrown(factoryException);
        ((LogRecord)object).setLoggerName(LOGGER.getName());
        LOGGER.log((LogRecord)object);
    }

    @Override
    final boolean sameAuthorityCodes(AuthorityFactory authorityFactory) {
        AbstractAuthorityFactory abstractAuthorityFactory = this.backingStore;
        if (abstractAuthorityFactory != null && abstractAuthorityFactory.sameAuthorityCodes(authorityFactory)) {
            return true;
        }
        return super.sameAuthorityCodes(authorityFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final Citation getCitation(String string) {
        if (this.availability().pass().booleanValue()) {
            AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
            try {
                Citation citation = CachingAuthorityFactory.getCitation(abstractAuthorityFactory, string);
                this.release();
                return citation;
            }
            catch (Throwable throwable) {
                try {
                    this.release();
                    throw throwable;
                }
                catch (FactoryException factoryException) {
                    Logging.unexpectedException((Logger)LOGGER, CachingAuthorityFactory.class, (String)string, (Throwable)factoryException);
                }
            }
        }
        return super.getCitation(string);
    }

    @Override
    public Citation getVendor() {
        return this.getCitation("getVendor");
    }

    @Override
    public Citation getAuthority() {
        Citation citation = this.authority;
        if (citation == null) {
            citation = this.getCitation("getAuthority");
            if (Boolean.TRUE.equals(this.status)) {
                this.authority = citation;
            }
        }
        return citation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBackingStoreDescription() throws FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
        try {
            String string = abstractAuthorityFactory.getBackingStoreDescription();
            return string;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
        try {
            Set set = abstractAuthorityFactory.getAuthorityCodes(clazz);
            return set;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternationalString getDescriptionText(String string) throws NoSuchAuthorityCodeException, FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
        try {
            InternationalString internationalString = abstractAuthorityFactory.getDescriptionText(string);
            return internationalString;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T create(AuthorityFactoryProxy<T> authorityFactoryProxy, String string) throws FactoryException {
        Object object;
        Class clazz;
        block7: {
            clazz = authorityFactoryProxy.type;
            Key key = new Key(clazz, this.trimAuthority(string));
            object = this.cache.peek((Object)key);
            if (!clazz.isInstance(object)) {
                Cache.Handler handler = this.cache.lock((Object)key);
                try {
                    T t;
                    object = handler.peek();
                    if (clazz.isInstance(object)) break block7;
                    AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
                    try {
                        t = authorityFactoryProxy.create(abstractAuthorityFactory, string);
                    }
                    finally {
                        this.release();
                    }
                    object = t;
                    T t2 = t;
                    return t2;
                }
                finally {
                    handler.putAndUnlock(object);
                }
            }
        }
        return clazz.cast(object);
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.OBJECT, string);
    }

    @Override
    public Datum createDatum(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.DATUM, string);
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ENGINEERING_DATUM, string);
    }

    @Override
    public ImageDatum createImageDatum(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.IMAGE_DATUM, string);
    }

    @Override
    public VerticalDatum createVerticalDatum(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.VERTICAL_DATUM, string);
    }

    @Override
    public TemporalDatum createTemporalDatum(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.TEMPORAL_DATUM, string);
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.GEODETIC_DATUM, string);
    }

    @Override
    public Ellipsoid createEllipsoid(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ELLIPSOID, string);
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.PRIME_MERIDIAN, string);
    }

    @Override
    public Extent createExtent(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.EXTENT, string);
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.COORDINATE_SYSTEM, string);
    }

    @Override
    public CartesianCS createCartesianCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.CARTESIAN_CS, string);
    }

    @Override
    public PolarCS createPolarCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.POLAR_CS, string);
    }

    @Override
    public CylindricalCS createCylindricalCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.CYLINDRICAL_CS, string);
    }

    @Override
    public SphericalCS createSphericalCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.SPHERICAL_CS, string);
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ELLIPSOIDAL_CS, string);
    }

    @Override
    public VerticalCS createVerticalCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.VERTICAL_CS, string);
    }

    @Override
    public TimeCS createTimeCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.TIME_CS, string);
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.AXIS, string);
    }

    @Override
    public Unit<?> createUnit(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.UNIT, string);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.CRS, string);
    }

    @Override
    public CompoundCRS createCompoundCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.COMPOUND_CRS, string);
    }

    @Override
    public DerivedCRS createDerivedCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.DERIVED_CRS, string);
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ENGINEERING_CRS, string);
    }

    @Override
    public GeographicCRS createGeographicCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.GEOGRAPHIC_CRS, string);
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.GEOCENTRIC_CRS, string);
    }

    @Override
    public ImageCRS createImageCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.IMAGE_CRS, string);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.PROJECTED_CRS, string);
    }

    @Override
    public TemporalCRS createTemporalCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.TEMPORAL_CRS, string);
    }

    @Override
    public VerticalCRS createVerticalCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.VERTICAL_CRS, string);
    }

    @Override
    public ParameterDescriptor<?> createParameterDescriptor(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.PARAMETER, string);
    }

    @Override
    public OperationMethod createOperationMethod(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.METHOD, string);
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.OPERATION, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws FactoryException {
        Set set;
        CodePair codePair = new CodePair(this.trimAuthority(string), this.trimAuthority(string2));
        Object object = this.cache.peek((Object)codePair);
        if (!(object instanceof Set)) {
            set = this.cache.lock((Object)codePair);
            try {
                object = set.peek();
                if (!(object instanceof Set)) {
                    AbstractAuthorityFactory abstractAuthorityFactory = this.getBackingStore();
                    try {
                        Set set2 = XCollections.unmodifiableSet(abstractAuthorityFactory.createFromCoordinateReferenceSystemCodes(string, string2));
                        object = set2;
                        Set set3 = set2;
                        this.release();
                        return set3;
                    }
                    catch (Throwable throwable) {
                        this.release();
                        throw throwable;
                    }
                }
            }
            finally {
                set.putAndUnlock(object);
            }
        }
        set = (Set)object;
        return set;
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return new Finder(clazz);
    }

    public void printCacheContent(PrintWriter printWriter) {
        CacheRecord.printCacheContent(this.cache, printWriter);
    }

    protected void setKeyCollisionAllowed(boolean bl) {
        this.cache.setKeyCollisionAllowed(bl);
    }

    @Override
    protected void dispose(boolean bl) {
        super.dispose(bl);
        AbstractAuthorityFactory abstractAuthorityFactory = this.backingStore;
        if (abstractAuthorityFactory != null) {
            abstractAuthorityFactory.dispose(bl);
        }
        this.cache.clear();
        this.authority = null;
    }

    @ThreadSafe
    private final class Finder
    extends IdentifiedObjectFinder {
        private transient IdentifiedObjectFinder finder;
        private transient int acquireCount;

        Finder(Class<? extends IdentifiedObject> clazz) {
            super(null, clazz);
        }

        private void acquire() throws FactoryException {
            assert (Thread.holdsLock(this));
            assert (this.acquireCount == 0 == (this.finder == null)) : this.acquireCount;
            if (this.acquireCount == 0) {
                AbstractAuthorityFactory abstractAuthorityFactory = CachingAuthorityFactory.this.getBackingStore();
                this.acquireCount = 1;
                this.finder = abstractAuthorityFactory.getIdentifiedObjectFinder(this.getObjectType());
                this.finder.copyConfiguration(this);
                this.finder.setParent(this);
            } else {
                ++this.acquireCount;
            }
        }

        private void release() {
            assert (Thread.holdsLock(this));
            if (this.acquireCount == 0) {
                return;
            }
            if (--this.acquireCount == 0) {
                this.finder = null;
                CachingAuthorityFactory.this.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Citation getAuthority() throws FactoryException {
            try {
                this.acquire();
                Citation citation = this.finder.getAuthority();
                return citation;
            }
            finally {
                this.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized Set<String> getCodeCandidates(IdentifiedObject identifiedObject) throws FactoryException {
            try {
                this.acquire();
                Set<String> set = this.finder.getCodeCandidates(identifiedObject);
                return set;
            }
            finally {
                this.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final synchronized IdentifiedObject create(String string, int n) throws FactoryException {
            try {
                this.acquire();
                IdentifiedObject identifiedObject = this.finder.create(string, n);
                return identifiedObject;
            }
            finally {
                this.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IdentifiedObject find(IdentifiedObject identifiedObject) throws FactoryException {
            Object object;
            Object object2;
            Map map;
            ComparisonMode comparisonMode = this.getComparisonMode();
            Map map2 = map = CachingAuthorityFactory.this.findPool;
            synchronized (map2) {
                object2 = (Map)map.get(identifiedObject);
                if (object2 != null && (object = (IdentifiedObject)object2.get(comparisonMode)) != null) {
                    return object == NilReferencingObject.INSTANCE ? null : object;
                }
            }
            object2 = this;
            synchronized (object2) {
                try {
                    this.acquire();
                    map2 = this.finder.find(identifiedObject);
                }
                finally {
                    this.release();
                }
            }
            if (map2 != null || this.isFullScanAllowed()) {
                object2 = map;
                synchronized (object2) {
                    object = (Map)map.get(identifiedObject);
                    if (object == null) {
                        object = new EnumMap(ComparisonMode.class);
                        map.put(identifiedObject, object);
                    }
                    object.put(comparisonMode, map2 == null ? NilReferencingObject.INSTANCE : map2);
                }
            }
            return map2;
        }
    }

    private static final class CodePair {
        private final String source;
        private final String target;

        public CodePair(String string, String string2) {
            this.source = string;
            this.target = string2;
        }

        public int hashCode() {
            int n = 0;
            if (this.source != null) {
                n = this.source.hashCode();
            }
            if (this.target != null) {
                n += this.target.hashCode() * 31;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof CodePair) {
                CodePair codePair = (CodePair)object;
                return Utilities.equals((Object)this.source, (Object)codePair.source) && Utilities.equals((Object)this.target, (Object)codePair.target);
            }
            return false;
        }

        public String toString() {
            return "CodePair[" + this.source + " \u21e8 " + this.target + ']';
        }
    }

    private static final class Key {
        final Class<?> type;
        final String code;

        Key(Class<?> clazz, String string) {
            this.type = clazz;
            this.code = string;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.code.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return Utilities.equals(this.type, key.type) && Utilities.equals((Object)this.code, (Object)key.code);
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Key[").append(this.code);
            if (stringBuilder.length() > 15) {
                stringBuilder.setLength(15);
                stringBuilder.append('\u2026');
            }
            return stringBuilder.append(" : ").append(this.type.getSimpleName()).append(']').toString();
        }
    }
}

