/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Duration;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.crs.AbstractSingleCRS;
import org.geotoolkit.referencing.cs.DefaultTimeCS;
import org.geotoolkit.referencing.datum.DefaultTemporalDatum;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.TemporalDatum;

@Immutable
@XmlRootElement(name="TemporalCRS")
public class DefaultTemporalCRS
extends AbstractSingleCRS
implements TemporalCRS {
    private static final long serialVersionUID = 3000119849197222007L;
    public static final DefaultTemporalCRS JULIAN = new DefaultTemporalCRS(DefaultTemporalDatum.JULIAN, DefaultTimeCS.DAYS);
    public static final DefaultTemporalCRS MODIFIED_JULIAN = new DefaultTemporalCRS(DefaultTemporalDatum.MODIFIED_JULIAN, DefaultTimeCS.DAYS);
    public static final DefaultTemporalCRS TRUNCATED_JULIAN = new DefaultTemporalCRS(DefaultTemporalDatum.TRUNCATED_JULIAN, DefaultTimeCS.DAYS);
    public static final DefaultTemporalCRS DUBLIN_JULIAN = new DefaultTemporalCRS(DefaultTemporalDatum.DUBLIN_JULIAN, DefaultTimeCS.DAYS);
    public static final DefaultTemporalCRS UNIX = new DefaultTemporalCRS(DefaultTemporalDatum.UNIX, DefaultTimeCS.SECONDS);
    public static final DefaultTemporalCRS JAVA = new DefaultTemporalCRS(DefaultTemporalDatum.UNIX, DefaultTimeCS.MILLISECONDS);
    private transient UnitConverter toMillis;
    private transient long origin;

    private DefaultTemporalCRS() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultTemporalCRS(TemporalCRS temporalCRS) {
        super((SingleCRS)temporalCRS);
    }

    public DefaultTemporalCRS(TemporalDatum temporalDatum, TimeCS timeCS) {
        this(IdentifiedObjects.getProperties((IdentifiedObject)temporalDatum), temporalDatum, timeCS);
    }

    public DefaultTemporalCRS(String string, TemporalDatum temporalDatum, TimeCS timeCS) {
        this(Collections.singletonMap("name", string), temporalDatum, timeCS);
    }

    public DefaultTemporalCRS(Map<String, ?> map, TemporalDatum temporalDatum, TimeCS timeCS) {
        super(map, (Datum)temporalDatum, (CoordinateSystem)timeCS);
    }

    public static DefaultTemporalCRS castOrCopy(TemporalCRS temporalCRS) {
        return temporalCRS == null || temporalCRS instanceof DefaultTemporalCRS ? (DefaultTemporalCRS)temporalCRS : new DefaultTemporalCRS(temporalCRS);
    }

    private void initializeConverter() {
        this.origin = this.getDatum().getOrigin().getTime();
        this.toMillis = this.getCoordinateSystem().getAxis(0).getUnit().asType(Duration.class).getConverterTo(Units.MILLISECOND);
    }

    @XmlElement(name="temporalCS")
    public TimeCS getCoordinateSystem() {
        return (TimeCS)super.getCoordinateSystem();
    }

    final void setCoordinateSystem(TimeCS timeCS) {
        super.setCoordinateSystem((CoordinateSystem)timeCS);
    }

    @XmlElement(name="temporalDatum")
    public TemporalDatum getDatum() {
        return (TemporalDatum)super.getDatum();
    }

    final void setDatum(TemporalDatum temporalDatum) {
        super.setDatum((Datum)temporalDatum);
    }

    public Date toDate(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return new Date(Math.round(this.toMillis.convert(d)) + this.origin);
    }

    public double toValue(Date date) {
        if (date == null) {
            return Double.NaN;
        }
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return this.toMillis.inverse().convert((double)(date.getTime() - this.origin));
    }
}

