/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.lang.Static;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.referencing.DefaultAuthorityFactory;
import org.geotoolkit.referencing.crs.DefaultCompoundCRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.crs.DefaultVerticalCRS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class CRS
extends Static {
    private static volatile CRSFactory crsFactory;
    private static volatile CRSAuthorityFactory standardFactory;
    private static volatile CRSAuthorityFactory xyFactory;
    private static volatile CoordinateOperationFactory strictFactory;
    private static volatile CoordinateOperationFactory lenientFactory;
    private static volatile Boolean defaultOrder;
    private static volatile Boolean defaultLenient;

    private CRS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CRSFactory getCRSFactory() {
        CRSFactory cRSFactory = crsFactory;
        if (cRSFactory != null) return cRSFactory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            cRSFactory = crsFactory;
            if (cRSFactory != null) return cRSFactory;
            crsFactory = cRSFactory = FactoryFinder.getCRSFactory(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cRSFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CRSAuthorityFactory getAuthorityFactory(Boolean bl) throws FactoryRegistryException {
        CRSAuthorityFactory cRSAuthorityFactory;
        if (bl == null && (bl = defaultOrder) == null) {
            defaultOrder = bl = Boolean.valueOf(Boolean.TRUE.equals(Hints.getSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER)));
        }
        CRSAuthorityFactory cRSAuthorityFactory2 = cRSAuthorityFactory = bl != false ? xyFactory : standardFactory;
        if (cRSAuthorityFactory != null) return cRSAuthorityFactory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            CRSAuthorityFactory cRSAuthorityFactory3 = cRSAuthorityFactory = bl != false ? xyFactory : standardFactory;
            if (cRSAuthorityFactory != null) return cRSAuthorityFactory;
            try {
                cRSAuthorityFactory = DefaultAuthorityFactory.create(bl);
                if (bl.booleanValue()) {
                    xyFactory = cRSAuthorityFactory;
                } else {
                    standardFactory = cRSAuthorityFactory;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new FactoryNotFoundException(null, (Throwable)noSuchElementException);
            }
            return cRSAuthorityFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CoordinateOperationFactory getCoordinateOperationFactory(boolean bl) {
        CoordinateOperationFactory coordinateOperationFactory;
        CoordinateOperationFactory coordinateOperationFactory2 = coordinateOperationFactory = bl ? lenientFactory : strictFactory;
        if (coordinateOperationFactory != null) return coordinateOperationFactory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            CoordinateOperationFactory coordinateOperationFactory3 = coordinateOperationFactory = bl ? lenientFactory : strictFactory;
            if (coordinateOperationFactory != null) return coordinateOperationFactory;
            Hints hints = new Hints();
            if (bl) {
                hints.put((Object)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
            }
            coordinateOperationFactory = FactoryFinder.getCoordinateOperationFactory((Hints)hints);
            if (bl) {
                lenientFactory = coordinateOperationFactory;
            } else {
                strictFactory = coordinateOperationFactory;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return coordinateOperationFactory;
        }
    }

    public static Version getVersion(String string) throws FactoryRegistryException {
        Factory factory;
        ArgumentChecks.ensureNonNull((String)"authority", (Object)string);
        Object object = AuthorityFactoryFinder.getCRSAuthorityFactory((String)string, null);
        HashSet<Factory> hashSet = new HashSet<Factory>();
        while (object instanceof Factory && hashSet.add(factory = (Factory)object)) {
            Map map = factory.getImplementationHints();
            Object v = map.get(Hints.VERSION);
            if (v instanceof Version) {
                return (Version)v;
            }
            object = map.get(Hints.CRS_AUTHORITY_FACTORY);
        }
        return null;
    }

    public static Set<String> getSupportedCodes(String string) {
        ArgumentChecks.ensureNonNull((String)"authority", (Object)string);
        return DefaultAuthorityFactory.getSupportedCodes(string);
    }

    public static Set<String> getSupportedAuthorities(boolean bl) {
        return DefaultAuthorityFactory.getSupportedAuthorities(bl);
    }

    public static CoordinateReferenceSystem decode(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)string);
        return CRS.getAuthorityFactory(null).createCoordinateReferenceSystem(string);
    }

    public static CoordinateReferenceSystem decode(String string, boolean bl) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)string);
        return CRS.getAuthorityFactory(bl).createCoordinateReferenceSystem(string);
    }

    public static CoordinateReferenceSystem parseWKT(String string) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"wkt", (Object)string);
        return CRS.getCRSFactory().createFromWKT(string);
    }

    public static Envelope getEnvelope(CoordinateReferenceSystem coordinateReferenceSystem) {
        Extent extent;
        GeneralEnvelope generalEnvelope = null;
        GeneralEnvelope generalEnvelope2 = null;
        if (coordinateReferenceSystem != null && (extent = coordinateReferenceSystem.getDomainOfValidity()) != null) {
            for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                if (Boolean.FALSE.equals(geographicExtent.getInclusion()) || !(geographicExtent instanceof BoundingPolygon)) continue;
                for (Geometry geometry : ((BoundingPolygon)geographicExtent).getPolygons()) {
                    CoordinateReferenceSystem coordinateReferenceSystem2;
                    Envelope envelope = geometry.getEnvelope();
                    if (envelope == null || (coordinateReferenceSystem2 = envelope.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(coordinateReferenceSystem2, coordinateReferenceSystem)) continue;
                    if (generalEnvelope == null) {
                        generalEnvelope = envelope;
                        continue;
                    }
                    if (generalEnvelope2 == null) {
                        generalEnvelope = generalEnvelope2 = new GeneralEnvelope(generalEnvelope);
                    }
                    generalEnvelope2.add(generalEnvelope);
                }
            }
        }
        if (generalEnvelope == null && (extent = CRS.getGeographicBoundingBox(coordinateReferenceSystem)) != null && !Boolean.FALSE.equals(extent.getInclusion())) {
            GeographicExtent geographicExtent;
            generalEnvelope = generalEnvelope2 = new GeneralEnvelope(new double[]{extent.getWestBoundLongitude(), extent.getSouthBoundLatitude()}, new double[]{extent.getEastBoundLongitude(), extent.getNorthBoundLatitude()});
            SingleCRS singleCRS = CRS.getHorizontalCRS(coordinateReferenceSystem);
            geographicExtent = CRSUtilities.getStandardGeographicCRS2D((CoordinateReferenceSystem)singleCRS);
            generalEnvelope2.setCoordinateReferenceSystem((CoordinateReferenceSystem)geographicExtent);
            try {
                generalEnvelope = CRS.transform(generalEnvelope, (CoordinateReferenceSystem)singleCRS);
            }
            catch (TransformException transformException) {
                generalEnvelope = null;
                CRS.unexpectedException("getEnvelope", (Exception)((Object)transformException));
            }
            generalEnvelope2.setCoordinateReferenceSystem((CoordinateReferenceSystem)singleCRS);
        }
        return generalEnvelope;
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem coordinateReferenceSystem) {
        Extent extent;
        GeographicBoundingBox geographicBoundingBox = null;
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
        if (coordinateReferenceSystem != null && (extent = coordinateReferenceSystem.getDomainOfValidity()) != null) {
            for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                if (!(geographicExtent instanceof GeographicBoundingBox)) continue;
                GeographicBoundingBox geographicBoundingBox2 = (GeographicBoundingBox)geographicExtent;
                if (geographicBoundingBox == null) {
                    geographicBoundingBox = geographicBoundingBox2;
                    continue;
                }
                if (defaultGeographicBoundingBox == null) {
                    defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(geographicBoundingBox);
                    geographicBoundingBox = defaultGeographicBoundingBox;
                }
                defaultGeographicBoundingBox.add(geographicBoundingBox2);
            }
        }
        return geographicBoundingBox;
    }

    public static boolean isHorizontalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        Datum datum;
        int n;
        if (coordinateReferenceSystem instanceof SingleCRS && (n = coordinateReferenceSystem.getCoordinateSystem().getDimension()) == 2 && (datum = ((SingleCRS)coordinateReferenceSystem).getDatum()) instanceof GeodeticDatum) {
            while (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
                coordinateReferenceSystem = ((GeneralDerivedCRS)coordinateReferenceSystem).getBaseCRS();
            }
            return coordinateReferenceSystem instanceof GeographicCRS;
        }
        return false;
    }

    public static SingleCRS getHorizontalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        CoordinateReferenceSystem coordinateReferenceSystem2;
        CoordinateSystem coordinateSystem;
        if (coordinateReferenceSystem instanceof SingleCRS) {
            Datum datum;
            coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
            int n = coordinateSystem.getDimension();
            if (n == 2) {
                datum = ((SingleCRS)coordinateReferenceSystem).getDatum();
                if (datum instanceof GeodeticDatum) {
                    coordinateReferenceSystem2 = coordinateReferenceSystem;
                    while (coordinateReferenceSystem2 instanceof GeneralDerivedCRS) {
                        coordinateReferenceSystem2 = ((GeneralDerivedCRS)coordinateReferenceSystem2).getBaseCRS();
                    }
                    if (coordinateReferenceSystem2 instanceof GeographicCRS) {
                        assert (CRS.isHorizontalCRS(coordinateReferenceSystem)) : coordinateReferenceSystem;
                        return (SingleCRS)coordinateReferenceSystem;
                    }
                }
            } else if (n >= 3 && coordinateReferenceSystem instanceof GeographicCRS) {
                Object object;
                datum = null;
                coordinateReferenceSystem2 = null;
                int n2 = 0;
                block9: for (int i = 0; i < n; ++i) {
                    object = coordinateSystem.getAxis(i);
                    if (!DefaultCoordinateSystemAxis.isCompassDirection(object.getDirection())) continue;
                    switch (n2++) {
                        case 0: {
                            datum = object;
                            continue block9;
                        }
                        case 1: {
                            coordinateReferenceSystem2 = object;
                            continue block9;
                        }
                    }
                }
                if (n2 == 2) {
                    GeographicCRS geographicCRS;
                    EllipsoidalCS ellipsoidalCS;
                    GeodeticDatum geodeticDatum = ((GeographicCRS)coordinateReferenceSystem).getDatum();
                    object = CRSUtilities.changeDimensionInName((IdentifiedObject)coordinateSystem, "3D", "2D");
                    try {
                        ellipsoidalCS = FactoryFinder.getCSFactory(null).createEllipsoidalCS((Map)object, (CoordinateSystemAxis)datum, (CoordinateSystemAxis)coordinateReferenceSystem2);
                    }
                    catch (FactoryException factoryException) {
                        Logging.recoverableException(CRS.class, (String)"getHorizontalCRS", (Throwable)factoryException);
                        ellipsoidalCS = new DefaultEllipsoidalCS((Map<String, ?>)object, (CoordinateSystemAxis)datum, (CoordinateSystemAxis)coordinateReferenceSystem2);
                    }
                    object = CRSUtilities.changeDimensionInName((IdentifiedObject)coordinateReferenceSystem, "3D", "2D");
                    try {
                        geographicCRS = CRS.getCRSFactory().createGeographicCRS((Map)object, geodeticDatum, ellipsoidalCS);
                    }
                    catch (FactoryException factoryException) {
                        Logging.recoverableException(CRS.class, (String)"getHorizontalCRS", (Throwable)factoryException);
                        geographicCRS = new DefaultGeographicCRS((Map<String, ?>)object, geodeticDatum, ellipsoidalCS);
                    }
                    assert (CRS.isHorizontalCRS((CoordinateReferenceSystem)geographicCRS)) : geographicCRS;
                    return geographicCRS;
                }
            }
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            coordinateSystem = (CompoundCRS)coordinateReferenceSystem;
            for (Datum datum : coordinateSystem.getComponents()) {
                coordinateReferenceSystem2 = CRS.getHorizontalCRS((CoordinateReferenceSystem)datum);
                if (coordinateReferenceSystem2 == null) continue;
                assert (CRS.isHorizontalCRS(coordinateReferenceSystem2)) : coordinateReferenceSystem2;
                return coordinateReferenceSystem2;
            }
        }
        return null;
    }

    public static ProjectedCRS getProjectedCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            return (ProjectedCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                ProjectedCRS projectedCRS = CRS.getProjectedCRS(coordinateReferenceSystem2);
                if (projectedCRS == null) continue;
                return projectedCRS;
            }
        }
        return null;
    }

    public static VerticalCRS getVerticalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        CompoundCRS compoundCRS;
        if (coordinateReferenceSystem instanceof VerticalCRS) {
            return (VerticalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                VerticalCRS verticalCRS = CRS.getVerticalCRS(coordinateReferenceSystem2);
                if (verticalCRS == null) continue;
                return verticalCRS;
            }
        }
        if (coordinateReferenceSystem instanceof GeographicCRS && (compoundCRS = coordinateReferenceSystem.getCoordinateSystem()).getDimension() >= 3) {
            assert (AxisDirections.indexOf((CoordinateSystem)compoundCRS, AxisDirection.UP) >= 0) : compoundCRS;
            return DefaultVerticalCRS.ELLIPSOIDAL_HEIGHT;
        }
        return null;
    }

    public static TemporalCRS getTemporalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            return (TemporalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                TemporalCRS temporalCRS = CRS.getTemporalCRS(coordinateReferenceSystem2);
                if (temporalCRS == null) continue;
                return temporalCRS;
            }
        }
        return null;
    }

    public static CompoundCRS getCompoundCRS(CompoundCRS compoundCRS, SingleCRS ... singleCRSArray) {
        CompoundCRS compoundCRS2;
        List<SingleCRS> list = DefaultCompoundCRS.getSingleCRS((CoordinateReferenceSystem)compoundCRS);
        if (list.size() == singleCRSArray.length) {
            int n = 0;
            CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)singleCRSArray.clone();
            compoundCRS2 = list.iterator();
            block0: while (compoundCRS2.hasNext()) {
                SingleCRS singleCRS = compoundCRS2.next();
                for (int i = n; i < ((CoordinateReferenceSystem)coordinateReferenceSystem).length; ++i) {
                    if (!CRS.equalsIgnoreMetadata(singleCRS, coordinateReferenceSystem[i])) continue;
                    System.arraycopy(coordinateReferenceSystem, n, coordinateReferenceSystem, n + 1, i - n);
                    coordinateReferenceSystem[n++] = null;
                    continue block0;
                }
                n = -1;
                break;
            }
            if (n == ((CoordinateReferenceSystem)coordinateReferenceSystem).length) {
                return compoundCRS;
            }
        }
        for (CoordinateReferenceSystem coordinateReferenceSystem : compoundCRS.getComponents()) {
            if (!(coordinateReferenceSystem instanceof CompoundCRS) || (compoundCRS2 = CRS.getCompoundCRS((CompoundCRS)coordinateReferenceSystem, singleCRSArray)) == null) continue;
            return compoundCRS2;
        }
        return null;
    }

    public static CoordinateReferenceSystem getSubCRS(CoordinateReferenceSystem coordinateReferenceSystem, int n, int n2) {
        if (coordinateReferenceSystem != null) {
            int n3 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
            if (n < 0 || n > n2 || n2 > n3) {
                throw new IndexOutOfBoundsException(Errors.format((int)96, (Object)(n < 0 ? n : n2)));
            }
            block0: while (n != 0 || n2 != n3) {
                if (coordinateReferenceSystem instanceof CompoundCRS) {
                    List list = ((CompoundCRS)coordinateReferenceSystem).getComponents();
                    int n4 = list.size();
                    for (int i = 0; i < n4; ++i) {
                        coordinateReferenceSystem = (CoordinateReferenceSystem)list.get(i);
                        n3 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
                        if (n < n3) continue block0;
                        n -= n3;
                        n2 -= n3;
                    }
                }
                return null;
            }
        }
        return coordinateReferenceSystem;
    }

    public static Datum getDatum(CoordinateReferenceSystem coordinateReferenceSystem) {
        return CRSUtilities.getDatum(coordinateReferenceSystem);
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem coordinateReferenceSystem) {
        Object object;
        if (coordinateReferenceSystem instanceof SingleCRS && (object = ((SingleCRS)coordinateReferenceSystem).getDatum()) instanceof GeodeticDatum) {
            return ((GeodeticDatum)object).getEllipsoid();
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                Ellipsoid ellipsoid = CRS.getEllipsoid(coordinateReferenceSystem2);
                if (ellipsoid == null) continue;
                return ellipsoid;
            }
        }
        return null;
    }

    public static boolean equalsIgnoreMetadata(Object object, Object object2) {
        return Utilities.deepEquals((Object)object, (Object)object2, (ComparisonMode)ComparisonMode.IGNORE_METADATA);
    }

    public static boolean equalsApproximatively(Object object, Object object2) {
        return Utilities.deepEquals((Object)object, (Object)object2, (ComparisonMode)ComparisonMode.APPROXIMATIVE);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        Boolean bl = defaultLenient;
        if (bl == null) {
            defaultLenient = bl = Boolean.valueOf(Boolean.TRUE.equals(Hints.getSystemDefault((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT)));
        }
        return CRS.findMathTransform(coordinateReferenceSystem, coordinateReferenceSystem2, bl);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, boolean bl) throws FactoryException {
        if (CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) {
            return MathTransforms.identity(coordinateReferenceSystem.getCoordinateSystem().getDimension());
        }
        ArgumentChecks.ensureNonNull((String)"sourceCRS", (Object)coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)coordinateReferenceSystem2);
        CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory(bl);
        return coordinateOperationFactory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2).getMathTransform();
    }

    public static Envelope transform(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        return Envelopes.transform(envelope, coordinateReferenceSystem);
    }

    public static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope) throws TransformException {
        return Envelopes.transform(mathTransform, envelope);
    }

    public static GeneralEnvelope transform(CoordinateOperation coordinateOperation, Envelope envelope) throws TransformException {
        return Envelopes.transform(coordinateOperation, envelope);
    }

    public static Rectangle2D transform(MathTransform2D mathTransform2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        return Envelopes.transform(mathTransform2D, rectangle2D, rectangle2D2);
    }

    public static Rectangle2D transform(CoordinateOperation coordinateOperation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        return Envelopes.transform(coordinateOperation, rectangle2D, rectangle2D2);
    }

    public static double[] deltaTransform(MathTransform mathTransform, DirectPosition directPosition, double ... dArray) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)mathTransform);
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        double[] dArray2 = new double[n2];
        if (dArray.length != n) {
            throw new IllegalArgumentException(Errors.format((int)113, (Object)"vector", (Object)dArray.length, (Object)n));
        }
        if (mathTransform instanceof AffineTransform) {
            ((AffineTransform)mathTransform).deltaTransform(dArray, 0, dArray2, 0, 1);
        } else {
            int n3;
            double[] dArray3 = new double[2 * Math.max(n, n2)];
            for (n3 = 0; n3 < n; ++n3) {
                double d = directPosition.getOrdinate(n3);
                double d2 = dArray[n3] * 0.5;
                dArray3[n3] = d - d2;
                dArray3[n3 + n] = d + d2;
            }
            mathTransform.transform(dArray3, 0, dArray3, 0, 2);
            for (n3 = 0; n3 < n2; ++n3) {
                dArray2[n3] = dArray3[n3 + n2] - dArray3[n3];
            }
        }
        return dArray2;
    }

    static void unexpectedException(String string, Exception exception) {
        Logging.unexpectedException(CRS.class, (String)string, (Throwable)exception);
    }

    static {
        Factories.addChangeListener((ChangeListener)new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Class<CRS> clazz = CRS.class;
                synchronized (CRS.class) {
                    crsFactory = null;
                    standardFactory = null;
                    xyFactory = null;
                    strictFactory = null;
                    lenientFactory = null;
                    defaultOrder = null;
                    defaultLenient = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

