/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.jaxb.gco.StringConverter;
import org.geotoolkit.internal.jaxb.referencing.RS_Identifier;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.io.wkt.FormattableObject;
import org.geotoolkit.referencing.DefaultReferenceIdentifier;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.DefaultInternationalString;
import org.geotoolkit.util.Deprecable;
import org.geotoolkit.util.LenientComparable;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

@Immutable
@ThreadSafe
@XmlType(name="IdentifiedObjectType", propOrder={"identifier", "name"})
public class AbstractIdentifiedObject
extends FormattableObject
implements IdentifiedObject,
LenientComparable,
Deprecable,
Serializable {
    private static final long serialVersionUID = -5173281694258483264L;
    @XmlElement
    @XmlJavaTypeAdapter(value=RS_Identifier.ToString.class)
    private final ReferenceIdentifier name;
    private final Collection<GenericName> alias;
    private final Set<ReferenceIdentifier> identifiers;
    private final InternationalString remarks;
    private transient int hashCode;

    private AbstractIdentifiedObject() {
        this((IdentifiedObject)NilReferencingObject.INSTANCE);
    }

    public AbstractIdentifiedObject(IdentifiedObject identifiedObject) {
        ArgumentChecks.ensureNonNull((String)"object", (Object)identifiedObject);
        this.name = identifiedObject.getName();
        Collection collection = identifiedObject.getAlias();
        Set set = identifiedObject.getIdentifiers();
        this.remarks = identifiedObject.getRemarks();
        if (collection != null && collection.isEmpty()) {
            collection = null;
        }
        if (set != null && set.isEmpty()) {
            set = null;
        }
        this.alias = collection;
        this.identifiers = set;
    }

    public AbstractIdentifiedObject(Map<String, ?> map) throws IllegalArgumentException {
        this(map, null, null);
    }

    protected AbstractIdentifiedObject(Map<String, ?> map, Map<String, Object> map2, String[] stringArray) throws IllegalArgumentException {
        Object object;
        ArgumentChecks.ensureNonNull((String)"properties", map);
        NamedIdentifier namedIdentifier = null;
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        DefaultInternationalString defaultInternationalString = null;
        DefaultInternationalString defaultInternationalString2 = null;
        DefaultInternationalString[] defaultInternationalStringArray = null;
        block16: for (Map.Entry<String, ?> object22 : map.entrySet()) {
            object = object22.getKey().trim().toLowerCase();
            Object obj = object22.getValue();
            switch (((String)object).hashCode()) {
                case -1528693765: {
                    if (!((String)object).equalsIgnoreCase("anchorPoint")) break;
                    object = "anchorPoint";
                    break;
                }
                case -1805658881: {
                    if (!((String)object).equalsIgnoreCase("bursaWolf")) break;
                    object = "bursaWolf";
                    break;
                }
                case 109688209: {
                    if (!((String)object).equalsIgnoreCase("operationVersion")) break;
                    object = "operationVersion";
                    break;
                }
                case 1479434472: {
                    if (!((String)object).equalsIgnoreCase("coordinateOperationAccuracy")) break;
                    object = "coordinateOperationAccuracy";
                    break;
                }
                case 1126917133: {
                    if (!((String)object).equalsIgnoreCase("positionalAccuracy")) break;
                    object = "positionalAccuracy";
                    break;
                }
                case 1127093059: {
                    if (!((String)object).equalsIgnoreCase("realizationEpoch")) break;
                    object = "realizationEpoch";
                    break;
                }
                case 1790520781: {
                    if (!((String)object).equalsIgnoreCase("domainOfValidity")) break;
                    object = "domainOfValidity";
                    break;
                }
                case -1109785975: {
                    if (!((String)object).equalsIgnoreCase("validArea")) break;
                    object = "validArea";
                    break;
                }
                case 3373707: {
                    if (!((String)object).equals("name")) break;
                    if (obj instanceof String) {
                        namedIdentifier = new NamedIdentifier(map, false);
                        assert (obj.equals(((Identifier)namedIdentifier).getCode())) : namedIdentifier;
                        continue block16;
                    }
                    namedIdentifier = (NamedIdentifier)((Object)obj);
                    continue block16;
                }
                case 92902992: {
                    if (!((String)object).equals("alias")) break;
                    objectArray = NamedIdentifier.getNameFactory().toArray(obj);
                    continue block16;
                }
                case 1368189162: {
                    if (!((String)object).equals("identifiers")) break;
                    if (obj == null) continue block16;
                    if (obj instanceof ReferenceIdentifier) {
                        objectArray2 = new ReferenceIdentifier[]{(ReferenceIdentifier)obj};
                        continue block16;
                    }
                    objectArray2 = (Object[])obj;
                    continue block16;
                }
                case 1091415283: {
                    if (!((String)object).equals("remarks") || !(obj instanceof InternationalString)) break;
                    defaultInternationalString = (DefaultInternationalString)obj;
                    continue block16;
                }
            }
            if (obj instanceof String) {
                if (defaultInternationalString2 == null) {
                    defaultInternationalString2 = defaultInternationalString instanceof DefaultInternationalString ? (DefaultInternationalString)defaultInternationalString : new DefaultInternationalString();
                }
                if (defaultInternationalString2.add("remarks", (String)object, obj.toString())) continue;
            }
            if (map2 == null) continue;
            if (stringArray != null) {
                String string;
                for (int i = 0; !(i >= stringArray.length || ((String)object).equals(string = stringArray[i]) && obj instanceof InternationalString); ++i) {
                    if (!(obj instanceof String)) continue;
                    if (defaultInternationalStringArray == null) {
                        defaultInternationalStringArray = new DefaultInternationalString[stringArray.length];
                    }
                    if (defaultInternationalStringArray[i] == null) {
                        Object object2 = map2.get(string);
                        defaultInternationalStringArray[i] = object2 instanceof DefaultInternationalString ? (DefaultInternationalString)object2 : new DefaultInternationalString();
                    }
                    if (defaultInternationalStringArray[i].add(string, (String)object, obj.toString())) continue block16;
                }
            }
            map2.put((String)object, obj);
        }
        if (defaultInternationalString2 != null && !defaultInternationalString2.getLocales().isEmpty()) {
            if (defaultInternationalString == null) {
                defaultInternationalString = defaultInternationalString2;
            } else if (!defaultInternationalString2.isSubsetOf(defaultInternationalString)) {
                Logging.log(AbstractIdentifiedObject.class, (String)"<init>", (LogRecord)Loggings.format((Level)Level.WARNING, (int)33));
            }
        }
        if (map2 != null && defaultInternationalStringArray != null) {
            for (int i = 0; i < defaultInternationalStringArray.length; ++i) {
                defaultInternationalString2 = defaultInternationalStringArray[i];
                if (defaultInternationalString2 == null || defaultInternationalString2.getLocales().isEmpty()) continue;
                String string = stringArray[i];
                object = map2.get(string);
                if (object == null) {
                    map2.put(string, defaultInternationalString2);
                    continue;
                }
                if (defaultInternationalString2.isSubsetOf(object)) continue;
                Logging.log(AbstractIdentifiedObject.class, (String)"<init>", (LogRecord)Loggings.format((Level)Level.WARNING, (int)33));
            }
        }
        Object object4 = null;
        Object var11_15 = null;
        try {
            object4 = "name";
            NamedIdentifier namedIdentifier2 = namedIdentifier;
            this.name = (ReferenceIdentifier)namedIdentifier2;
            object4 = "alias";
            Object[] objectArray3 = objectArray;
            this.alias = InternalUtilities.nonEmptySet((Object[])objectArray);
            object4 = "identifiers";
            Object[] objectArray4 = objectArray2;
            this.identifiers = InternalUtilities.nonEmptySet((Object[])objectArray2);
            object4 = "remarks";
            DefaultInternationalString defaultInternationalString3 = defaultInternationalString;
            this.remarks = (InternationalString)defaultInternationalString3;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidParameterValueException(Errors.format((int)73, (Object)object4, var11_15), (Throwable)classCastException, (String)object4, var11_15);
        }
        ArgumentChecks.ensureNonNull((String)"name", (Object)((Object)namedIdentifier));
        ArgumentChecks.ensureNonNull((String)"name", (Object)((Object)((Object)namedIdentifier)).toString());
    }

    @XmlID
    @XmlAttribute(name="id", namespace="http://www.opengis.net/gml", required=true)
    @XmlJavaTypeAdapter(value=StringConverter.class)
    final String getID() {
        ReferenceIdentifier referenceIdentifier = this.getIdentifier(null);
        if (referenceIdentifier == null && (referenceIdentifier = this.getName()) == null) {
            return null;
        }
        String string = referenceIdentifier.getCodeSpace();
        string = string != null ? string + referenceIdentifier.getCode() : referenceIdentifier.getCode();
        string = string.replace(":", "");
        return string;
    }

    public ReferenceIdentifier getName() {
        return this.name;
    }

    public String getName(Citation citation) {
        return IdentifiedObjects.name(this, citation, null);
    }

    public Collection<GenericName> getAlias() {
        if (this.alias == null) {
            return Collections.emptySet();
        }
        return this.alias;
    }

    public Set<ReferenceIdentifier> getIdentifiers() {
        if (this.identifiers == null) {
            return Collections.emptySet();
        }
        return this.identifiers;
    }

    @XmlElement
    final ReferenceIdentifier getIdentifier() {
        Iterator<ReferenceIdentifier> iterator;
        Set<ReferenceIdentifier> set = this.identifiers;
        if (set != null && (iterator = set.iterator()).hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public ReferenceIdentifier getIdentifier(Citation citation) {
        return IdentifiedObjects.identifier(this, citation);
    }

    public InternationalString getRemarks() {
        return this.remarks;
    }

    public boolean nameMatches(String string) {
        return IdentifiedObjects.nameMatches(this, this.alias, string);
    }

    public boolean isDeprecated() {
        if (this.name instanceof DefaultReferenceIdentifier && ((DefaultReferenceIdentifier)this.name).isDeprecated()) {
            return true;
        }
        boolean bl = false;
        for (ReferenceIdentifier referenceIdentifier : this.identifiers) {
            if (referenceIdentifier instanceof DefaultReferenceIdentifier && !(bl = ((DefaultReferenceIdentifier)referenceIdentifier).isDeprecated())) break;
        }
        return bl;
    }

    public final boolean equals(Object object) {
        boolean bl = this.equals(object, ComparisonMode.STRICT);
        assert (!bl || this.hashCode() == object.hashCode()) : this;
        return bl;
    }

    public boolean equals(Object object, ComparisonMode comparisonMode) {
        Class<?> clazz;
        if (object == null) {
            return false;
        }
        Class<?> clazz2 = this.getClass();
        if (clazz2 == (clazz = object.getClass())) {
            int n;
            int n2;
            if (comparisonMode.ordinal() < ComparisonMode.APPROXIMATIVE.ordinal() && (n2 = this.hashCode) != 0 && (n = ((AbstractIdentifiedObject)object).hashCode) != 0 && n2 != n) {
                return false;
            }
        } else {
            if (comparisonMode == ComparisonMode.STRICT) {
                return false;
            }
            if (!Classes.implementSameInterfaces(clazz2, clazz, CRSUtilities.getReferencingGroup(clazz2))) {
                return false;
            }
        }
        switch (comparisonMode) {
            case STRICT: {
                AbstractIdentifiedObject abstractIdentifiedObject = (AbstractIdentifiedObject)object;
                return Utilities.equals((Object)this.name, (Object)abstractIdentifiedObject.name) && Utilities.equals(this.alias, abstractIdentifiedObject.alias) && Utilities.equals(this.identifiers, abstractIdentifiedObject.identifiers) && Utilities.equals((Object)this.remarks, (Object)abstractIdentifiedObject.remarks);
            }
            case BY_CONTRACT: {
                IdentifiedObject identifiedObject = (IdentifiedObject)object;
                return Utilities.deepEquals((Object)this.getName(), (Object)identifiedObject.getName(), (ComparisonMode)comparisonMode) && Utilities.deepEquals(this.getAlias(), (Object)identifiedObject.getAlias(), (ComparisonMode)comparisonMode) && Utilities.deepEquals(this.getIdentifiers(), (Object)identifiedObject.getIdentifiers(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getRemarks(), (Object)identifiedObject.getRemarks(), (ComparisonMode)comparisonMode);
            }
            case IGNORE_METADATA: 
            case APPROXIMATIVE: 
            case DEBUG: {
                return true;
            }
        }
        throw new IllegalArgumentException(Errors.format((int)260, (Object)comparisonMode));
    }

    public final int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = this.computeHashCode();
            if (n == 0) {
                n = -1;
            }
            this.hashCode = n;
        }
        assert (n == -1 || n == this.computeHashCode()) : this;
        return n;
    }

    protected int computeHashCode() {
        int n = 1387343808;
        Class[] classArray = Classes.getLeafInterfaces(this.getClass(), IdentifiedObject.class);
        if (classArray != null) {
            for (Class clazz : classArray) {
                n += clazz.hashCode();
            }
        }
        return n;
    }
}

