/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.io.X364;
import org.geotoolkit.measure.Angle;
import org.geotoolkit.measure.AngleFormat;
import org.geotoolkit.parameter.ParameterTableRow;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Localized;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.converter.Classes;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.OperationMethod;

public class ParameterWriter
extends FilterWriter
implements Localized {
    private static final String SHOW_EPSG_CODES = "EPSG:#";
    private Set<String> scopes;
    private Locale locale = Locale.getDefault();
    private Locale formatLocale = Locale.getDefault();
    private transient NumberFormat numberFormat;
    private transient DateFormat dateFormat;
    private transient AngleFormat angleFormat;
    private boolean canSetPositivePrefix;
    private boolean wantPositivePrefix;
    private boolean colorEnabled;
    private boolean brief;

    public ParameterWriter() {
        super(IOUtilities.standardWriter());
        if (this.out instanceof PrintWriter) {
            this.colorEnabled = X364.isSupported();
        }
    }

    public ParameterWriter(Writer writer) {
        super(writer);
    }

    public static void print(OperationMethod operationMethod) {
        ParameterWriter parameterWriter = new ParameterWriter();
        try {
            parameterWriter.format(operationMethod);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static void print(ParameterDescriptorGroup parameterDescriptorGroup) {
        ParameterWriter parameterWriter = new ParameterWriter();
        try {
            parameterWriter.format(parameterDescriptorGroup);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static void print(ParameterValueGroup parameterValueGroup) {
        ParameterWriter parameterWriter = new ParameterWriter();
        try {
            parameterWriter.format(parameterValueGroup);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static String toString(ParameterDescriptorGroup parameterDescriptorGroup) {
        StringWriter stringWriter = new StringWriter();
        ParameterWriter parameterWriter = new ParameterWriter(stringWriter);
        parameterWriter.brief = true;
        try {
            parameterWriter.format(parameterDescriptorGroup);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringWriter.toString();
    }

    public static String toString(ParameterValueGroup parameterValueGroup) {
        StringWriter stringWriter = new StringWriter();
        ParameterWriter parameterWriter = new ParameterWriter(stringWriter);
        parameterWriter.brief = true;
        try {
            parameterWriter.format(parameterValueGroup);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(OperationMethod operationMethod) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.format(operationMethod.getName().getCode(), operationMethod.getParameters(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(ParameterDescriptorGroup parameterDescriptorGroup) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.format(parameterDescriptorGroup.getName().getCode(), parameterDescriptorGroup, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(ParameterValueGroup parameterValueGroup) throws IOException {
        ParameterDescriptorGroup parameterDescriptorGroup = parameterValueGroup.getDescriptor();
        Object object = this.lock;
        synchronized (object) {
            this.format(parameterDescriptorGroup.getName().getCode(), parameterDescriptorGroup, parameterValueGroup);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void format(String string, ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) throws IOException {
        ParameterDescriptorGroup parameterDescriptorGroup2;
        ParameterTableRow parameterTableRow;
        Object object;
        Object object2;
        Object object322;
        Writer writer = this.out;
        Locale locale = this.locale;
        boolean bl = this.brief;
        boolean bl2 = this.colorEnabled;
        String string2 = System.getProperty("line.separator", "\n");
        Vocabulary vocabulary = Vocabulary.getResources((Locale)locale);
        new ParameterTableRow((IdentifiedObject)parameterDescriptorGroup, locale, null, bl).write(writer, bl2, false, string2);
        writer.write(string2);
        int n = bl ? 9472 : 9552;
        TableWriter tableWriter = new TableWriter(writer);
        tableWriter.setMultiLinesCells(true);
        tableWriter.nextLine('\u2550');
        int n2 = 0;
        block10: while (true) {
            int n3;
            boolean bl3 = false;
            switch (n2) {
                case 0: {
                    n3 = 200;
                    break;
                }
                case 1: {
                    n3 = 306;
                    break;
                }
                case 2: {
                    n3 = 195;
                    break;
                }
                case 3: {
                    n3 = 189;
                    break;
                }
                case 4: {
                    n3 = parameterValueGroup == null ? 69 : 318;
                    break;
                }
                case 5: {
                    n3 = 308;
                    bl3 = true;
                    break;
                }
                default: {
                    break block10;
                }
            }
            if (bl2) {
                tableWriter.write(X364.BOLD.sequence());
            }
            tableWriter.write(vocabulary.getString(n3));
            if (bl2) {
                tableWriter.write(X364.NORMAL.sequence());
            }
            if (bl3) {
                tableWriter.nextLine();
            } else {
                tableWriter.nextColumn();
            }
            ++n2;
        }
        n2 = 0;
        List list = parameterValueGroup != null ? parameterValueGroup.values() : parameterDescriptorGroup.descriptors();
        LinkedHashMap<GeneralParameterDescriptor, ParameterTableRow> linkedHashMap = new LinkedHashMap<GeneralParameterDescriptor, ParameterTableRow>(XCollections.hashMapCapacity((int)list.size()));
        ArrayList arrayList = null;
        for (Object object322 : list) {
            void object4;
            if (parameterValueGroup != null) {
                object2 = (GeneralParameterValue)object322;
                object = object2.getDescriptor();
            } else {
                object2 = null;
                object = (GeneralParameterDescriptor)object322;
            }
            if (object instanceof ParameterDescriptorGroup) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(object322);
                continue;
            }
            Iterator iterator = null;
            if (object2 instanceof ParameterValue) {
                iterator = ((ParameterValue)object2).getValue();
            } else if (object instanceof ParameterDescriptor) {
                iterator = ((ParameterDescriptor)object).getDefaultValue();
            }
            ParameterTableRow parameterTableRow2 = (ParameterTableRow)linkedHashMap.get(object);
            if (parameterTableRow2 == null) {
                ParameterTableRow parameterTableRow3 = new ParameterTableRow((IdentifiedObject)object, locale, iterator, bl);
                linkedHashMap.put((GeneralParameterDescriptor)object, parameterTableRow3);
            } else {
                parameterTableRow2.addValue(iterator);
            }
            if (object4.width <= n2) continue;
            n2 = object4.width;
        }
        UnitFormat unitFormat = null;
        object322 = new Object[1];
        object2 = Double.POSITIVE_INFINITY;
        object = Double.NEGATIVE_INFINITY;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (n != 0) {
                tableWriter.nextLine((char)n);
            }
            n = bl ? 0 : 9472;
            parameterTableRow = (ParameterTableRow)entry.getValue();
            parameterTableRow.width = n2;
            parameterTableRow.write((Writer)tableWriter, false, bl2, string2);
            tableWriter.nextColumn();
            parameterDescriptorGroup2 = (GeneralParameterDescriptor)entry.getKey();
            if (parameterDescriptorGroup2 instanceof ParameterDescriptor) {
                Object object3;
                ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptorGroup2;
                Class clazz = parameterDescriptor.getValueClass();
                tableWriter.write(Classes.getShortName((Class)clazz));
                tableWriter.nextColumn();
                Comparable comparable = parameterDescriptor.getMinimumValue();
                Comparable comparable2 = parameterDescriptor.getMaximumValue();
                boolean bl3 = false;
                boolean bl4 = Number.class.isAssignableFrom(clazz);
                if (bl4) {
                    tableWriter.setAlignment(2);
                    if (comparable == null) {
                        comparable = object;
                    }
                    if (comparable2 == null) {
                        comparable2 = object2;
                    }
                    boolean bl5 = bl3 = ((Number)((Object)comparable)).doubleValue() < 0.0;
                }
                if (comparable != null) {
                    tableWriter.write(this.formatValue(comparable));
                }
                tableWriter.nextColumn();
                this.wantPositivePrefix = bl3;
                if (comparable2 != null) {
                    tableWriter.write(this.formatValue(comparable2));
                }
                this.wantPositivePrefix = false;
                tableWriter.nextColumn();
                Object object4 = parameterTableRow.values((Object[])object322);
                int n3 = Array.getLength(object4);
                for (int i = 0; i < n3; ++i) {
                    object3 = Array.get(object4, i);
                    if (object3 == null) continue;
                    if (i != 0) {
                        tableWriter.write(string2);
                    }
                    tableWriter.write(this.formatValue(object3));
                }
                tableWriter.nextColumn();
                tableWriter.setAlignment(0);
                Unit unit = parameterDescriptor.getUnit();
                if (unit != null) {
                    if (unitFormat == null) {
                        unitFormat = UnitFormat.getInstance((Locale)this.formatLocale);
                    }
                    try {
                        object3 = unitFormat.format((Object)unit);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        object3 = Classes.getShortClassName((Object)unit);
                    }
                    tableWriter.write((String)object3);
                }
            }
            tableWriter.nextLine();
        }
        tableWriter.nextLine('\u2550');
        tableWriter.flush();
        if (arrayList != null) {
            for (Object e : arrayList) {
                if (e instanceof ParameterValueGroup) {
                    parameterTableRow = (ParameterValueGroup)e;
                    parameterDescriptorGroup2 = parameterTableRow.getDescriptor();
                } else {
                    parameterTableRow = null;
                    parameterDescriptorGroup2 = (ParameterDescriptorGroup)e;
                }
                writer.write(string2);
                this.format(string + '/' + parameterDescriptorGroup2.getName().getCode(), parameterDescriptorGroup2, (ParameterValueGroup)parameterTableRow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void summary(Collection<? extends IdentifiedObject> collection) throws IOException {
        Object object;
        String[] stringArray;
        Object i;
        int n;
        LinkedHashMap<Object, Integer> linkedHashMap = new LinkedHashMap<Object, Integer>();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Locale locale = this.getLocale();
        Set<String> set = this.getAuthorities();
        Vocabulary vocabulary = Vocabulary.getResources((Locale)locale);
        int n2 = n = set == null || set.contains(SHOW_EPSG_CODES) ? 1 : 0;
        if (n != 0) {
            linkedHashMap.put(SHOW_EPSG_CODES, 0);
        }
        linkedHashMap.put(null, n);
        for (IdentifiedObject identifiedObject : collection) {
            Object object2;
            String string;
            String n5 = null;
            String[] n6 = new String[linkedHashMap.size()];
            n6[n] = identifiedObject.getName().getCode();
            int n3 = 0;
            Collection<Object> n8 = identifiedObject.getAlias();
            if (n8 != null) {
                i = n8.iterator();
                while (i.hasNext()) {
                    stringArray = (String[])i.next();
                    object = stringArray.scope().name();
                    string = stringArray.tip().toInternationalString().toString(locale);
                    object2 = object != null ? object.toInternationalString().toString(locale) : Integer.valueOf(++n3);
                    if (object2.equals("EPSG")) {
                        n5 = string;
                    }
                    if (set != null && !set.contains(object.toString())) continue;
                    n6 = ParameterWriter.putIfAbsent(n6, ParameterWriter.getColumnIndex(linkedHashMap, object2), string);
                }
            }
            if ((i = identifiedObject.getIdentifiers()) != null) {
                stringArray = i.iterator();
                while (stringArray.hasNext()) {
                    int n4;
                    String string2;
                    object = (ReferenceIdentifier)stringArray.next();
                    string = object.getCodeSpace();
                    object2 = object.getCode();
                    String string3 = string2 = string != null ? string : Integer.valueOf(++n3);
                    if (n != 0 && string2.equals("EPSG")) {
                        n4 = 0;
                    } else {
                        if (set != null && !set.contains(string)) continue;
                        n4 = ParameterWriter.getColumnIndex(linkedHashMap, string2);
                    }
                    n6 = ParameterWriter.putIfAbsent(n6, n4, (String)object2);
                }
            }
            arrayList.add(n6);
            arrayList2.add(n5);
        }
        Object object4 = this.lock;
        synchronized (object4) {
            TableWriter tableWriter = new TableWriter(this.out, " \u2502 ");
            tableWriter.setMultiLinesCells(true);
            tableWriter.writeHorizontalSeparator();
            int n5 = 0;
            int n6 = -1;
            for (Collection<Object> n8 : linkedHashMap.keySet()) {
                if (n8 == null) {
                    i = vocabulary.getString(145);
                } else if (n8 == SHOW_EPSG_CODES) {
                    i = "EPSG";
                } else if (n8 instanceof String) {
                    i = (String)((Object)n8);
                    if (((String)i).equalsIgnoreCase("geotk") || ((String)i).equalsIgnoreCase("Geotoolkit.org") || ((String)i).equalsIgnoreCase("Geotoolkit")) {
                        n6 = n5;
                        i = vocabulary.getString(75);
                    }
                } else {
                    i = vocabulary.getString(6) + ' ' + n8;
                }
                if (this.colorEnabled) {
                    i = X364.BOLD.sequence() + (String)i + X364.NORMAL.sequence();
                }
                tableWriter.write((String)i);
                tableWriter.nextColumn();
                ++n5;
            }
            tableWriter.writeHorizontalSeparator();
            int n7 = arrayList.size();
            int n8 = linkedHashMap.size();
            for (int j = 0; j < n7; ++j) {
                stringArray = (String[])arrayList.get(j);
                for (n5 = 0; n5 < n8; ++n5) {
                    if (n5 < stringArray.length) {
                        object = stringArray[n5];
                        if (n5 == n6) {
                            if (object == null) {
                                object = (String)arrayList2.get(j);
                            } else if (this.colorEnabled && !object.equals(stringArray[n])) {
                                object = X364.FAINT.sequence() + (String)object + X364.NORMAL.sequence();
                            }
                        }
                        if (object != null) {
                            tableWriter.write((String)object);
                        }
                    }
                    tableWriter.nextColumn();
                }
                tableWriter.nextLine();
            }
            tableWriter.writeHorizontalSeparator();
            tableWriter.flush();
        }
    }

    private static int getColumnIndex(Map<Object, Integer> map, Object object) {
        Integer n = map.get(object);
        if (n == null) {
            n = map.size();
            map.put(object, n);
        }
        return n;
    }

    private static String[] putIfAbsent(String[] stringArray, int n, String string) {
        if (n >= stringArray.length) {
            stringArray = Arrays.copyOf(stringArray, n + 1);
        }
        if (stringArray[n] == null) {
            stringArray[n] = string;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAuthorities() {
        Object object = this.lock;
        synchronized (object) {
            return this.scopes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthorities(String ... stringArray) {
        Set set = null;
        if (stringArray != null) {
            set = XCollections.immutableSet((Object[])stringArray);
        }
        Object object = this.lock;
        synchronized (object) {
            this.scopes = set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBrief() {
        Object object = this.lock;
        synchronized (object) {
            return this.brief;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrief(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.brief = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColorEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.colorEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorEnabled(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.colorEnabled = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getLocale() {
        Object object = this.lock;
        synchronized (object) {
            return this.locale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        Object object = this.lock;
        synchronized (object) {
            this.locale = locale;
            this.formatLocale = locale;
            this.numberFormat = null;
            this.dateFormat = null;
            this.angleFormat = null;
        }
    }

    protected String formatValue(Object object) {
        if (object instanceof Number) {
            if (this.numberFormat == null) {
                DecimalFormat decimalFormat;
                String string;
                this.numberFormat = NumberFormat.getNumberInstance(this.formatLocale);
                this.canSetPositivePrefix = false;
                if (this.numberFormat instanceof DecimalFormat && (string = (decimalFormat = (DecimalFormat)this.numberFormat).getPositivePrefix()) != null && string.isEmpty() && "-".equals(string = decimalFormat.getNegativePrefix())) {
                    this.canSetPositivePrefix = true;
                }
            }
            if (this.canSetPositivePrefix) {
                ((DecimalFormat)this.numberFormat).setPositivePrefix(this.wantPositivePrefix ? "+" : "");
            }
            return this.numberFormat.format(object);
        }
        if (object instanceof Date) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance(2, this.formatLocale);
            }
            return this.dateFormat.format(object);
        }
        if (object instanceof Angle) {
            if (this.angleFormat == null) {
                this.angleFormat = AngleFormat.getInstance((Locale)this.formatLocale);
            }
            return this.angleFormat.format(object);
        }
        return String.valueOf(object);
    }
}

