/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.DefaultParameterDescriptorGroup;
import org.geotoolkit.parameter.MatrixParameters;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class MatrixParameterDescriptors
extends DefaultParameterDescriptorGroup {
    private static final long serialVersionUID = -7386537348359343836L;
    public static final int DEFAULT_MATRIX_SIZE = 3;
    private static final int CACHE_SIZE = 8;
    private final ParameterDescriptor<Double>[] parameters = new ParameterDescriptor[64];
    private static final String[] EPSG_NAMES = new String[]{"A1", "A2", "A0", "B1", "B2", "B0"};
    protected final ParameterDescriptor<Integer> numRow;
    protected final ParameterDescriptor<Integer> numCol;
    protected final String prefix;
    protected final char separator;

    private static Map<String, Object> properties(String string) {
        return Collections.singletonMap("name", new NamedIdentifier(Citations.OGC, string));
    }

    public MatrixParameterDescriptors(Map<String, ?> map) {
        this(map, new ParameterDescriptor[]{DefaultParameterDescriptor.create(MatrixParameterDescriptors.properties("num_row"), 3, 2, 50, true), DefaultParameterDescriptor.create(MatrixParameterDescriptors.properties("num_col"), 3, 2, 50, true)}, "elt_", '_');
    }

    public MatrixParameterDescriptors(Map<String, ?> map, ParameterDescriptor<?>[] parameterDescriptorArray, String string, char c) {
        super(map, (GeneralParameterDescriptor[])parameterDescriptorArray);
        if (parameterDescriptorArray.length < 2) {
            throw new IllegalArgumentException();
        }
        this.numRow = Parameters.cast(parameterDescriptorArray[0], Integer.class);
        this.numCol = Parameters.cast(parameterDescriptorArray[1], Integer.class);
        ArgumentChecks.ensureNonNull((String)"prefix", (Object)string);
        this.prefix = string;
        this.separator = c;
    }

    static void checkIndice(String string, int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)string, (Object)n));
        }
    }

    @Override
    public final GeneralParameterDescriptor descriptor(String string) throws ParameterNotFoundException {
        return this.descriptor(string, ((Number)((Object)this.numRow.getMaximumValue())).intValue(), ((Number)((Object)this.numCol.getMaximumValue())).intValue());
    }

    final GeneralParameterDescriptor descriptor(String string, int n, int n2) throws ParameterNotFoundException {
        int n3;
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        string = string.trim();
        RuntimeException runtimeException = null;
        if (string.regionMatches(true, 0, this.prefix, 0, this.prefix.length()) && (n3 = string.indexOf(this.separator, this.prefix.length())) >= 0) {
            try {
                int n4 = Integer.parseInt(string.substring(this.prefix.length(), n3));
                int n5 = Integer.parseInt(string.substring(n3 + 1));
                return this.descriptor(n4, n5, n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                runtimeException = numberFormatException;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                runtimeException = indexOutOfBoundsException;
            }
        }
        try {
            return super.descriptor(string);
        }
        catch (ParameterNotFoundException parameterNotFoundException) {
            if (runtimeException != null) {
                try {
                    parameterNotFoundException.initCause(runtimeException);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            throw parameterNotFoundException;
        }
    }

    public final ParameterDescriptor<Double> descriptor(int n, int n2) throws IndexOutOfBoundsException {
        return this.descriptor(n, n2, ((Number)((Object)this.numRow.getMaximumValue())).intValue(), ((Number)((Object)this.numCol.getMaximumValue())).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final ParameterDescriptor<Double> descriptor(int n, int n2, int n3, int n4) throws IndexOutOfBoundsException {
        int n5;
        ParameterDescriptor<Double> parameterDescriptor;
        Object object;
        MatrixParameterDescriptors.checkIndice("row", n, n3);
        MatrixParameterDescriptors.checkIndice("column", n2, n4);
        int n6 = -1;
        if (n < 8 && n2 < 8) {
            n6 = n * 8 + n2;
            object = this.parameters;
            // MONITORENTER : this.parameters
            parameterDescriptor = this.parameters[n6];
            // MONITOREXIT : object
            if (parameterDescriptor != null) {
                return parameterDescriptor;
            }
        }
        object = MatrixParameterDescriptors.properties(this.prefix + n + this.separator + n2);
        if (n3 == 3 && n4 == 3 && (n5 = n * 3 + n2) >= 0 && n5 < EPSG_NAMES.length) {
            object = new HashMap(object);
            object.put("alias", new NamedIdentifier((Citation)Citations.EPSG, EPSG_NAMES[n5]));
        }
        parameterDescriptor = new DefaultParameterDescriptor<Double>((Map<String, ?>)object, Double.class, null, n == n2 ? 1.0 : 0.0, null, null, (Unit<?>)Unit.ONE, true);
        if (n6 < 0) return parameterDescriptor;
        ParameterDescriptor<Double>[] parameterDescriptorArray = this.parameters;
        // MONITORENTER : this.parameters
        ParameterDescriptor<Double> parameterDescriptor2 = this.parameters[n6];
        if (parameterDescriptor2 != null) {
            // MONITOREXIT : parameterDescriptorArray
            return parameterDescriptor2;
        }
        this.parameters[n6] = parameterDescriptor;
        // MONITOREXIT : parameterDescriptorArray
        return parameterDescriptor;
    }

    @Override
    public final List<GeneralParameterDescriptor> descriptors() {
        return this.descriptors((Integer)this.numRow.getDefaultValue(), (Integer)this.numCol.getDefaultValue());
    }

    final List<GeneralParameterDescriptor> descriptors(int n, int n2) {
        Object[] objectArray = new GeneralParameterDescriptor[n * n2 + 2];
        int n3 = 0;
        objectArray[n3++] = this.numRow;
        objectArray[n3++] = this.numCol;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                objectArray[n3++] = this.descriptor(i, j, n, n2);
            }
        }
        assert (n3 == objectArray.length) : n3;
        return UnmodifiableArrayList.wrap((Object[])objectArray);
    }

    @Override
    public ParameterValueGroup createValue() {
        return new MatrixParameters(this);
    }

    public Matrix getMatrix(ParameterValueGroup parameterValueGroup) throws InvalidParameterNameException {
        if (parameterValueGroup instanceof MatrixParameters) {
            return ((MatrixParameters)parameterValueGroup).getMatrix();
        }
        ParameterValue<?> parameterValue = Parameters.getOrCreate(this.numRow, parameterValueGroup);
        ParameterValue<?> parameterValue2 = Parameters.getOrCreate(this.numCol, parameterValueGroup);
        int n = parameterValue.intValue();
        int n2 = parameterValue2.intValue();
        XMatrix xMatrix = Matrices.create(n, n2);
        List list = parameterValueGroup.values();
        if (list != null) {
            for (GeneralParameterValue generalParameterValue : list) {
                int n3;
                if (generalParameterValue == parameterValue || generalParameterValue == parameterValue2) continue;
                RuntimeException runtimeException = null;
                String string = generalParameterValue.getDescriptor().getName().toString();
                if (string.regionMatches(true, 0, this.prefix, 0, this.prefix.length()) && (n3 = string.indexOf(this.separator, this.prefix.length())) >= 0) {
                    try {
                        int n4 = Integer.parseInt(string.substring(this.prefix.length(), n3));
                        int n5 = Integer.parseInt(string.substring(n3 + 1));
                        xMatrix.setElement(n4, n5, ((ParameterValue)generalParameterValue).doubleValue());
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        runtimeException = numberFormatException;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        runtimeException = indexOutOfBoundsException;
                    }
                }
                throw new InvalidParameterNameException(Errors.format((int)210, (Object)string), runtimeException, string);
            }
        }
        return xMatrix;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object instanceof MatrixParameterDescriptors && super.equals(object, comparisonMode)) {
            MatrixParameterDescriptors matrixParameterDescriptors = (MatrixParameterDescriptors)object;
            return this.separator == matrixParameterDescriptors.separator && Utilities.equals((Object)this.prefix, (Object)matrixParameterDescriptors.prefix);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((Object)this.prefix, (int)Utilities.hash((char)this.separator, (int)super.computeHashCode()));
    }
}

