/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.parameter.AbstractParameter;
import org.geotoolkit.parameter.AbstractParameterDescriptor;
import org.geotoolkit.parameter.FloatParameter;
import org.geotoolkit.parameter.Parameter;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.converter.Classes;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.CodeList;

@Immutable
public class DefaultParameterDescriptor<T>
extends AbstractParameterDescriptor
implements ParameterDescriptor<T> {
    private static final long serialVersionUID = -295668622297737705L;
    private static final Map<Double, Double> CACHE = new HashMap<Double, Double>(13);
    private final Class<T> valueClass;
    private final Set<T> validValues;
    private final T defaultValue;
    private final Comparable<T> minimum;
    private final Comparable<T> maximum;
    private final Unit<?> unit;

    private static void cache(Double d) {
        if (CACHE.put(d, d) != null) {
            throw new AssertionError(d);
        }
    }

    private static <T> T cached(T t) {
        Double d = CACHE.get(t);
        return (T)(d != null ? d : t);
    }

    public DefaultParameterDescriptor(ParameterDescriptor<T> parameterDescriptor) {
        super((GeneralParameterDescriptor)parameterDescriptor);
        this.valueClass = parameterDescriptor.getValueClass();
        this.validValues = parameterDescriptor.getValidValues();
        this.defaultValue = parameterDescriptor.getDefaultValue();
        this.minimum = parameterDescriptor.getMinimumValue();
        this.maximum = parameterDescriptor.getMaximumValue();
        this.unit = parameterDescriptor.getUnit();
    }

    public DefaultParameterDescriptor(String string, Class<T> clazz, T[] TArray, T t) {
        this(Collections.singletonMap("name", string), clazz, TArray, t, null, null, null, true);
    }

    public DefaultParameterDescriptor(Citation citation, String string, Class<T> clazz, T[] TArray, T t, Comparable<T> comparable, Comparable<T> comparable2, Unit<?> unit, boolean bl) {
        this(Collections.singletonMap("name", new NamedIdentifier(citation, string)), clazz, TArray, t, comparable, comparable2, unit, bl);
    }

    public DefaultParameterDescriptor(String string, CharSequence charSequence, Class<T> clazz, T t, boolean bl) {
        this(DefaultParameterDescriptor.properties(string, charSequence), clazz, DefaultParameterDescriptor.codeList(clazz), t, null, null, null, bl);
    }

    public DefaultParameterDescriptor(Map<String, ?> map, Class<T> clazz, T[] TArray, T t, Comparable<T> comparable, Comparable<T> comparable2, Unit<?> unit, boolean bl) {
        super(map, bl ? 1 : 0, 1);
        this.valueClass = clazz;
        this.defaultValue = DefaultParameterDescriptor.cached(t);
        this.minimum = DefaultParameterDescriptor.cached(comparable);
        this.maximum = DefaultParameterDescriptor.cached(comparable2);
        this.unit = unit;
        ArgumentChecks.ensureNonNull((String)"valueClass", clazz);
        ArgumentChecks.ensureCanCast((String)"defaultValue", clazz, t);
        ArgumentChecks.ensureCanCast((String)"minimum", clazz, comparable);
        ArgumentChecks.ensureCanCast((String)"maximum", clazz, comparable2);
        if (comparable != null && comparable2 != null && comparable.compareTo(clazz.cast(comparable2)) > 0) {
            throw new IllegalArgumentException(Errors.format((int)14, comparable, comparable2));
        }
        if (TArray != null) {
            HashSet<T> hashSet = new HashSet<T>(Math.max(XCollections.hashMapCapacity((int)TArray.length), 8));
            for (int i = 0; i < TArray.length; ++i) {
                T t2 = DefaultParameterDescriptor.cached(TArray[i]);
                ArgumentChecks.ensureCanCast((String)"validValues", clazz, t2);
                hashSet.add(t2);
            }
            this.validValues = XCollections.unmodifiableSet(hashSet);
        } else {
            this.validValues = null;
        }
        AbstractParameter.ensureValidValue(this, t);
    }

    public static DefaultParameterDescriptor<Integer> create(String string, int n, int n2, int n3) {
        return DefaultParameterDescriptor.create(Collections.singletonMap("name", string), n, n2, n3, true);
    }

    public static DefaultParameterDescriptor<Integer> create(Map<String, ?> map, int n, int n2, int n3, boolean bl) {
        return new DefaultParameterDescriptor<Integer>(map, Integer.class, null, n, n2 == Integer.MIN_VALUE ? null : Integer.valueOf(n2), n3 == Integer.MAX_VALUE ? null : Integer.valueOf(n3), null, bl);
    }

    public static DefaultParameterDescriptor<Double> create(String string, double d, double d2, double d3, Unit<?> unit) {
        return DefaultParameterDescriptor.create(Collections.singletonMap("name", string), d, d2, d3, unit, true);
    }

    public static DefaultParameterDescriptor<Double> create(Map<String, ?> map, double d, double d2, double d3, Unit<?> unit, boolean bl) {
        return new DefaultParameterDescriptor<Double>(map, Double.class, null, Double.isNaN(d) ? null : Double.valueOf(d), d2 == Double.NEGATIVE_INFINITY ? null : Double.valueOf(d2), d3 == Double.POSITIVE_INFINITY ? null : Double.valueOf(d3), unit, bl);
    }

    private static <T> T[] codeList(Class<T> clazz) {
        Object[] objectArray = null;
        if (CodeList.class.isAssignableFrom(clazz)) {
            try {
                Object[] objectArray2;
                objectArray = objectArray2 = (Object[])clazz.getMethod("values", null).invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectArray;
    }

    private static Map<String, CharSequence> properties(String string, CharSequence charSequence) {
        Map<String, CharSequence> map;
        if (charSequence == null) {
            map = Collections.singletonMap("name", string);
        } else {
            map = new HashMap<String, String>(4);
            map.put("name", string);
            map.put("remarks", charSequence);
        }
        return map;
    }

    @Override
    public int getMaximumOccurs() {
        return 1;
    }

    public ParameterValue<T> createValue() {
        if (this.valueClass == Double.class) {
            return new FloatParameter(this);
        }
        return new Parameter(this);
    }

    public Class<T> getValueClass() {
        return this.valueClass;
    }

    public Set<T> getValidValues() {
        return this.validValues;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Comparable<T> getMinimumValue() {
        return this.minimum;
    }

    public Comparable<T> getMaximumValue() {
        return this.maximum;
    }

    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                default: {
                    IdentifiedObject identifiedObject = (IdentifiedObject)object;
                    if (!this.nameMatches(identifiedObject.getName().getCode()) && !IdentifiedObjects.nameMatches(identifiedObject, this.getName().getCode())) {
                        return false;
                    }
                }
                case BY_CONTRACT: {
                    IdentifiedObject identifiedObject = (ParameterDescriptor)object;
                    return Utilities.equals(this.getValidValues(), (Object)identifiedObject.getValidValues()) && Utilities.deepEquals(this.getDefaultValue(), (Object)identifiedObject.getDefaultValue()) && Utilities.equals(this.getMinimumValue(), (Object)identifiedObject.getMinimumValue()) && Utilities.equals(this.getMaximumValue(), (Object)identifiedObject.getMaximumValue()) && Utilities.equals(this.getUnit(), (Object)identifiedObject.getUnit());
                }
                case STRICT: 
            }
            DefaultParameterDescriptor defaultParameterDescriptor = (DefaultParameterDescriptor)object;
            return Utilities.equals(this.validValues, defaultParameterDescriptor.validValues) && Utilities.deepEquals(this.defaultValue, defaultParameterDescriptor.defaultValue) && Utilities.equals(this.minimum, defaultParameterDescriptor.minimum) && Utilities.equals(this.maximum, defaultParameterDescriptor.maximum) && Utilities.equals(this.unit, defaultParameterDescriptor.unit);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.valueClass, (int)Utilities.hash((int)Utilities.deepHashCode(this.defaultValue), (int)Utilities.hash(this.minimum, (int)Utilities.hash(this.maximum, (int)Utilities.hash(this.unit, (int)super.computeHashCode())))));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)this)).append("[\"").append(this.getName().getCode()).append("\", ").append(this.getMinimumOccurs() == 0 ? "optional" : "mandatory");
        stringBuilder.append(", class=").append(Classes.getShortName(this.valueClass));
        if (this.minimum != null || this.maximum != null) {
            stringBuilder.append(", valid=[").append(this.minimum != null ? this.minimum : "-\u221e").append(" \u2026 ").append(this.maximum != null ? this.maximum : "\u221e").append(']');
        } else if (this.validValues != null) {
            stringBuilder.append(", valid=").append(this.validValues);
        }
        if (this.defaultValue != null) {
            stringBuilder.append(", default=").append(this.defaultValue);
        }
        if (this.unit != null) {
            stringBuilder.append(", unit=").append(this.unit);
        }
        return stringBuilder.append(']').toString();
    }

    static {
        DefaultParameterDescriptor.cache(0.0);
        DefaultParameterDescriptor.cache(1.0);
        DefaultParameterDescriptor.cache(-90.0);
        DefaultParameterDescriptor.cache(90.0);
        DefaultParameterDescriptor.cache(-180.0);
        DefaultParameterDescriptor.cache(180.0);
        DefaultParameterDescriptor.cache(-648000.0);
        DefaultParameterDescriptor.cache(648000.0);
        DefaultParameterDescriptor.cache(Double.NEGATIVE_INFINITY);
        DefaultParameterDescriptor.cache(Double.POSITIVE_INFINITY);
    }
}

