/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.io.Serializable;
import org.geotoolkit.io.wkt.Formattable;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.io.wkt.UnformattableObjectException;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class MathTransformWrapper
implements MathTransform,
Formattable,
Serializable {
    private static final long serialVersionUID = -5180954407422828265L;
    public final MathTransform transform;

    protected MathTransformWrapper(MathTransform mathTransform) {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)mathTransform);
        this.transform = mathTransform;
    }

    public final int getSourceDimensions() {
        return this.transform.getTargetDimensions();
    }

    public final int getTargetDimensions() {
        return this.transform.getSourceDimensions();
    }

    public final DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws MismatchedDimensionException, TransformException {
        return this.transform.transform(directPosition, directPosition2);
    }

    public final void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        this.transform.transform(dArray, n, dArray2, n2, n3);
    }

    public final void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        this.transform.transform(fArray, n, fArray2, n2, n3);
    }

    public final void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        this.transform.transform(fArray, n, dArray, n2, n3);
    }

    public final void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        this.transform.transform(dArray, n, fArray, n2, n3);
    }

    public final Matrix derivative(DirectPosition directPosition) throws TransformException {
        return this.transform.derivative(directPosition);
    }

    public MathTransform inverse() throws NoninvertibleTransformException {
        return this.transform.inverse();
    }

    public final boolean isIdentity() {
        return this.transform.isIdentity();
    }

    public final boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            MathTransformWrapper mathTransformWrapper = (MathTransformWrapper)object;
            return Utilities.equals((Object)this.transform, (Object)mathTransformWrapper.transform);
        }
        return false;
    }

    public final int hashCode() {
        return this.getClass().hashCode() ^ this.transform.hashCode() ^ 0x94116117;
    }

    public final String toWKT() throws UnsupportedOperationException {
        return this.transform.toWKT();
    }

    public final String toString() {
        return this.transform.toString();
    }

    @Override
    public final String formatWKT(Formatter formatter) {
        if (this.transform instanceof Formattable) {
            return ((Formattable)this.transform).formatWKT(formatter);
        }
        throw new UnformattableObjectException(this.getClass());
    }
}

