/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.util.HashMap;
import java.util.Map;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;

public final class AxisDirections
extends Static {
    private static final Map<AxisDirection, AxisDirection> opposites = new HashMap<AxisDirection, AxisDirection>(35);

    private AxisDirections() {
    }

    public static AxisDirection absolute(AxisDirection axisDirection) {
        AxisDirection axisDirection2;
        if (axisDirection != null && (axisDirection2 = AxisDirections.opposite(axisDirection)) != null && axisDirection2.ordinal() < axisDirection.ordinal()) {
            return axisDirection2;
        }
        return axisDirection;
    }

    public static AxisDirection opposite(AxisDirection axisDirection) {
        return opposites.get(axisDirection);
    }

    public static boolean isOpposite(AxisDirection axisDirection) {
        return Utilities.equals((Object)axisDirection, (Object)AxisDirections.opposite(AxisDirections.absolute(axisDirection)));
    }

    public static int indexOf(CoordinateSystem coordinateSystem, AxisDirection axisDirection) {
        int n = -1;
        if (coordinateSystem != null) {
            AxisDirection axisDirection2 = AxisDirections.opposite(axisDirection);
            int n2 = coordinateSystem.getDimension();
            for (int i = 0; i < n2; ++i) {
                AxisDirection axisDirection3 = coordinateSystem.getAxis(i).getDirection();
                if (axisDirection.equals((Object)axisDirection3)) {
                    return i;
                }
                if (n >= 0 || !axisDirection2.equals((Object)axisDirection3)) continue;
                n = i;
            }
        }
        return n;
    }

    static {
        opposites.put(AxisDirection.OTHER, AxisDirection.OTHER);
        AxisDirection[] axisDirectionArray = new AxisDirection[]{AxisDirection.NORTH, AxisDirection.SOUTH, AxisDirection.NORTH_NORTH_EAST, AxisDirection.SOUTH_SOUTH_WEST, AxisDirection.NORTH_EAST, AxisDirection.SOUTH_WEST, AxisDirection.EAST_NORTH_EAST, AxisDirection.WEST_SOUTH_WEST, AxisDirection.EAST, AxisDirection.WEST, AxisDirection.EAST_SOUTH_EAST, AxisDirection.WEST_NORTH_WEST, AxisDirection.SOUTH_EAST, AxisDirection.NORTH_WEST, AxisDirection.SOUTH_SOUTH_EAST, AxisDirection.NORTH_NORTH_WEST, AxisDirection.UP, AxisDirection.DOWN, AxisDirection.FUTURE, AxisDirection.PAST, AxisDirection.COLUMN_POSITIVE, AxisDirection.COLUMN_NEGATIVE, AxisDirection.ROW_POSITIVE, AxisDirection.ROW_NEGATIVE, AxisDirection.DISPLAY_RIGHT, AxisDirection.DISPLAY_LEFT, AxisDirection.DISPLAY_DOWN, AxisDirection.DISPLAY_UP};
        for (int i = 0; i < axisDirectionArray.length; ++i) {
            if (opposites.put(axisDirectionArray[i], axisDirectionArray[i ^ 1]) != null) {
                throw new AssertionError(i);
            }
        }
    }
}

