/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.display.shape;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.jcip.annotations.NotThreadSafe;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;

@NotThreadSafe
public final class TransformedShape
extends AffineTransform
implements Shape {
    private static final long serialVersionUID = 3541606381365714951L;
    private Shape shape;
    private transient Point2D.Double point;
    private transient Rectangle2D.Double rectangle;

    public TransformedShape() {
        this.initTransientFields();
    }

    public TransformedShape(AffineTransform affineTransform) {
        super(affineTransform);
        this.initTransientFields();
    }

    public TransformedShape(Shape shape) {
        ArgumentChecks.ensureNonNull((String)"shape", (Object)shape);
        this.shape = shape;
        this.initTransientFields();
    }

    public TransformedShape(Shape shape, AffineTransform affineTransform) {
        super(affineTransform);
        ArgumentChecks.ensureNonNull((String)"shape", (Object)shape);
        this.shape = shape;
        this.initTransientFields();
    }

    private void initTransientFields() {
        this.point = new Point2D.Double();
        this.rectangle = new Rectangle2D.Double();
    }

    public Shape getOriginalShape() {
        return this.shape;
    }

    public void setOriginalShape(Shape shape) {
        ArgumentChecks.ensureNonNull((String)"shape", (Object)shape);
        this.shape = shape;
    }

    public void getMatrix(float[] fArray, int n) {
        fArray[n] = (float)this.getScaleX();
        fArray[++n] = (float)this.getShearY();
        fArray[++n] = (float)this.getShearX();
        fArray[++n] = (float)this.getScaleY();
        fArray[++n] = (float)this.getTranslateX();
        fArray[++n] = (float)this.getTranslateY();
    }

    public void setTransform(float[] fArray, int n) {
        this.setTransform(fArray[n], fArray[++n], fArray[++n], fArray[++n], fArray[++n], fArray[++n]);
    }

    @Override
    public boolean contains(double d, double d2) {
        Point2D.Double double_ = this.point;
        double_.x = d;
        double_.y = d2;
        return this.contains(double_);
    }

    @Override
    public boolean contains(Point2D point2D) {
        try {
            return this.shape.contains(this.inverseTransform(point2D, this.point));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            Logging.recoverableException(TransformedShape.class, (String)"contains", (Throwable)noninvertibleTransformException);
            return false;
        }
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = this.rectangle;
        double_.x = d;
        double_.y = d2;
        double_.width = d3;
        double_.height = d4;
        return this.contains(double_);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        try {
            return this.shape.contains(XAffineTransform.inverseTransform(this, rectangle2D, this.rectangle));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            Logging.recoverableException(TransformedShape.class, (String)"contains", (Throwable)noninvertibleTransformException);
            return false;
        }
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = this.rectangle;
        double_.x = d;
        double_.y = d2;
        double_.width = d3;
        double_.height = d4;
        return this.intersects(double_);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        try {
            return this.shape.intersects(XAffineTransform.inverseTransform(this, rectangle2D, this.rectangle));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            Logging.recoverableException(TransformedShape.class, (String)"intersects", (Throwable)noninvertibleTransformException);
            return true;
        }
    }

    @Override
    public Rectangle getBounds() {
        return (Rectangle)XAffineTransform.transform((AffineTransform)this, this.shape.getBounds2D(), new Rectangle());
    }

    @Override
    public Rectangle2D getBounds2D() {
        return XAffineTransform.transform((AffineTransform)this, this.shape.getBounds2D(), null);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        if (!this.isIdentity()) {
            if (affineTransform == null || affineTransform.isIdentity()) {
                return this.shape.getPathIterator(this);
            }
            affineTransform = new AffineTransform(affineTransform);
            affineTransform.concatenate(this);
        }
        return this.shape.getPathIterator(affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        if (!this.isIdentity()) {
            if (affineTransform == null || affineTransform.isIdentity()) {
                return this.shape.getPathIterator(this, d);
            }
            affineTransform = new AffineTransform(affineTransform);
            affineTransform.concatenate(this);
        }
        return this.shape.getPathIterator(affineTransform, d);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode() ^ 0x578F6007;
        if (this.shape != null) {
            n ^= this.shape.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof TransformedShape && super.equals(object)) {
            return Utilities.equals((Object)this.shape, (Object)((TransformedShape)object).shape);
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.readObject();
        this.initTransientFields();
    }
}

