/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.sql;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.sql.DataSource;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.CodeLists;
import org.geotoolkit.internal.sql.DefaultDataSource;
import org.geotoolkit.internal.sql.SQLBuilder;
import org.geotoolkit.internal.sql.StatementEntry;
import org.geotoolkit.internal.sql.StatementPool;
import org.geotoolkit.metadata.KeyNamePolicy;
import org.geotoolkit.metadata.MetadataStandard;
import org.geotoolkit.metadata.NullValuePolicy;
import org.geotoolkit.metadata.sql.CacheKey;
import org.geotoolkit.metadata.sql.MetadataException;
import org.geotoolkit.metadata.sql.MetadataHandler;
import org.geotoolkit.metadata.sql.MetadataProxy;
import org.geotoolkit.metadata.sql.MetadataResult;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.collection.WeakValueHashMap;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.ConverterRegistry;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.ObjectConverter;
import org.geotoolkit.util.logging.Logging;
import org.opengis.annotation.UML;
import org.opengis.util.CodeList;

@ThreadSafe
public class MetadataSource {
    static final String ID_COLUMN = "ID";
    protected final MetadataStandard standard;
    static final String CATALOG = null;
    final String schema;
    private final Map<String, Set<String>> tables;
    final StatementPool<Object, StatementEntry> statements;
    private final WeakValueHashMap<CacheKey, Object> cache;
    final SQLBuilder buffer;
    private final ConverterRegistry converters;
    private volatile transient ObjectConverter<?, ?> lastConverter;
    private final ClassLoader loader;

    public MetadataSource(String string, String string2) throws SQLException {
        this(MetadataStandard.ISO_19115, (DataSource)new DefaultDataSource(string), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataSource(MetadataStandard metadataStandard, DataSource dataSource, String string) throws SQLException {
        ArgumentChecks.ensureNonNull((String)"standard", (Object)metadataStandard);
        ArgumentChecks.ensureNonNull((String)"dataSource", (Object)dataSource);
        this.standard = metadataStandard;
        this.schema = string;
        this.statements = new StatementPool(10, dataSource);
        this.tables = new HashMap<String, Set<String>>();
        this.cache = new WeakValueHashMap();
        this.converters = ConverterRegistry.system();
        this.loader = this.getClass().getClassLoader();
        StatementPool<Object, StatementEntry> statementPool = this.statements;
        synchronized (statementPool) {
            this.buffer = new SQLBuilder(this.statements.connection().getMetaData());
        }
    }

    public MetadataSource(MetadataSource metadataSource) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)metadataSource);
        this.standard = metadataSource.standard;
        this.schema = metadataSource.schema;
        this.converters = metadataSource.converters;
        this.loader = metadataSource.loader;
        this.buffer = new SQLBuilder(metadataSource.buffer);
        this.tables = new HashMap<String, Set<String>>();
        this.cache = new WeakValueHashMap();
        this.statements = new StatementPool<Object, StatementEntry>(metadataSource.statements);
    }

    static Object extractFromCollection(Object object) {
        while (object instanceof Iterable) {
            Iterator iterator = ((Iterable)object).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            object = iterator.next();
        }
        return object;
    }

    static String getTableName(Class<?> clazz) {
        UML uML = clazz.getAnnotation(UML.class);
        if (uML == null) {
            return clazz.getSimpleName();
        }
        String string = uML.identifier();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    private static String getColumnName(Method method) {
        UML uML = method.getAnnotation(UML.class);
        if (uML == null) {
            return method.getName();
        }
        String string = uML.identifier();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    final Map<String, Object> asMap(Object object) throws ClassCastException {
        return this.standard.asMap(object, NullValuePolicy.ALL, KeyNamePolicy.UML_IDENTIFIER);
    }

    final String proxy(Object object) {
        return object instanceof MetadataProxy ? ((MetadataProxy)object).identifier(this) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String search(Object object) throws ClassCastException, SQLException {
        ArgumentChecks.ensureNonNull((String)"metadata", (Object)object);
        String string = this.proxy(object);
        if (string == null) {
            if (object instanceof CodeList) {
                string = ((CodeList)object).name();
            } else {
                String string2 = MetadataSource.getTableName(this.standard.getInterface(object.getClass()));
                Map<String, Object> map = this.asMap(object);
                StatementPool<Object, StatementEntry> statementPool = this.statements;
                synchronized (statementPool) {
                    Statement statement = this.statements.connection().createStatement();
                    string = this.search(string2, null, map, statement, this.buffer);
                    statement.close();
                }
            }
        }
        return string;
    }

    final String search(String string, Set<String> set, Map<String, Object> map, Statement statement, SQLBuilder sQLBuilder) throws SQLException {
        Object object;
        assert (Thread.holdsLock(this.statements));
        sQLBuilder.clear();
        for (Map.Entry<String, Object> object22 : map.entrySet()) {
            object = MetadataSource.extractFromCollection(object22.getValue());
            String string2 = object22.getKey();
            if (set == null) {
                set = this.getExistingColumns(string);
            }
            if (!set.contains(string2)) {
                if (object == null) continue;
                return null;
            }
            if (object instanceof CodeList) {
                object = ((CodeList)object).name();
            } else if (object != null) {
                String string3 = this.proxy(object);
                if (string3 != null) {
                    object = string3;
                } else {
                    Class<?> clazz = object.getClass();
                    if (this.standard.isMetadata(clazz)) {
                        string3 = this.search(MetadataSource.getTableName(this.standard.getInterface(clazz)), null, this.asMap(object), statement, new SQLBuilder(sQLBuilder));
                        if (string3 == null) {
                            return null;
                        }
                        object = string3;
                    }
                }
            }
            if (sQLBuilder.isEmpty()) {
                sQLBuilder.append("SELECT ").append(ID_COLUMN).append(" FROM ").appendIdentifier(this.schema, string).append(" WHERE ");
            } else {
                sQLBuilder.append(" AND ");
            }
            sQLBuilder.appendIdentifier(string2).appendCondition(object);
        }
        Object object3 = null;
        ResultSet resultSet = statement.executeQuery(sQLBuilder.toString());
        while (resultSet.next()) {
            object = resultSet.getString(1);
            if (object == null) continue;
            if (object3 == null) {
                object3 = object;
                continue;
            }
            if (((String)object3).equals(object)) continue;
            Logging.log(MetadataSource.class, (String)"search", (LogRecord)Errors.getResources(null).getLogRecord(Level.WARNING, 55, object));
        }
        resultSet.close();
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Set<String> getExistingColumns(String string) throws SQLException {
        assert (Thread.holdsLock(this.statements));
        Set<String> set = this.tables.get(string);
        if (set == null) {
            set = new HashSet<String>();
            ResultSet resultSet = this.statements.connection().getMetaData().getColumns(CATALOG, this.schema, string, null);
            try {
                while (resultSet.next()) {
                    if (set.add(resultSet.getString("COLUMN_NAME"))) continue;
                    throw new SQLNonTransientException(string);
                }
            }
            finally {
                resultSet.close();
            }
            this.tables.put(string, set);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getEntry(Class<T> clazz, String string) throws SQLException {
        Object object;
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        ArgumentChecks.ensureNonNull((String)"identifier", (Object)string);
        if (CodeList.class.isAssignableFrom(clazz)) {
            object = MetadataSource.getCodeList(clazz, string);
        } else {
            CacheKey cacheKey = new CacheKey(clazz, string);
            WeakValueHashMap<CacheKey, Object> weakValueHashMap = this.cache;
            synchronized (weakValueHashMap) {
                object = this.cache.get((Object)cacheKey);
                if (object == null) {
                    object = Proxy.newProxyInstance(this.loader, new Class[]{clazz, MetadataProxy.class}, (InvocationHandler)new MetadataHandler(string, this));
                    this.cache.put((Object)cacheKey, object);
                }
            }
        }
        return clazz.cast(object);
    }

    private static CodeList<?> getCodeList(Class<?> clazz, String string) {
        return CodeLists.valueOf(clazz, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object getValue(Class<?> clazz, Method method, String string) throws SQLException {
        Class clazz2 = method.getReturnType();
        boolean bl = Collection.class.isAssignableFrom(clazz2);
        Class clazz3 = bl ? Classes.boundOfParameterizedAttribute((Method)method) : clazz2;
        boolean bl2 = this.standard.isMetadata(clazz3);
        String string2 = MetadataSource.getTableName(clazz);
        String string3 = MetadataSource.getColumnName(method);
        Object[] objectArray = this.statements;
        synchronized (this.statements) {
            Object object;
            boolean bl3;
            Object object2;
            if (this.getExistingColumns(string2).contains(string3)) {
                MetadataResult metadataResult = (MetadataResult)this.statements.remove(clazz);
                if (metadataResult == null) {
                    object2 = this.buffer.clear().append("SELECT * FROM ").appendIdentifier(this.schema, string2).append(" WHERE ").append(ID_COLUMN).append("=?").toString();
                    metadataResult = new MetadataResult(clazz, this.statements.connection().prepareStatement((String)object2));
                }
                if (bl3 = (object = metadataResult.getObject(string, string3)) instanceof java.sql.Array) {
                    object2 = (java.sql.Array)object;
                    object = object2.getArray();
                    object2.free();
                }
                if (this.statements.put(clazz, metadataResult) != null) {
                    throw new AssertionError(clazz);
                }
            } else {
                object = null;
                bl3 = false;
            }
            // ** MonitorExit[var12_10] (shouldn't be in output)
            if (bl3 && (bl || !clazz3.isPrimitive())) {
                objectArray = new Object[Array.getLength(object)];
                for (int i = 0; i < objectArray.length; ++i) {
                    object2 = Array.get(object, i);
                    if (object2 != null) {
                        if (bl2) {
                            object2 = this.getEntry(clazz3, object2.toString());
                        } else {
                            try {
                                object2 = this.convert(clazz3, object2);
                            }
                            catch (NonconvertibleObjectException nonconvertibleObjectException) {
                                throw new MetadataException(Errors.format((int)12, (Object)(string3 + '[' + i + ']'), (Object)object), (Exception)((Object)nonconvertibleObjectException));
                            }
                        }
                    }
                    objectArray[i] = object2;
                }
                object = objectArray;
                if (bl) {
                    SequencedCollection<Object> sequencedCollection = Arrays.asList(objectArray);
                    if (SortedSet.class.isAssignableFrom(clazz2)) {
                        sequencedCollection = new TreeSet<Object>(sequencedCollection);
                    } else if (Set.class.isAssignableFrom(clazz2)) {
                        sequencedCollection = new LinkedHashSet<Object>(sequencedCollection);
                    }
                    object = sequencedCollection;
                }
            }
            if (object == null) {
                if (bl) {
                    if (Set.class.isAssignableFrom(clazz2)) {
                        return Collections.EMPTY_SET;
                    }
                    return Collections.EMPTY_LIST;
                }
            } else {
                if (bl2) {
                    object = this.getEntry(clazz3, object.toString());
                } else {
                    try {
                        object = this.convert(clazz3, object);
                    }
                    catch (NonconvertibleObjectException nonconvertibleObjectException) {
                        throw new MetadataException(Errors.format((int)12, (Object)string3, (Object)object), (Exception)((Object)nonconvertibleObjectException));
                    }
                }
                if (bl) {
                    if (Set.class.isAssignableFrom(clazz2)) {
                        return Collections.singleton(object);
                    }
                    return Collections.singletonList(object);
                }
            }
            return object;
        }
    }

    private Object convert(Class<?> clazz, Object object) throws NonconvertibleObjectException {
        Class<?> clazz2 = object.getClass();
        if (!clazz.isAssignableFrom(clazz2)) {
            ObjectConverter objectConverter = this.lastConverter;
            if (objectConverter == null || !objectConverter.getSourceClass().isAssignableFrom(clazz2) || !clazz.isAssignableFrom(objectConverter.getTargetClass())) {
                this.lastConverter = objectConverter = this.converters.converter(clazz2, clazz);
            }
            object = objectConverter.convert(object);
        }
        return object;
    }

    public void close() throws SQLException {
        this.statements.close();
    }
}

