/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql.table;

import java.util.Arrays;
import org.geotoolkit.internal.sql.table.Database;
import org.geotoolkit.internal.sql.table.NoSuchTableException;
import org.geotoolkit.internal.sql.table.Table;
import org.geotoolkit.util.converter.Classes;

public final class TablePool<T extends Table> {
    private final Database database;
    private final Class<T> type;
    private final T[] tables;
    private int count;

    public TablePool(Database database, Class<T> clazz, T[] TArray) {
        this.database = database;
        this.type = clazz;
        this.tables = TArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T acquire() throws NoSuchTableException {
        TablePool tablePool = this;
        synchronized (tablePool) {
            int n = this.count;
            if (n != 0) {
                this.count = --n;
                T t = this.tables[n];
                this.tables[n] = null;
                return t;
            }
        }
        return this.database.getTable(this.type);
    }

    public synchronized void release(T t) {
        assert (((Table)t).getDatabase() == this.database);
        if (this.count != this.tables.length) {
            this.tables[this.count++] = t;
        }
    }

    public synchronized void clear() {
        Arrays.fill(this.tables, null);
        this.count = 0;
    }

    public synchronized String toString() {
        return "TablePool<" + Classes.getShortClassName(this.type) + ">(" + this.count + ')';
    }
}

