/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql.table;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotoolkit.internal.sql.Ordering;
import org.geotoolkit.internal.sql.table.Column;
import org.geotoolkit.internal.sql.table.ColumnOrParameter;
import org.geotoolkit.internal.sql.table.ColumnOrParameterList;
import org.geotoolkit.internal.sql.table.CrossReference;
import org.geotoolkit.internal.sql.table.Database;
import org.geotoolkit.internal.sql.table.LocalCache;
import org.geotoolkit.internal.sql.table.Parameter;
import org.geotoolkit.internal.sql.table.QueryType;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.logging.Logging;

public class Query {
    private static final String JOIN = " JOIN ";
    private static final Object MANDATORY = new Object();
    private static final Column[] EMPTY_COLUMNS = new Column[0];
    private static final Parameter[] EMPTY_PARAMETERS = new Parameter[0];
    final Database database;
    protected final String schema;
    protected final String table;
    private Column[] columns = EMPTY_COLUMNS;
    private Parameter[] parameters = EMPTY_PARAMETERS;
    final Map<Column, Ordering> ordering = new LinkedHashMap<Column, Ordering>();
    private final Map<QueryType, String> cachedSQL = new EnumMap<QueryType, String>(QueryType.class);

    protected Query(Database database, String string) {
        this(database, string, null);
    }

    protected Query(Database database, String string, String string2) {
        this.database = database;
        this.table = string;
        this.schema = string2 == null && database != null ? database.schema : string2;
    }

    public boolean isIncludingChildTables() {
        return true;
    }

    final ColumnOrParameter[] add(ColumnOrParameter columnOrParameter) {
        ColumnOrParameter[] columnOrParameterArray;
        this.cachedSQL.clear();
        if (columnOrParameter instanceof Column) {
            columnOrParameterArray = this.columns;
            this.columns = Arrays.copyOf(this.columns, columnOrParameterArray.length + 1);
            this.columns[columnOrParameterArray.length] = (Column)columnOrParameter;
        } else if (columnOrParameter instanceof Parameter) {
            columnOrParameterArray = this.parameters;
            this.parameters = Arrays.copyOf(this.parameters, columnOrParameterArray.length + 1);
            this.parameters[columnOrParameterArray.length] = (Parameter)columnOrParameter;
        } else {
            throw new AssertionError(columnOrParameter);
        }
        return columnOrParameterArray;
    }

    protected final Column addMandatoryColumn(String string, QueryType ... queryTypeArray) {
        return new Column(this, this.table, string, MANDATORY, queryTypeArray);
    }

    protected final Column addOptionalColumn(String string, Comparable<?> comparable, QueryType ... queryTypeArray) {
        return new Column(this, this.table, string, comparable, queryTypeArray);
    }

    protected final Column addForeignerColumn(String string, String string2, QueryType ... queryTypeArray) {
        return new Column(this, string2, string, MANDATORY, queryTypeArray);
    }

    protected final Column addForeignerColumn(String string, String string2, Comparable<?> comparable, QueryType ... queryTypeArray) {
        return new Column(this, string2, string, comparable, queryTypeArray);
    }

    protected final Parameter addParameter(Column column, QueryType ... queryTypeArray) {
        return new Parameter(this, column, queryTypeArray);
    }

    public final List<Column> getColumns(QueryType queryType) {
        return new ColumnOrParameterList(queryType, (ColumnOrParameter[])this.columns);
    }

    public final List<Parameter> getParameters(QueryType queryType) {
        return new ColumnOrParameterList(queryType, (ColumnOrParameter[])this.parameters);
    }

    private Set<String> getColumnNames(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        ResultSet resultSet = databaseMetaData.getColumns(this.database.catalog, this.schema, string, null);
        while (resultSet.next()) {
            hashSet.add(resultSet.getString("COLUMN_NAME"));
        }
        resultSet.close();
        return hashSet;
    }

    private void selectAll(StringBuilder stringBuilder, QueryType queryType, DatabaseMetaData databaseMetaData, boolean bl) throws SQLException {
        String string;
        Object object;
        String string2 = databaseMetaData.getIdentifierQuoteString().trim();
        Object object2 = new LinkedHashMap();
        HashMap<String, Set<String>> hashMap = null;
        String string3 = "SELECT ";
        for (Column object3 : this.columns) {
            Set<String> set;
            boolean bl2;
            if (object3.indexOf(queryType) == 0) continue;
            object = object3.table;
            if (object3.defaultValue == MANDATORY) {
                bl2 = true;
            } else {
                if (hashMap == null) {
                    hashMap = new HashMap<String, Set<String>>();
                }
                if ((set = (Set)hashMap.get(object)) == null) {
                    set = this.getColumnNames(databaseMetaData, (String)object);
                    hashMap.put((String)object, set);
                }
                if (!(bl2 = set.contains(object3.name))) {
                    Logging.log(Query.class, (String)"select", (LogRecord)Loggings.format((Level)Level.CONFIG, (int)49, (Object)object3.name, (Object)object, (Object)object3.defaultValue));
                }
            }
            stringBuilder.append(string3);
            if (bl2) {
                set = object3.getFunction(queryType);
                Query.appendFunctionPrefix(stringBuilder, set);
                object3.appendName(stringBuilder, string2);
                Query.appendFunctionSuffix(stringBuilder, set);
            } else {
                boolean bl3 = object3.defaultValue instanceof CharSequence;
                string = String.valueOf(object3.defaultValue);
                if (bl3) {
                    stringBuilder.append('\'');
                } else {
                    string = string.toUpperCase(Locale.ENGLISH);
                }
                stringBuilder.append(string);
                if (bl3) {
                    stringBuilder.append('\'');
                }
            }
            if (!bl2) {
                object3.appendName(stringBuilder.append(" AS "), string2);
            }
            string3 = ", ";
            object2.put(object, null);
        }
        if (bl) {
            for (ColumnOrParameter columnOrParameter : this.parameters) {
                if (columnOrParameter.indexOf(queryType) == 0) continue;
                object2.put(((Parameter)columnOrParameter).column.table, null);
            }
        }
        String string4 = this.database.catalog;
        String string5 = this.schema;
        if (object2.size() >= 2) {
            for (Map.Entry entry : object2.entrySet()) {
                object = (String)entry.getKey();
                ResultSet resultSet = databaseMetaData.getExportedKeys(string4, string5, (String)object);
                while (resultSet.next()) {
                    assert (string4 == null || string4.equals(resultSet.getString("PKTABLE_CAT"))) : string4;
                    assert (string5 == null || string5.equals(resultSet.getString("PKTABLE_SCHEM"))) : string5;
                    assert (object == null || ((String)object).equals(resultSet.getString("PKTABLE_NAME"))) : object;
                    String string6 = resultSet.getString("PKCOLUMN_NAME");
                    if (string4 != null && !string4.equals(resultSet.getString("FKTABLE_CAT")) || string5 != null && !string5.equals(resultSet.getString("FKTABLE_SCHEM")) || !object2.containsKey(string = resultSet.getString("FKTABLE_NAME")) || ((String)object).equals(string)) continue;
                    String string7 = resultSet.getString("FKCOLUMN_NAME");
                    if (resultSet.getShort("KEY_SEQ") != 1) {
                        resultSet.close();
                        throw new SQLException("Cl\u00e9 \u00e9trang\u00e8re sur plusieurs colonnes dans la table \"" + (String)object + "\".");
                    }
                    Column column = new Column(string, string7);
                    Column column2 = new Column((String)object, string6);
                    CrossReference crossReference = new CrossReference(column, column2);
                    CrossReference crossReference2 = entry.setValue(crossReference);
                    if (crossReference2 == null || crossReference.equals(crossReference2)) continue;
                    resultSet.close();
                    throw new SQLException("Multiple cl\u00e9s \u00e9trang\u00e8res pour la table \"" + (String)object + "\".");
                }
                resultSet.close();
            }
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            block4: while (!object2.isEmpty()) {
                Iterator iterator = object2.entrySet().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    String string8 = (String)object.getKey();
                    CrossReference crossReference = (CrossReference)object.getValue();
                    if (crossReference != null && !linkedHashMap.containsKey(crossReference.foreignerKey.table)) continue;
                    linkedHashMap.put(string8, crossReference);
                    iterator.remove();
                    continue block4;
                }
                break block4;
            }
            linkedHashMap.putAll(object2);
            object2 = linkedHashMap;
        }
        string3 = this.isIncludingChildTables() ? " FROM " : " FROM ONLY ";
        for (Map.Entry entry : object2.entrySet()) {
            object = (String)entry.getKey();
            stringBuilder.append(string3);
            if (string5 != null) {
                stringBuilder.append(string2).append(string5).append(string2).append('.');
                stringBuilder.append(string2).append((String)object).append(string2);
            } else {
                stringBuilder.append(string2).append((String)object).append(string2);
            }
            if (string3 != JOIN) {
                string3 = JOIN;
                assert (entry.getValue() == null) : entry;
                continue;
            }
            CrossReference crossReference = (CrossReference)entry.getValue();
            if (crossReference == null) {
                throw new SQLException(Errors.getResources((Locale)this.database.getLocale()).getString(117, object));
            }
            assert (((String)object).equals(crossReference.primaryKey.table)) : object;
            stringBuilder.append(" ON ");
            crossReference.foreignerKey.appendFullName(stringBuilder, string2);
            stringBuilder.append('=');
            crossReference.primaryKey.appendFullName(stringBuilder, string2);
        }
    }

    private void appendParameters(StringBuilder stringBuilder, QueryType queryType, DatabaseMetaData databaseMetaData) throws SQLException {
        String string = databaseMetaData.getIdentifierQuoteString().trim();
        String string2 = " WHERE ";
        for (Parameter parameter : this.parameters) {
            if (parameter.indexOf(queryType) == 0) continue;
            stringBuilder.append(string2).append('(');
            parameter.appendCondition(stringBuilder, string, queryType);
            stringBuilder.append(')');
            string2 = " AND ";
        }
    }

    private void appendOrdering(StringBuilder stringBuilder, QueryType queryType, DatabaseMetaData databaseMetaData) throws SQLException {
        String string = databaseMetaData.getIdentifierQuoteString().trim();
        String string2 = " ORDER BY ";
        for (Column column : this.ordering.keySet()) {
            Ordering ordering = column.getOrdering(queryType);
            if (ordering == null) continue;
            column.appendName(stringBuilder.append(string2), string);
            if (ordering != Ordering.ASC) {
                stringBuilder.append(' ').append(ordering.name());
            }
            string2 = ", ";
        }
    }

    private static DatabaseMetaData getMetaData(LocalCache localCache) throws SQLException {
        assert (Thread.holdsLock(localCache));
        return localCache.connection().getMetaData();
    }

    final String selectAll(LocalCache localCache, QueryType queryType) throws SQLException {
        DatabaseMetaData databaseMetaData = Query.getMetaData(localCache);
        StringBuilder stringBuilder = new StringBuilder();
        this.selectAll(stringBuilder, queryType, databaseMetaData, false);
        this.appendOrdering(stringBuilder, queryType, databaseMetaData);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String select(LocalCache localCache, QueryType queryType) throws SQLException {
        String string;
        Map<QueryType, String> map = this.cachedSQL;
        synchronized (map) {
            string = this.cachedSQL.get((Object)queryType);
            if (string == null) {
                DatabaseMetaData databaseMetaData = Query.getMetaData(localCache);
                StringBuilder stringBuilder = new StringBuilder();
                this.selectAll(stringBuilder, queryType, databaseMetaData, true);
                this.appendParameters(stringBuilder, queryType, databaseMetaData);
                this.appendOrdering(stringBuilder, queryType, databaseMetaData);
                string = stringBuilder.toString();
                this.cachedSQL.put(queryType, string);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insert(LocalCache localCache, QueryType queryType) throws SQLException {
        String string;
        Map<QueryType, String> map = this.cachedSQL;
        synchronized (map) {
            string = this.cachedSQL.get((Object)queryType);
            if (string == null) {
                DatabaseMetaData databaseMetaData = Query.getMetaData(localCache);
                String string2 = databaseMetaData.getIdentifierQuoteString().trim();
                Set<String> set = this.getColumnNames(databaseMetaData, this.table);
                StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
                this.appendTable(stringBuilder, string2);
                String string3 = " (";
                int n = 0;
                String[] stringArray = new String[this.columns.length];
                for (Column column : this.columns) {
                    int n2;
                    if (!this.table.equals(column.table) || !set.contains(column.name) || (n2 = column.indexOf(queryType)) == 0) continue;
                    stringArray[n] = column.getFunction(queryType);
                    if (++n != n2) {
                        throw new IllegalStateException(String.valueOf(column));
                    }
                    column.appendName(stringBuilder.append(string3), string2);
                    string3 = ", ";
                }
                if (n == 0) {
                    return null;
                }
                stringBuilder.append(") VALUES");
                string3 = " (";
                for (int i = 0; i < n; ++i) {
                    String string4 = stringArray[i];
                    Query.appendFunctionPrefix(stringBuilder, string4);
                    stringBuilder.append(string3).append('?');
                    Query.appendFunctionSuffix(stringBuilder, string4);
                    string3 = ", ";
                }
                string = stringBuilder.append(')').toString();
                this.cachedSQL.put(queryType, string);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String delete(LocalCache localCache, QueryType queryType) throws SQLException {
        String string;
        Map<QueryType, String> map = this.cachedSQL;
        synchronized (map) {
            string = this.cachedSQL.get((Object)queryType);
            if (string == null) {
                DatabaseMetaData databaseMetaData = Query.getMetaData(localCache);
                String string2 = databaseMetaData.getIdentifierQuoteString().trim();
                StringBuilder stringBuilder = new StringBuilder("DELETE FROM ");
                if (!this.isIncludingChildTables()) {
                    stringBuilder.append("ONLY ");
                }
                this.appendTable(stringBuilder, string2);
                this.appendParameters(stringBuilder, queryType, databaseMetaData);
                string = stringBuilder.toString();
                this.cachedSQL.put(queryType, string);
            }
        }
        return string;
    }

    public String count(LocalCache localCache, QueryType queryType, Column column) throws SQLException {
        DatabaseMetaData databaseMetaData = Query.getMetaData(localCache);
        String string = databaseMetaData.getIdentifierQuoteString().trim();
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        column.appendName(stringBuilder, string);
        column.appendName(stringBuilder.append(", COUNT("), string);
        stringBuilder.append(") FROM ");
        if (!this.isIncludingChildTables()) {
            stringBuilder.append("ONLY ");
        }
        this.appendTable(stringBuilder, string);
        this.appendParameters(stringBuilder, queryType, databaseMetaData);
        column.appendName(stringBuilder.append(" GROUP BY "), string);
        return stringBuilder.toString();
    }

    private void appendTable(StringBuilder stringBuilder, String string) {
        if (this.database.catalog != null) {
            stringBuilder.append(string).append(this.database.catalog).append(string).append('.');
        }
        if (this.schema != null) {
            stringBuilder.append(string).append(this.schema).append(string).append('.');
        }
        stringBuilder.append(string).append(this.table).append(string);
    }

    private static void appendFunctionPrefix(StringBuilder stringBuilder, String string) {
        if (string != null && !string.startsWith("::")) {
            stringBuilder.append(string).append('(');
        }
    }

    private static void appendFunctionSuffix(StringBuilder stringBuilder, String string) {
        if (string != null) {
            if (string.startsWith("::")) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append(')');
            }
        }
    }
}

