/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql.table;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLTimeoutException;
import java.util.Calendar;
import java.util.ConcurrentModificationException;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.sql.AuthenticatedDataSource;
import org.geotoolkit.internal.sql.DefaultDataSource;
import org.geotoolkit.internal.sql.StatementPool;
import org.geotoolkit.internal.sql.table.ConfigurationKey;
import org.geotoolkit.internal.sql.table.LocalCache;
import org.geotoolkit.internal.sql.table.NameGenerator;
import org.geotoolkit.internal.sql.table.NoSuchTableException;
import org.geotoolkit.internal.sql.table.Table;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Localized;
import org.geotoolkit.util.converter.Classes;
import org.opengis.parameter.ParameterValueGroup;

@ThreadSafe
public class Database
implements Localized {
    private static final int TIMEOUT = 2;
    private final AuthenticatedDataSource source;
    final String catalog;
    final String schema;
    private final TimeZone timezone;
    private volatile Locale locale;
    final Hints hints;
    private final Map<Long, Session> sessions = new LinkedHashMap<Long, Session>();
    final AtomicInteger modificationCount = new AtomicInteger();
    private final ReentrantLock transactionLock = new ReentrantLock(true);
    private final Map<Class<? extends Table>, Table> tables = new HashMap<Class<? extends Table>, Table>();
    private final Object properties;

    public Database(Database database) {
        this.source = database.source;
        this.catalog = database.catalog;
        this.schema = database.schema;
        this.timezone = database.timezone;
        this.hints = database.hints;
        this.properties = database.properties;
    }

    public Database(DataSource dataSource, Properties properties) {
        Object object = properties;
        if (properties != null && properties.size() == 1) {
            object = properties.get("parameters");
        }
        this.properties = object;
        if (dataSource == null) {
            dataSource = new DefaultDataSource(this.getProperty(ConfigurationKey.URL));
        }
        ArgumentChecks.ensureNonNull((String)"datasource", (Object)dataSource);
        String string = this.getProperty(ConfigurationKey.USER);
        String string2 = this.getProperty(ConfigurationKey.PASSWORD);
        String string3 = this.getProperty(ConfigurationKey.TIMEZONE);
        this.timezone = !string3.equalsIgnoreCase("local") ? TimeZone.getTimeZone(string3) : TimeZone.getDefault();
        this.catalog = this.getProperty(ConfigurationKey.CATALOG);
        this.schema = this.getProperty(ConfigurationKey.SCHEMA);
        this.source = new AuthenticatedDataSource(dataSource, string, string2, Boolean.TRUE);
        this.hints = null;
    }

    public final String getProperty(ConfigurationKey configurationKey) {
        Object object;
        String string = null;
        if (this.properties instanceof Properties) {
            string = ((Properties)this.properties).getProperty(configurationKey.key);
        } else if (this.properties instanceof ParameterValueGroup && (object = ((ParameterValueGroup)this.properties).parameter(configurationKey.key).getValue()) != null) {
            string = object.toString();
        }
        if (string == null || (string = string.trim()).isEmpty()) {
            string = configurationKey.defaultValue;
        }
        return string;
    }

    protected Logger getLogger() {
        return null;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final void setLocale(Locale locale) {
        this.locale = locale;
    }

    public final TimeZone getTimeZone() {
        return (TimeZone)this.timezone.clone();
    }

    final Calendar getCalendar(LocalCache localCache) {
        Session session = (Session)localCache;
        assert (Thread.holdsLock(session)) : session;
        Calendar calendar = session.calendar;
        if (calendar == null) {
            session.calendar = calendar = new GregorianCalendar(this.timezone, Locale.CANADA);
        }
        return calendar;
    }

    public final DataSource getDataSource(boolean bl) {
        return bl ? this.source : this.source.wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Session getLocalCache() {
        Session session;
        Long l = Thread.currentThread().getId();
        Map<Long, Session> map = this.sessions;
        synchronized (map) {
            session = this.sessions.get(l);
            if (session != null) {
                if (session.threadID == null) {
                    session.threadID = l;
                } else assert (l.equals(session.threadID)) : session;
            } else {
                Iterator<Session> iterator = this.sessions.values().iterator();
                while (iterator.hasNext()) {
                    Session session2 = iterator.next();
                    if (session2.threadID != null) continue;
                    session = session2;
                    iterator.remove();
                    break;
                }
                if (session == null) {
                    session = new Session((DataSource)this.source, this.sessions);
                }
                if (this.sessions.put(l, session) != null) {
                    throw new ConcurrentModificationException();
                }
                session.threadID = l;
            }
        }
        return session;
    }

    static void release(LocalCache localCache, LocalCache.Stmt stmt) throws SQLException {
        LocalCache.Stmt stmt2 = ((Session)localCache).put(stmt.sql, stmt);
        if (stmt2 != null) {
            stmt2.statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends Table> T getTable(Class<T> clazz) throws NoSuchTableException {
        Table table;
        Map<Class<? extends Table>, Table> map = this.tables;
        synchronized (map) {
            table = this.tables.get(clazz);
            if (table != null && table.canReuse) {
                table.canReuse = false;
            } else {
                if (table != null) {
                    table = table.clone();
                } else {
                    try {
                        Constructor<T> constructor = clazz.getConstructor(Database.class);
                        constructor.setAccessible(true);
                        table = (Table)constructor.newInstance(this);
                    }
                    catch (Exception exception) {
                        throw new NoSuchTableException(Classes.getShortName(clazz), exception);
                    }
                }
                this.tables.put(clazz, table);
            }
        }
        return (T)((Table)clazz.cast(table));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void transactionBegin(LocalCache localCache) throws SQLException {
        boolean bl;
        boolean bl2 = false;
        try {
            bl = this.transactionLock.tryLock(2L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            throw new SQLTimeoutException(interruptedException);
        }
        if (bl) {
            try {
                if (this.transactionLock.getHoldCount() == 1) {
                    assert (Thread.holdsLock(localCache)) : localCache;
                    Connection connection = localCache.connection();
                    connection.setReadOnly(false);
                    connection.setAutoCommit(false);
                }
                bl2 = true;
            }
            finally {
                if (!bl2) {
                    this.transactionLock.unlock();
                }
            }
        } else {
            throw new SQLTimeoutException(Errors.getResources((Locale)this.getLocale()).getString(252));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void transactionEnd(LocalCache localCache, boolean bl) throws SQLException {
        this.ensureOngoingTransaction();
        try {
            if (this.transactionLock.getHoldCount() == 1) {
                assert (Thread.holdsLock(localCache)) : localCache;
                Connection connection = localCache.connection();
                if (bl) {
                    connection.commit();
                } else {
                    connection.rollback();
                }
                connection.setAutoCommit(true);
                connection.setReadOnly(true);
            }
        }
        finally {
            this.transactionLock.unlock();
        }
    }

    final void ensureOngoingTransaction() throws SQLException {
        if (!this.transactionLock.isHeldByCurrentThread()) {
            throw new SQLNonTransientException(Errors.getResources((Locale)this.getLocale()).getString(198));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final NameGenerator getIdentifierGenerator(LocalCache localCache, String string) throws SQLException {
        NameGenerator nameGenerator;
        Session session = (Session)localCache;
        Map<String, NameGenerator> map = session.generators;
        if (map != null) {
            nameGenerator = map.get(string);
            if (nameGenerator != null) {
                return nameGenerator;
            }
            nameGenerator = new NameGenerator(map.values().iterator().next(), string);
        } else {
            Session session2 = session;
            synchronized (session2) {
                nameGenerator = new NameGenerator(session, string);
            }
            session.generators = map = new HashMap<String, NameGenerator>(4);
        }
        if (map.put(string, nameGenerator) != null) {
            throw new AssertionError((Object)string);
        }
        return nameGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SQLException {
        Session[] sessionArray = this.sessions;
        synchronized (this.sessions) {
            Session[] sessionArray2 = this.sessions.values().toArray(new Session[this.sessions.size()]);
            this.sessions.clear();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (Session session : sessionArray2) {
                session.close();
            }
            this.locale = null;
            return;
        }
    }

    private static final class Session
    extends StatementPool<String, LocalCache.Stmt>
    implements LocalCache {
        private Long threadID;
        private String threadName;
        private int numQueries;
        private final Map<Long, Session> sessions;
        Calendar calendar;
        Map<String, NameGenerator> generators;

        Session(DataSource dataSource, Map<Long, Session> map) {
            super(8, dataSource);
            this.sessions = map;
        }

        @Override
        public LocalCache.Stmt prepareStatement(Table table, String string) throws SQLException {
            LocalCache.Stmt stmt = (LocalCache.Stmt)this.remove(string);
            if (stmt == null) {
                Connection connection = this.connection();
                stmt = new LocalCache.Stmt(connection.prepareStatement(string, table.wantsAutoGeneratedKeys() ? 1 : 2), string);
                if (this.numQueries == 0) {
                    this.threadName = Thread.currentThread().getName();
                    Logger logger = table.getLogger();
                    if (logger.isLoggable(Level.FINE)) {
                        Locale locale = table.getLocale();
                        String string2 = connection.getMetaData().getURL();
                        if (string2 == null) {
                            string2 = Vocabulary.getResources((Locale)locale).getString(309);
                        }
                        table.log("getStatement", Loggings.getResources((Locale)locale).getLogRecord(Level.FINE, 63, (Object)this.threadName, (Object)string2));
                    }
                }
            }
            ++this.numQueries;
            return stmt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void monitorExit(boolean bl) {
            super.monitorExit(bl);
            Map<Long, Session> map = this.sessions;
            synchronized (map) {
                if (bl) {
                    Session session = this.sessions.remove(this.threadID);
                    assert (session == null || session == this) : session;
                    Logger logger = DefaultDataSource.LOGGER;
                    if (logger.isLoggable(Level.FINE)) {
                        LogRecord logRecord = Loggings.format((Level)Level.FINE, (int)64, (Object)this.threadName, (Object)this.numQueries);
                        logRecord.setLoggerName(logger.getName());
                        logRecord.setSourceClassName(StatementPool.class.getName());
                        logRecord.setSourceMethodName("run");
                        logger.log(logRecord);
                    }
                }
                this.threadID = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            long l = Thread.currentThread().getId();
            StringBuilder stringBuilder = new StringBuilder("Sessions: (this.threadID=").append(l).append(')');
            Map<Long, Session> map = this.sessions;
            synchronized (map) {
                for (Map.Entry<Long, Session> entry : this.sessions.entrySet()) {
                    Session session = entry.getValue();
                    Long l2 = session.threadID;
                    Long l3 = entry.getKey();
                    stringBuilder.append("\n  ").append(session == this ? "this." : "     ").append("threadID=").append(l3).append(' ').append(l2 == null ? "available" : (l2.equals(l3) ? "in use" : "ERROR"));
                    if (l3 == l) {
                        stringBuilder.append(" (current thread)");
                    }
                    if (!Thread.holdsLock(session)) continue;
                    stringBuilder.append(" (holds lock)");
                }
            }
            return stringBuilder.toString();
        }
    }
}

