/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql.table;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.geotoolkit.internal.sql.table.ColumnOrParameter;
import org.geotoolkit.internal.sql.table.QueryType;

final class ColumnOrParameterIterator<E extends ColumnOrParameter>
implements ListIterator<E> {
    private final QueryType type;
    private final E[] elements;
    private E previous;
    private E next;
    private int elementIndex;
    public int iteratorIndex;

    ColumnOrParameterIterator(QueryType queryType, E[] EArray, int n) {
        this.type = queryType;
        this.elements = EArray;
        this.iteratorIndex = n;
        if (n >= 0) {
            while (this.elementIndex < EArray.length) {
                E e = EArray[this.elementIndex];
                if (((ColumnOrParameter)e).indexOf(queryType) != 0) {
                    this.previous = this.next;
                    this.next = e;
                    if (--n < 0) {
                        return;
                    }
                }
                ++this.elementIndex;
            }
            this.previous = this.next;
            this.next = null;
        }
        if (n != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(this.iteratorIndex));
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public E next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.previous = this.next;
        this.next = null;
        while (++this.elementIndex < this.elements.length) {
            E e = this.elements[this.elementIndex];
            if (((ColumnOrParameter)e).indexOf(this.type) == 0) continue;
            this.next = e;
            break;
        }
        ++this.iteratorIndex;
        assert (((ColumnOrParameter)this.previous).indexOf(this.type) == this.iteratorIndex) : this.previous;
        return this.previous;
    }

    @Override
    public boolean hasPrevious() {
        return this.previous != null;
    }

    @Override
    public E previous() {
        if (this.previous == null) {
            throw new NoSuchElementException();
        }
        this.next = this.previous;
        this.previous = null;
        while (--this.elementIndex > 0) {
            E e = this.elements[this.elementIndex - 1];
            if (((ColumnOrParameter)e).indexOf(this.type) == 0) continue;
            this.previous = e;
            break;
        }
        --this.iteratorIndex;
        return this.next;
    }

    @Override
    public int nextIndex() {
        return this.iteratorIndex;
    }

    @Override
    public int previousIndex() {
        return this.iteratorIndex - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(E e) {
        throw new UnsupportedOperationException();
    }
}

