/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.jcip.annotations.NotThreadSafe;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.internal.sql.DefaultDataSource;
import org.geotoolkit.internal.sql.StatementEntry;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.logging.Logging;

@NotThreadSafe
public class StatementPool<K, V extends StatementEntry>
extends LinkedHashMap<K, V>
implements Runnable {
    private static final int TIMEOUT = 2000;
    private static final int EXTRA_DELAY = 500;
    private final int capacity;
    private final DataSource dataSource;
    private Connection connection;

    public StatementPool(int n, DataSource dataSource) {
        super(XCollections.hashMapCapacity((int)n));
        this.capacity = n;
        this.dataSource = dataSource;
    }

    public StatementPool(StatementPool<K, V> statementPool) {
        super(XCollections.hashMapCapacity((int)statementPool.capacity));
        this.capacity = statementPool.capacity;
        this.dataSource = statementPool.dataSource;
    }

    public final Connection connection() throws SQLException {
        assert (Thread.holdsLock(this));
        Connection connection = this.connection;
        if (connection == null) {
            assert (this.isEmpty());
            this.connection = connection = this.dataSource.getConnection();
            DefaultDataSource.log((Connection)connection, StatementPool.class);
            Threads.executeDisposal((Runnable)this, (long)2500L);
        }
        return connection;
    }

    @Override
    public final V get(Object object) {
        assert (Thread.holdsLock(this));
        return (V)((StatementEntry)super.get(object));
    }

    @Override
    public final V put(K k, V v) {
        assert (Thread.holdsLock(this));
        ((StatementEntry)v).expireTime = System.currentTimeMillis() + 2000L;
        return (V)((StatementEntry)super.put(k, v));
    }

    @Override
    public final V remove(Object object) {
        assert (Thread.holdsLock(this));
        return (V)((StatementEntry)super.remove(object));
    }

    @Override
    protected final boolean removeEldestEntry(Map.Entry<K, V> entry) {
        assert (Thread.holdsLock(this));
        if (this.size() > this.capacity) {
            ((StatementEntry)entry.getValue()).closeQuietly();
            return true;
        }
        return false;
    }

    @Override
    public final void clear() {
        assert (Thread.holdsLock(this));
        for (StatementEntry statementEntry : this.values()) {
            statementEntry.closeQuietly();
        }
        super.clear();
    }

    @Override
    public final Collection<V> values() {
        assert (Thread.holdsLock(this));
        return super.values();
    }

    @Override
    public final synchronized void run() {
        Object object;
        long l = System.currentTimeMillis();
        Iterator<V> iterator = this.values().iterator();
        while (iterator.hasNext()) {
            object = (StatementEntry)iterator.next();
            long l2 = ((StatementEntry)object).expireTime - l;
            if (l2 > 0L) {
                Threads.executeDisposal((Runnable)this, (long)(l2 + 500L));
                this.monitorExit(false);
                return;
            }
            iterator.remove();
            ((StatementEntry)object).closeQuietly();
        }
        object = this.connection;
        this.connection = null;
        if (object != null) {
            try {
                object.close();
            }
            catch (Exception exception) {
                Logging.recoverableException((Logger)DefaultDataSource.LOGGER, Connection.class, (String)"close", (Throwable)exception);
            }
        }
        this.monitorExit(true);
    }

    protected void monitorExit(boolean bl) {
        assert (Thread.holdsLock(this));
        assert (!bl || this.isEmpty());
    }

    public final synchronized void close() throws SQLException {
        Iterator<V> iterator = this.values().iterator();
        while (iterator.hasNext()) {
            ((StatementEntry)iterator.next()).close();
            iterator.remove();
        }
        Connection connection = this.connection;
        this.connection = null;
        if (connection != null) {
            connection.close();
        }
    }
}

