/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.geotoolkit.internal.sql.Dialect;
import org.geotoolkit.internal.sql.TypeMapper;
import org.geotoolkit.lang.Builder;

public final class SQLBuilder
extends Builder<String> {
    private final Dialect dialect;
    private final String quote;
    private final String escape;
    private final StringBuilder buffer = new StringBuilder();

    public SQLBuilder(DatabaseMetaData databaseMetaData) throws SQLException {
        this.dialect = Dialect.guess((DatabaseMetaData)databaseMetaData);
        this.quote = databaseMetaData.getIdentifierQuoteString();
        this.escape = databaseMetaData.getSearchStringEscape();
    }

    public SQLBuilder(SQLBuilder sQLBuilder) {
        this.dialect = sQLBuilder.dialect;
        this.quote = sQLBuilder.quote;
        this.escape = sQLBuilder.escape;
    }

    public boolean isEmpty() {
        return this.buffer.length() == 0;
    }

    public SQLBuilder clear() {
        this.buffer.setLength(0);
        return this;
    }

    public SQLBuilder append(int n) {
        this.buffer.append(n);
        return this;
    }

    public SQLBuilder append(char c) {
        this.buffer.append(c);
        return this;
    }

    public SQLBuilder append(String string) {
        this.buffer.append(string);
        return this;
    }

    public SQLBuilder appendIdentifier(String string, String string2) {
        if (string != null) {
            this.appendIdentifier(string).append('.');
        }
        return this.appendIdentifier(string2);
    }

    public SQLBuilder appendIdentifier(String string) {
        this.buffer.append(this.quote).append(string).append(this.quote);
        return this;
    }

    public SQLBuilder appendIdentifier(String string, boolean bl) {
        return bl ? this.appendIdentifier(string) : this.append(string);
    }

    public SQLBuilder appendCondition(Object object) {
        if (object == null) {
            this.buffer.append("IS NULL");
            return this;
        }
        this.buffer.append('=');
        return this.appendValue(object);
    }

    public SQLBuilder appendValue(Object object) {
        if (object == null) {
            this.buffer.append("NULL");
        } else if (object instanceof Boolean) {
            this.buffer.append((Boolean)object != false ? "TRUE" : "FALSE");
        } else if (object instanceof Number) {
            this.buffer.append(object);
        } else {
            this.buffer.append('\'').append(SQLBuilder.doubleQuotes(object)).append('\'');
        }
        return this;
    }

    public SQLBuilder appendEscaped(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_%", true);
        while (stringTokenizer.hasMoreTokens()) {
            this.buffer.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) break;
            this.buffer.append(this.escape).append(stringTokenizer.nextToken());
        }
        return this;
    }

    public String createColumn(String string, String string2, String string3, Class<?> clazz, int n) {
        this.clear().append("ALTER TABLE ").appendIdentifier(string, string2).append(" ADD COLUMN ").appendIdentifier(string3).append(' ');
        String string4 = TypeMapper.keywordFor(clazz);
        if (string4 != null) {
            this.append(string4);
        } else {
            this.append("VARCHAR(").append(n).append(')');
        }
        return this.toString();
    }

    public String createForeignKey(String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (this.dialect == Dialect.DERBY) {
            bl = false;
        }
        this.buffer.setLength(0);
        String string6 = this.buffer.append(string2).append('_').append(string3).append("_fkey").toString();
        return this.clear().append("ALTER TABLE ").appendIdentifier(string, string2).append(" ADD CONSTRAINT ").appendIdentifier(string6).append(" FOREIGN KEY(").appendIdentifier(string3).append(") REFERENCES ").appendIdentifier(string, string4).append(" (").append(string5).append(") ON UPDATE ").append(bl ? "CASCADE" : "RESTRICT").append(" ON DELETE RESTRICT").toString();
    }

    public static String doubleQuotes(Object object) {
        return object.toString().replace("'", "''");
    }

    public String build() {
        return this.toString();
    }

    public String toString() {
        return this.buffer.toString();
    }
}

