/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image.io;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.util.Localized;
import org.geotoolkit.image.io.WarningProducer;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;

public final class Warnings
extends Static {
    private Warnings() {
    }

    public static boolean log(Object object, LogRecord logRecord) {
        if (object instanceof WarningProducer) {
            return ((WarningProducer)object).warningOccurred(logRecord);
        }
        logRecord.setLoggerName(WarningProducer.LOGGER.getName());
        WarningProducer.LOGGER.log(logRecord);
        return false;
    }

    public static void log(WarningProducer warningProducer, Level level, Class<?> clazz, String string, Exception exception) {
        String string2 = exception.getLocalizedMessage();
        if (string2 == null || (string2 = string2.trim()).indexOf(32) < 0) {
            String string3 = string2;
            string2 = Classes.getShortClassName((Object)exception);
            if (string3 != null) {
                string2 = string2 + ": " + string3;
            }
        }
        Warnings.log(warningProducer, level, clazz, string, string2);
    }

    public static void log(WarningProducer warningProducer, Level level, Class<?> clazz, String string, String string2) {
        if (level == null) {
            level = Level.WARNING;
        }
        LogRecord logRecord = new LogRecord(level, string2);
        if (warningProducer != null) {
            logRecord.setSourceClassName(clazz.getCanonicalName());
            logRecord.setSourceMethodName(string);
            warningProducer.warningOccurred(logRecord);
        } else {
            Logging.log(clazz, (String)string, (LogRecord)logRecord);
        }
    }

    public static void log(WarningProducer warningProducer, Level level, Class<?> clazz, String string, int n, Object ... objectArray) {
        if (level == null) {
            level = Level.WARNING;
        }
        LogRecord logRecord = Errors.getResources((Locale)(warningProducer != null ? warningProducer.getLocale() : null)).getLogRecord(level, n, (Object)objectArray);
        if (warningProducer != null) {
            logRecord.setSourceClassName(clazz.getCanonicalName());
            logRecord.setSourceMethodName(string);
            warningProducer.warningOccurred(logRecord);
        } else {
            Logging.log(clazz, (String)string, (LogRecord)logRecord);
        }
    }

    public static String message(Localized localized, int n, Object ... objectArray) {
        return Errors.getResources((Locale)(localized != null ? localized.getLocale() : null)).getString(n, (Object)objectArray);
    }
}

