/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image.io;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.imageio.metadata.IIOMetadata;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.image.io.metadata.MetadataHelper;
import org.geotoolkit.image.io.metadata.MetadataNodeAccessor;
import org.geotoolkit.internal.image.io.DimensionAccessor;
import org.geotoolkit.metadata.iso.spatial.PixelTranslation;
import org.geotoolkit.referencing.cs.DiscreteReferencingFactory;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.CodeList;

public final class GridDomainAccessor
extends MetadataNodeAccessor {
    public static final String ARRAY_ATTRIBUTE_NAME = "values";
    private static final double EPS = 1.0E-10;
    private MetadataNodeAccessor offsetVectors;

    public GridDomainAccessor(IIOMetadata iIOMetadata) {
        super(iIOMetadata, "geotk-coverageio_3.07", "RectifiedGridDomain", null);
    }

    public void setGridGeometry(GridGeometry gridGeometry, PixelInCell pixelInCell, CellGeometry cellGeometry, int n) {
        Matrix matrix;
        int n2;
        Object object;
        GridEnvelope gridEnvelope = gridGeometry.getExtent();
        if (gridEnvelope != null) {
            int n3 = gridEnvelope.getDimension();
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = gridEnvelope.getLow(i);
                nArray2[i] = gridEnvelope.getHigh(i);
            }
            object = gridGeometry.getGridToCRS();
            if (object != null) {
                n2 = object.getTargetDimensions();
                double[] dArray = new double[Math.max(n2, n3)];
                for (int i = 0; i < n3; ++i) {
                    dArray[i] = 0.5 * (double)(nArray[i] + nArray2[i]);
                }
                try {
                    object.transform(dArray, 0, dArray, 0, 1);
                    dArray = DimensionAccessor.fixRoundingError(ArraysExt.resize((double[])dArray, (int)n2));
                    this.setSpatialRepresentation(dArray, cellGeometry, PixelTranslation.getPixelOrientation((PixelInCell)pixelInCell));
                }
                catch (TransformException transformException) {
                    Logging.unexpectedException(GridDomainAccessor.class, (String)"setGridGeometry", (Throwable)transformException);
                }
            }
            this.setLimits(nArray, nArray2);
        }
        if ((matrix = DiscreteReferencingFactory.getAffineTransform((GridGeometry)gridGeometry, (PixelInCell)pixelInCell)) != null) {
            if (n >= 0) {
                if (gridEnvelope == null) {
                    return;
                }
                int n4 = gridEnvelope.getSpan(n);
                if (pixelInCell == null || pixelInCell.equals((Object)PixelInCell.CELL_CENTER)) {
                    --n4;
                }
                Matrices.reverseAxisDirection((Matrix)matrix, (int)n, (double)n4);
            }
            int n5 = matrix.getNumCol() - 1;
            int n6 = matrix.getNumRow() - 1;
            object = new double[n6];
            for (n2 = 0; n2 < n6; ++n2) {
                object[n2] = (MathTransform)matrix.getElement(n2, n5);
            }
            this.setOrigin(DimensionAccessor.fixRoundingError((double[])object));
            double[] dArray = new double[n5];
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n5; ++j) {
                    dArray[j] = matrix.getElement(i, j);
                }
                this.addOffsetVector(DimensionAccessor.fixRoundingError(dArray));
            }
        }
    }

    public void setLimits(int[] nArray, int[] nArray2) {
        MetadataNodeAccessor metadataNodeAccessor = new MetadataNodeAccessor(this, "Limits", null);
        metadataNodeAccessor.setAttribute("low", nArray);
        metadataNodeAccessor.setAttribute("high", nArray2);
    }

    public void setGridToCRS(AffineTransform affineTransform) {
        double[] dArray = new double[]{affineTransform.getTranslateX(), affineTransform.getTranslateY()};
        this.setOrigin(DimensionAccessor.fixRoundingError(dArray));
        dArray[0] = affineTransform.getScaleX();
        dArray[1] = affineTransform.getShearY();
        this.addOffsetVector(DimensionAccessor.fixRoundingError(dArray));
        dArray[0] = affineTransform.getShearX();
        dArray[1] = affineTransform.getScaleY();
        this.addOffsetVector(DimensionAccessor.fixRoundingError(dArray));
    }

    public void setOrigin(double ... dArray) {
        this.setAttribute("origin", dArray);
    }

    public void addOffsetVector(double ... dArray) {
        MetadataNodeAccessor metadataNodeAccessor = this.offsetVectors;
        if (metadataNodeAccessor == null) {
            this.offsetVectors = metadataNodeAccessor = new MetadataNodeAccessor(this, "OffsetVectors", "OffsetVector");
        }
        metadataNodeAccessor.selectChild(metadataNodeAccessor.appendChild());
        metadataNodeAccessor.setAttribute(ARRAY_ATTRIBUTE_NAME, dArray);
    }

    public void setSpatialRepresentation(double[] dArray, CellGeometry cellGeometry, PixelOrientation pixelOrientation) {
        MetadataNodeAccessor metadataNodeAccessor = new MetadataNodeAccessor(this.metadata, "geotk-coverageio_3.07", "SpatialRepresentation", null);
        metadataNodeAccessor.setAttribute("numberOfDimensions", dArray.length);
        metadataNodeAccessor.setAttribute("centerPoint", dArray);
        metadataNodeAccessor.setAttribute("pointInPixel", (CodeList<?>)pixelOrientation);
        metadataNodeAccessor.setAttribute("cellGeometry", (CodeList<?>)cellGeometry);
    }

    public void setAll(AffineTransform affineTransform, Rectangle rectangle, CellGeometry cellGeometry, PixelOrientation pixelOrientation) {
        this.setGridToCRS(affineTransform);
        this.setLimits(new int[]{rectangle.x, rectangle.y}, new int[]{rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1});
        double[] dArray = new double[]{rectangle.getCenterX(), rectangle.getCenterY()};
        affineTransform.transform(dArray, 0, dArray, 0, 1);
        Point2D point2D = new Point2D.Double(rectangle.getWidth(), rectangle.getHeight());
        point2D = affineTransform.deltaTransform(point2D, point2D);
        double d = Math.hypot(point2D.getX(), point2D.getY()) * 1.0E-10;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = GridDomainAccessor.adjustForRoundingError(dArray[i], d);
        }
        this.setSpatialRepresentation(dArray, cellGeometry, pixelOrientation);
    }

    private static void checkDimension(String string, int n, int n2) {
        if (n != n2) {
            throw new IllegalArgumentException(Errors.format((int)113, (Object)string, (Object)n, (Object)n2));
        }
    }

    public void setSpatialRepresentation(double[] dArray, double[] dArray2, CellGeometry cellGeometry, PixelOrientation pixelOrientation) {
        int n = dArray.length;
        GridDomainAccessor.checkDimension("bounds", dArray2.length, n);
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = 1.0E-10 * (dArray2[i] - dArray[i]);
            dArray3[i] = GridDomainAccessor.adjustForRoundingError(0.5 * (dArray[i] + dArray2[i]), d);
        }
        this.setSpatialRepresentation(dArray3, cellGeometry, pixelOrientation);
    }

    public void setRectifiedGridDomain(double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, int[] nArray3, boolean bl) {
        int n = dArray.length;
        int n2 = nArray2.length;
        if (nArray == null) {
            nArray = new int[n2];
        }
        GridDomainAccessor.checkDimension("low", nArray.length, n2);
        GridDomainAccessor.checkDimension("bounds", dArray2.length, n);
        if (n < n2) {
            GridDomainAccessor.checkDimension("origin", n, n2);
        }
        if (nArray3 != null) {
            GridDomainAccessor.checkDimension("gridToCrsDim", nArray3.length, n2);
        }
        this.setOrigin(dArray);
        double[] dArray3 = new double[n];
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray3 != null ? nArray3[i] : i;
            int n4 = nArray2[i] - nArray[i];
            if (!bl) {
                ++n4;
            }
            dArray3[n3] = GridDomainAccessor.adjustForRoundingError((dArray2[i] - dArray[i]) / (double)n4, 0.0);
            this.addOffsetVector(dArray3);
            dArray3[n3] = 0.0;
        }
        this.setLimits(nArray, nArray2);
    }

    public void setAll(double d, double d2, double d3, double d4, int n, int n2, boolean bl, CellGeometry cellGeometry) {
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{d3, d4};
        int[] nArray = new int[]{n - 1, n2 - 1};
        this.setRectifiedGridDomain(dArray, dArray2, null, nArray, null, bl);
        this.setSpatialRepresentation(dArray, dArray2, cellGeometry, bl ? PixelOrientation.CENTER : PixelOrientation.UPPER_LEFT);
    }

    private static double adjustForRoundingError(double d, double d2) {
        if (Math.abs(d = MetadataHelper.INSTANCE.adjustForRoundingError(d)) <= d2) {
            d = 0.0;
        }
        return d;
    }
}

