/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image.io;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.geotoolkit.image.io.DimensionSet;
import org.geotoolkit.image.io.DimensionSlice;
import org.geotoolkit.image.io.IllegalImageDimensionException;
import org.geotoolkit.image.io.MultidimensionalImageStore;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.collection.XCollections;

public final class DimensionManager
extends DimensionSet {
    public static final int DEFAULT_IMAGE_INDEX = 0;
    private List<String> variableNames;
    private Map<Integer, List<String>> bandNames;

    public DimensionManager(MultidimensionalImageStore multidimensionalImageStore) {
        super(multidimensionalImageStore);
    }

    @Override
    public void clear() {
        super.clear();
        XCollections.clear(this.bandNames);
        this.variableNames = null;
    }

    public boolean usesImageAPI() {
        return this.getAPIs().contains((Object)DimensionSlice.API.IMAGES);
    }

    public void setImageNames(String ... stringArray) {
        if (stringArray != null) {
            stringArray = (String[])stringArray.clone();
            this.ensureNonNull(stringArray);
            this.variableNames = UnmodifiableArrayList.wrap((Object[])stringArray);
        } else {
            this.variableNames = null;
        }
    }

    public List<String> getImageNames() {
        return this.variableNames;
    }

    public void setBandNames(int n, String ... stringArray) {
        if (stringArray == null) {
            if (this.bandNames != null) {
                this.bandNames.remove(n);
            }
        } else {
            if (stringArray.length == 0) {
                throw new IllegalArgumentException(this.errors().getString(58));
            }
            if (this.bandNames == null) {
                this.bandNames = new HashMap<Integer, List<String>>();
            }
            stringArray = (String[])stringArray.clone();
            this.ensureNonNull(stringArray);
            this.bandNames.put(n, (List<String>)UnmodifiableArrayList.wrap((Object[])stringArray));
        }
    }

    public List<String> getBandNames(int n) {
        return this.bandNames != null ? this.bandNames.get(n) : null;
    }

    public String getVariableName(int n) {
        List<String> list = this.getBandNames(n);
        if (list != null) {
            for (String string : list) {
                if (string == null) continue;
                return string;
            }
        }
        if (this.variableNames != null) {
            return this.variableNames.get(n);
        }
        return null;
    }

    public int replaceImageIndex(int n) throws IllegalImageDimensionException {
        if (n != 0 && this.usesImageAPI()) {
            String string = null;
            if (this.variableNames != null) {
                switch (this.variableNames.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        string = this.variableNames.get(0);
                        break;
                    }
                    default: {
                        throw new IllegalImageDimensionException(this.errors().getString(56, (Object)"variableName"));
                    }
                }
            }
            if (this.bandNames != null) {
                for (Map.Entry<Integer, List<String>> entry : this.bandNames.entrySet()) {
                    List<String> list;
                    int n2 = entry.getKey();
                    if (n2 != 0) {
                        throw new IllegalImageDimensionException(this.errors().getString(210, (Object)("bandNames(" + n2 + ')')));
                    }
                    if (string == null || (list = entry.getValue()).isEmpty() || list.contains(string)) continue;
                    throw new IllegalImageDimensionException(this.errors().getString(95));
                }
            }
            n = 0;
        }
        return n;
    }

    private void ensureNonNull(String[] stringArray) throws NullArgumentException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string != null) continue;
            throw new NullArgumentException(this.errors().getString(172, (Object)("names[" + i + ']')));
        }
    }

    private Errors errors() {
        return Errors.getResources((Locale)this.getLocale());
    }
}

