/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image.io;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.measure.unit.Unit;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.image.io.metadata.MetadataNodeAccessor;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.util.NumberRange;
import org.opengis.coverage.SampleDimension;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

public final class DimensionAccessor
extends MetadataNodeAccessor {
    private static final double EPS = 1.0E-10;

    public DimensionAccessor(IIOMetadata iIOMetadata) {
        super(iIOMetadata, "geotk-coverageio_3.07", "ImageDescription/Dimensions", "Dimension");
    }

    public void setDimension(SampleDimension sampleDimension, Locale locale) {
        InternationalString internationalString = sampleDimension.getDescription();
        if (internationalString != null) {
            this.setDescriptor(internationalString.toString(locale));
        }
        double d = sampleDimension.getMinimumValue();
        double d2 = sampleDimension.getMaximumValue();
        this.setValueRange(d, d2);
        double[] dArray = sampleDimension.getNoDataValues();
        if (dArray == null && sampleDimension instanceof GridSampleDimension && (dArray = ((GridSampleDimension)sampleDimension).geophysics(false).getNoDataValues()) != null) {
            int n = 0;
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = dArray[i];
                if (!(d3 < d) && !(d3 > d2)) continue;
                dArray[n++] = d3;
            }
            dArray = ArraysExt.resize((double[])dArray, (int)n);
        }
        this.setFillSampleValues(dArray);
        this.setTransfertFunction(sampleDimension.getScale(), sampleDimension.getOffset(), null);
        this.setUnits(sampleDimension.getUnits());
    }

    public void setDescriptor(String string) {
        this.setAttribute("descriptor", string);
    }

    public void setUnits(String string) {
        this.setAttribute("units", string);
    }

    public void setUnits(Unit<?> unit) {
        this.setAttribute("units", unit);
    }

    public void setValueRange(float f, float f2) {
        if (f == -3.4028235E38f) {
            f = Float.NEGATIVE_INFINITY;
        }
        if (f2 == Float.MAX_VALUE) {
            f2 = Float.POSITIVE_INFINITY;
        }
        this.setAttribute("minValue", f);
        this.setAttribute("maxValue", f2);
    }

    public void setValueRange(double d, double d2) {
        if (d == -1.7976931348623157E308) {
            d = Double.NEGATIVE_INFINITY;
        }
        if (d2 == Double.MAX_VALUE) {
            d2 = Double.POSITIVE_INFINITY;
        }
        this.setAttribute("minValue", d);
        this.setAttribute("maxValue", d2);
    }

    public void setValidSampleValue(double d, double d2) {
        if (d <= d2 && !Double.isInfinite(d) && !Double.isInfinite(d2)) {
            this.setValidSampleValue(NumberRange.createBestFit((Number)d, (boolean)true, (Number)d2, (boolean)true));
        }
    }

    public void setValidSampleValue(NumberRange<?> numberRange) {
        this.setAttribute("validSampleValues", numberRange);
    }

    public void setFillSampleValues(int n) {
        this.setAttribute("fillSampleValues", n);
    }

    public void setFillSampleValues(int ... nArray) {
        this.setAttribute("fillSampleValues", nArray);
    }

    public void setFillSampleValues(float f) {
        this.setAttribute("fillSampleValues", f);
    }

    public void setFillSampleValues(float ... fArray) {
        this.setAttribute("fillSampleValues", fArray);
    }

    public void setFillSampleValues(double d) {
        this.setAttribute("fillSampleValues", d);
    }

    public void setFillSampleValues(double ... dArray) {
        this.setAttribute("fillSampleValues", dArray);
    }

    public void setTransfertFunction(double d, double d2, TransferFunctionType transferFunctionType) {
        this.setAttribute("scaleFactor", d);
        this.setAttribute("offset", d2);
        this.setAttribute("transferFunctionType", (CodeList<?>)transferFunctionType);
    }

    public void scanValidSampleValue(ImageReader imageReader, int n) throws IOException {
        int n2 = 0;
        RectIter rectIter = RectIterFactory.create((RenderedImage)imageReader.readAsRenderedImage(n, null), null);
        rectIter.startBands();
        if (!rectIter.finishedBands()) {
            do {
                if (n2 >= this.childCount()) {
                    n2 = this.appendChild();
                }
                this.selectChild(n2);
                this.setAttribute("minValue", Double.NaN);
                this.setAttribute("maxValue", Double.NaN);
                double[] dArray = this.getAttributeAsDoubles("fillSampleValues", true);
                double d = Double.POSITIVE_INFINITY;
                double d2 = Double.NEGATIVE_INFINITY;
                rectIter.startLines();
                if (!rectIter.finishedLines()) {
                    do {
                        rectIter.startPixels();
                        if (rectIter.finishedPixels()) continue;
                        block2: do {
                            double d3 = rectIter.getSampleDouble();
                            if (dArray != null) {
                                for (double d4 : dArray) {
                                    if (d3 == d4) continue block2;
                                }
                            }
                            if (d3 < d) {
                                d = d3;
                            }
                            if (!(d3 > d2)) continue;
                            d2 = d3;
                        } while (!rectIter.nextPixelDone());
                    } while (!rectIter.nextLineDone());
                }
                this.setValidSampleValue(d, d2);
                ++n2;
            } while (!rectIter.nextBandDone());
        }
    }

    public boolean isScanSuggested(ImageReader imageReader, int n) throws IOException {
        int n2 = this.childCount();
        for (int i = 0; i < n2; ++i) {
            this.selectChild(i);
            if (this.getAttribute("validSampleValues") != null) continue;
            Double d = this.getAttributeAsDouble("minValue");
            Double d2 = this.getAttributeAsDouble("maxValue");
            if (d != null && d2 != null && d <= d2) continue;
            return ImageUtilities.isFloatType((int)imageReader.getRawImageType(n).getSampleModel().getDataType());
        }
        return false;
    }

    public static double fixRoundingError(double d) {
        double d2 = d * 36000.0;
        double d3 = Math.rint(d2);
        if (d2 != d3 && Math.abs(d2 - d3) <= 1.0E-10) {
            d = d3 / 36000.0;
        }
        if (d == 0.0) {
            d = 0.0;
        }
        return d;
    }

    public static double[] fixRoundingError(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = DimensionAccessor.fixRoundingError(dArray[i]);
        }
        return dArray;
    }
}

