/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image.io;

import java.util.List;
import java.util.Locale;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;

public final class DataTypes
extends Static {
    public static final List<String> CRS_TYPES = UnmodifiableArrayList.wrap((Object[])new String[]{"geographic", "projected"});
    private static final Class<? extends CoordinateReferenceSystem>[] CRS_INTERFACES = new Class[]{GeographicCRS.class, ProjectedCRS.class};
    public static final List<String> CS_TYPES = UnmodifiableArrayList.wrap((Object[])new String[]{"ellipsoidal", "cartesian"});
    private static final Class<? extends CoordinateSystem>[] CS_INTERFACES = new Class[]{EllipsoidalCS.class, CartesianCS.class};
    public static final List<String> DATUM_TYPES = UnmodifiableArrayList.wrap((Object[])new String[]{"geodetic", "vertical", "temporal", "image", "engineering"});
    private static final Class<? extends Datum>[] DATUM_INTERFACES = new Class[]{GeodeticDatum.class, VerticalDatum.class, TemporalDatum.class, ImageDatum.class, EngineeringDatum.class};

    private DataTypes() {
    }

    public static int getDataBufferType(String string) {
        if ((string = string.toUpperCase(Locale.US)).equals("BYTE")) {
            return 0;
        }
        if (string.equals("SHORT")) {
            return 2;
        }
        if (string.equals("USHORT")) {
            return 1;
        }
        if (string.equals("INT")) {
            return 3;
        }
        if (string.equals("FLOAT")) {
            return 4;
        }
        if (string.equals("DOUBLE")) {
            return 5;
        }
        return 32;
    }

    public static <T extends IdentifiedObject> Class<? extends T> getInterface(Class<T> clazz, String string) throws ClassCastException {
        List<String> list;
        Class<? extends CoordinateReferenceSystem>[] classArray;
        if (CoordinateReferenceSystem.class.isAssignableFrom(clazz)) {
            classArray = CRS_INTERFACES;
            list = CRS_TYPES;
        } else if (CoordinateSystem.class.isAssignableFrom(clazz)) {
            classArray = CS_INTERFACES;
            list = CS_TYPES;
        } else if (Datum.class.isAssignableFrom(clazz)) {
            classArray = DATUM_INTERFACES;
            list = DATUM_TYPES;
        } else {
            throw new IllegalArgumentException(clazz.getName());
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (!string.equalsIgnoreCase(list.get(i))) continue;
            return classArray[i].asSubclass(clazz);
        }
        return null;
    }

    private static <T extends IdentifiedObject> String getType(T t, Class<? extends T>[] classArray, List<String> list) {
        for (int i = 0; i < classArray.length; ++i) {
            Class<T> clazz = classArray[i];
            if (!clazz.isInstance(t)) continue;
            return list.get(i);
        }
        return null;
    }

    public static String getType(CoordinateReferenceSystem coordinateReferenceSystem) {
        return DataTypes.getType(coordinateReferenceSystem, CRS_INTERFACES, CRS_TYPES);
    }

    public static String getType(CoordinateSystem coordinateSystem) {
        return DataTypes.getType(coordinateSystem, CS_INTERFACES, CS_TYPES);
    }

    public static String getType(Datum datum) {
        return DataTypes.getType(datum, DATUM_INTERFACES, DATUM_TYPES);
    }
}

