/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.image.io;

import java.io.IOException;
import java.util.Arrays;
import javax.imageio.stream.ImageInputStream;
import org.geotoolkit.image.io.XImageIO;
import org.geotoolkit.internal.image.io.ImageInputStreamProxy;
import org.geotoolkit.util.logging.Logging;

public final class CheckedImageInputStream
extends ImageInputStreamProxy {
    private volatile boolean isClosed;
    private final StackTraceElement[] creator;

    private CheckedImageInputStream(ImageInputStream imageInputStream) {
        super(imageInputStream);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            String string = stackTraceElementArray[i].getClassName();
            if (string.equals("java.lang.Thread") || string.equals("org.geotoolkit.internal.image.io.CheckedImageInputStream")) continue;
            stackTraceElementArray = Arrays.copyOfRange(stackTraceElementArray, i, stackTraceElementArray.length);
            break;
        }
        this.creator = stackTraceElementArray;
    }

    public static ImageInputStream wrap(ImageInputStream imageInputStream) {
        if (imageInputStream != null && !(imageInputStream instanceof CheckedImageInputStream)) {
            imageInputStream = new CheckedImageInputStream(imageInputStream);
        }
        return imageInputStream;
    }

    public static boolean isValid(ImageInputStream imageInputStream) {
        return imageInputStream == null || imageInputStream instanceof CheckedImageInputStream && !((CheckedImageInputStream)imageInputStream).isClosed;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        super.close();
    }

    protected void finalize() {
        if (!this.isClosed) {
            StringBuilder stringBuilder = new StringBuilder("ImageInputStream created below has not been closed:\n");
            for (StackTraceElement stackTraceElement : this.creator) {
                stringBuilder.append("  ").append(stackTraceElement).append('\n');
            }
            Logging.getLogger(XImageIO.class).warning(stringBuilder.toString());
        }
    }
}

