/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.geotoolkit.image.io.stream.FinalizationStopper;
import org.geotoolkit.util.logging.Logging;

public class UrlInputSpi
extends ImageInputStreamSpi {
    private static final int RETRY = 3;
    private final Proxy proxy;

    public UrlInputSpi() {
        this(Proxy.NO_PROXY);
    }

    public UrlInputSpi(Proxy proxy) {
        super("Geotoolkit.org", "3.00", URL.class);
        this.proxy = proxy;
    }

    @Override
    public String getDescription(Locale locale) {
        return "Stream from a URL.";
    }

    @Override
    public boolean needsCacheFile() {
        return true;
    }

    @Override
    public ImageInputStream createInputStreamInstance(Object object, boolean bl, File file) throws IOException {
        InputStream inputStream;
        URL uRL = (URL)object;
        URLConnection uRLConnection = Proxy.NO_PROXY.equals(this.proxy) ? null : uRL.openConnection(this.proxy);
        int n = 3;
        while (true) {
            try {
                inputStream = uRLConnection != null ? uRLConnection.getInputStream() : uRL.openStream();
            }
            catch (SocketException socketException) {
                if (--n < 0) {
                    throw socketException;
                }
                Logging.recoverableException(UrlInputSpi.class, (String)"createInputStreamInstance", (Throwable)socketException);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.gc();
                Thread.interrupted();
                FinalizationStopper finalizationStopper = new FinalizationStopper(4000L);
                System.runFinalization();
                finalizationStopper.cancel();
                if (!Thread.interrupted() && !finalizationStopper.interrupted) continue;
                Logging.getLogger(UrlInputSpi.class).warning("System.runFinalization() was blocked.");
                continue;
            }
            break;
        }
        return new FileCacheImageInputStream(inputStream, file);
    }
}

