/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.stream;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.internal.io.Buffers;
import org.geotoolkit.resources.Errors;

public class ChannelImageInputStream
extends InputStream
implements ImageInputStream {
    protected final ReadableByteChannel channel;
    protected final ByteBuffer buffer;
    private transient ByteBuffer dupBuffer;
    private transient CharBuffer charBuffer;
    private transient ShortBuffer shortBuffer;
    private transient IntBuffer intBuffer;
    private transient LongBuffer longBuffer;
    private transient FloatBuffer floatBuffer;
    private transient DoubleBuffer doubleBuffer;
    private transient StringBuilder stringBuffer;
    private long bufferPosition;
    private int bitOffset;
    private Mark mark;

    public ChannelImageInputStream(ReadableByteChannel readableByteChannel, int n) {
        if (n < 16) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)"size", (Object)n));
        }
        this.channel = readableByteChannel;
        this.buffer = ByteBuffer.allocate(n);
        this.buffer.limit(0);
    }

    public ChannelImageInputStream(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) {
        this.channel = readableByteChannel;
        this.buffer = byteBuffer;
        if (byteBuffer.capacity() < 16) {
            throw new IllegalArgumentException(Errors.format((int)72, (Object)"buffer"));
        }
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        if (!byteOrder.equals(this.buffer.order())) {
            this.clearViews();
            this.buffer.order(byteOrder);
        }
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.buffer.order();
    }

    private ByteBuffer getDuplicatedBuffer() {
        ByteBuffer byteBuffer = this.dupBuffer;
        if (byteBuffer == null) {
            this.dupBuffer = byteBuffer = this.buffer.duplicate();
        }
        return byteBuffer;
    }

    private int fillBuffer() throws IOException {
        this.bufferPosition += (long)this.buffer.position();
        this.buffer.clear();
        int n = this.channel.read(this.buffer);
        this.buffer.flip();
        return n;
    }

    private void ensureRemaining() throws IOException {
        if (!this.buffer.hasRemaining() && this.fillBuffer() <= 0) {
            throw new EOFException();
        }
    }

    private void ensureRemaining(int n) throws IOException {
        this.bitOffset = 0;
        int n2 = this.buffer.remaining();
        if (n2 < n) {
            int n3 = this.buffer.position();
            if (n3 != 0) {
                this.bufferPosition += (long)n3;
                for (int i = 0; i < n2; ++i) {
                    this.buffer.put(i, this.buffer.get());
                }
            }
            this.buffer.position(n2).limit(this.buffer.capacity());
            do {
                if (this.channel.read(this.buffer) > 0) continue;
                throw new EOFException();
            } while (this.buffer.position() < n);
            this.buffer.flip();
        }
    }

    @Override
    public long length() throws IOException {
        if (this.channel instanceof FileChannel) {
            return ((FileChannel)this.channel).size();
        }
        return -1L;
    }

    @Override
    public long getFlushedPosition() {
        return this.bufferPosition;
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.bufferPosition + (long)this.buffer.position();
    }

    @Override
    public int getBitOffset() throws IOException {
        return this.bitOffset;
    }

    @Override
    public void setBitOffset(int n) throws IOException {
        ArgumentChecks.ensureBetween((String)"bitOffset", (int)0, (int)7, (int)n);
        this.bitOffset = n;
    }

    private void pushBack() {
        this.buffer.position(this.buffer.position() - 1);
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        if (!this.buffer.hasRemaining() && this.fillBuffer() <= 0) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int readBit() throws IOException {
        this.ensureRemaining();
        int n = this.buffer.get() & 0xFF;
        int n2 = 8 - ++this.bitOffset;
        if (n2 == 0) {
            this.bitOffset = 0;
        } else {
            this.pushBack();
            n >>= n2;
        }
        return n & 1;
    }

    @Override
    public long readBits(int n) throws IOException {
        ArgumentChecks.ensureBetween((String)"numBits", (int)0, (int)64, (int)n);
        if (n == 0) {
            return 0L;
        }
        this.ensureRemaining();
        long l = this.buffer.get() & 255 >>> this.bitOffset;
        n -= 8 - this.bitOffset;
        while (n > 0) {
            this.ensureRemaining();
            l = l << 8 | (long)(this.buffer.get() & 0xFF);
            n -= 8;
        }
        if (n != 0) {
            l >>>= -n;
            this.bitOffset = 8 + n;
            this.pushBack();
        } else {
            this.bitOffset = 0;
        }
        return l;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        this.bitOffset = 0;
        this.ensureRemaining();
        return this.buffer.get();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        this.ensureRemaining(2);
        return this.buffer.getShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        this.ensureRemaining(2);
        return this.buffer.getChar();
    }

    @Override
    public int readInt() throws IOException {
        this.ensureRemaining(4);
        return this.buffer.getInt();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() throws IOException {
        this.ensureRemaining(8);
        return this.buffer.getLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.ensureRemaining(4);
        return this.buffer.getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.ensureRemaining(8);
        return this.buffer.getDouble();
    }

    @Override
    public String readLine() throws IOException {
        int n = this.read();
        if (n < 0) {
            return null;
        }
        StringBuilder stringBuilder = this.stringBuffer;
        if (stringBuilder == null) {
            this.stringBuffer = stringBuilder = new StringBuilder();
        }
        stringBuilder.append((char)n);
        block4: while ((n = this.read()) >= 0) {
            switch (n) {
                case 10: {
                    break block4;
                }
                case 13: {
                    n = this.read();
                    if (n < 0 || n == 10) break block4;
                    this.pushBack();
                    break block4;
                }
                default: {
                    stringBuilder.append((char)n);
                    continue block4;
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readUTF() throws IOException {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            String string = DataInputStream.readUTF(this);
            return string;
        }
        finally {
            this.buffer.order(byteOrder);
        }
    }

    private static void checkRange(int n, int n2, int n3) {
        if (n3 < 0 || (n -= n3) < 0) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)"length", (Object)n3));
        }
        ArgumentChecks.ensureBetween((String)"offset", (int)0, (int)n, (int)n2);
    }

    @Override
    public void readBytes(IIOByteBuffer iIOByteBuffer, int n) throws IOException {
        byte[] byArray = new byte[n];
        n = this.read(byArray);
        iIOByteBuffer.setData(byArray);
        iIOByteBuffer.setOffset(0);
        iIOByteBuffer.setLength(n);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        ChannelImageInputStream.checkRange(byArray.length, n, n2);
        this.bitOffset = 0;
        int n3 = n2;
        while (n2 != 0) {
            if (!this.buffer.hasRemaining() && this.fillBuffer() <= 0) {
                if (n3 != n2) break;
                return -1;
            }
            int n4 = Math.min(this.buffer.remaining(), n2);
            this.buffer.get(byArray, n, n4);
            n += n4;
            n2 -= n4;
        }
        return n3 - n2;
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        ChannelImageInputStream.checkRange(byArray.length, n, n2);
        this.bitOffset = 0;
        while (n2 != 0) {
            this.ensureRemaining();
            int n3 = Math.min(this.buffer.remaining(), n2);
            this.buffer.get(byArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    @Override
    public void readFully(char[] cArray, int n, int n2) throws IOException {
        ChannelImageInputStream.checkRange(cArray.length, n, n2);
        CharBuffer charBuffer = this.charBuffer;
        if (charBuffer == null) {
            this.charBuffer = charBuffer = Buffers.asCharBuffer((ByteBuffer)this.buffer);
        }
        while (n2 != 0) {
            this.syncView(charBuffer, 2);
            int n3 = Math.min(charBuffer.remaining(), n2);
            charBuffer.get(cArray, n, n3);
            this.syncBuffer(charBuffer, 2);
            n += n3;
            n2 -= n3;
        }
    }

    @Override
    public void readFully(short[] sArray, int n, int n2) throws IOException {
        ChannelImageInputStream.checkRange(sArray.length, n, n2);
        ShortBuffer shortBuffer = this.shortBuffer;
        if (shortBuffer == null) {
            this.shortBuffer = shortBuffer = Buffers.asShortBuffer((ByteBuffer)this.buffer);
        }
        while (n2 != 0) {
            this.syncView(shortBuffer, 2);
            int n3 = Math.min(shortBuffer.remaining(), n2);
            shortBuffer.get(sArray, n, n3);
            this.syncBuffer(shortBuffer, 2);
            n += n3;
            n2 -= n3;
        }
    }

    @Override
    public void readFully(int[] nArray, int n, int n2) throws IOException {
        ChannelImageInputStream.checkRange(nArray.length, n, n2);
        IntBuffer intBuffer = this.intBuffer;
        if (intBuffer == null) {
            this.intBuffer = intBuffer = Buffers.asIntBuffer((ByteBuffer)this.buffer);
        }
        while (n2 != 0) {
            this.syncView(intBuffer, 4);
            int n3 = Math.min(intBuffer.remaining(), n2);
            intBuffer.get(nArray, n, n3);
            this.syncBuffer(intBuffer, 4);
            n += n3;
            n2 -= n3;
        }
    }

    @Override
    public void readFully(long[] lArray, int n, int n2) throws IOException {
        ChannelImageInputStream.checkRange(lArray.length, n, n2);
        LongBuffer longBuffer = this.longBuffer;
        if (longBuffer == null) {
            this.longBuffer = longBuffer = Buffers.asLongBuffer((ByteBuffer)this.buffer);
        }
        while (n2 != 0) {
            this.syncView(longBuffer, 8);
            int n3 = Math.min(longBuffer.remaining(), n2);
            longBuffer.get(lArray, n, n3);
            this.syncBuffer(longBuffer, 8);
            n += n3;
            n2 -= n3;
        }
    }

    @Override
    public void readFully(float[] fArray, int n, int n2) throws IOException {
        ChannelImageInputStream.checkRange(fArray.length, n, n2);
        FloatBuffer floatBuffer = this.floatBuffer;
        if (floatBuffer == null) {
            this.floatBuffer = floatBuffer = Buffers.asFloatBuffer((ByteBuffer)this.buffer);
        }
        while (n2 != 0) {
            this.syncView(floatBuffer, 4);
            int n3 = Math.min(floatBuffer.remaining(), n2);
            floatBuffer.get(fArray, n, n3);
            this.syncBuffer(floatBuffer, 4);
            n += n3;
            n2 -= n3;
        }
    }

    @Override
    public void readFully(double[] dArray, int n, int n2) throws IOException {
        ChannelImageInputStream.checkRange(dArray.length, n, n2);
        DoubleBuffer doubleBuffer = this.doubleBuffer;
        if (doubleBuffer == null) {
            this.doubleBuffer = doubleBuffer = Buffers.asDoubleBuffer((ByteBuffer)this.buffer);
        }
        while (n2 != 0) {
            this.syncView(doubleBuffer, 8);
            int n3 = Math.min(doubleBuffer.remaining(), n2);
            doubleBuffer.get(dArray, n, n3);
            this.syncBuffer(doubleBuffer, 8);
            n += n3;
            n2 -= n3;
        }
    }

    private void syncView(Buffer buffer, int n) throws IOException {
        int n2 = this.buffer.position();
        int n3 = n2 % n;
        if (n3 != 0) {
            ByteBuffer byteBuffer = this.getDuplicatedBuffer();
            byteBuffer.limit(this.buffer.limit()).position(this.buffer.position());
            this.buffer.clear();
            this.buffer.put(byteBuffer).flip();
            this.bufferPosition += (long)n2;
        }
        this.ensureRemaining(n);
        n2 = this.buffer.position();
        assert (n2 % n == 0) : n2;
        buffer.limit(this.buffer.limit() / n).position(n2 / n);
    }

    private void syncBuffer(Buffer buffer, int n) {
        this.buffer.position(buffer.position() * n);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skipBytes((long)n);
    }

    @Override
    public long skipBytes(long l) throws IOException {
        int n;
        this.bitOffset = 0;
        for (long i = l; i > 0L; i -= (long)n) {
            n = this.buffer.remaining();
            if (i <= (long)n) {
                this.buffer.position(this.buffer.position() + (int)i);
                break;
            }
            this.buffer.position(this.buffer.limit());
            if (!(this.channel instanceof FileChannel)) continue;
            FileChannel fileChannel = (FileChannel)this.channel;
            long l2 = fileChannel.position();
            long l3 = fileChannel.size() - l2;
            if (i > l3) {
                l -= i - l3;
                i = l3;
            }
            fileChannel.position(l2 + i);
            this.bufferPosition += i;
            break;
        }
        return l;
    }

    @Override
    public void seek(long l) throws IOException, IllegalArgumentException {
        this.bitOffset = 0;
        long l2 = l - this.bufferPosition;
        if (l2 < 0L) {
            long l3 = this.length();
            throw new IndexOutOfBoundsException(Errors.format((int)246, (Object)l, (Object)this.bufferPosition, (Object)(l3 >= 0L ? Long.valueOf(l3) : "\u221e")));
        }
        if (l2 < (long)this.buffer.limit()) {
            this.buffer.position((int)l2);
        } else {
            this.skipBytes(l2 - (long)this.buffer.position());
        }
    }

    @Override
    public void mark() {
        this.mark = new Mark(this.bufferPosition + (long)this.buffer.position(), this.bitOffset, this.mark);
    }

    @Override
    public void reset() throws IOException {
        Mark mark = this.mark;
        if (mark == null) {
            throw new IOException("No marked position.");
        }
        this.seek(mark.position);
        this.bitOffset = mark.bitOffset;
        this.mark = mark.next;
    }

    @Override
    public void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    @Override
    public void flushBefore(long l) throws IOException {
        long l2 = l - this.bufferPosition;
        int n = this.buffer.position();
        if (l2 < 0L || l2 > (long)n) {
            throw new IndexOutOfBoundsException(Errors.format((int)246, (Object)l, (Object)this.bufferPosition, (Object)(this.bufferPosition + (long)n)));
        }
        if (l2 != 0L) {
            ByteBuffer byteBuffer = this.getDuplicatedBuffer();
            byteBuffer.limit(this.buffer.limit()).position((int)l2);
            this.buffer.clear();
            this.buffer.put(byteBuffer).flip().position(n - (int)l2);
            this.bufferPosition += l2;
        }
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public boolean isCachedMemory() {
        return false;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        this.clearViews();
        this.bufferPosition = 0L;
        this.bitOffset = 0;
        this.mark = null;
        this.stringBuffer = null;
    }

    private void clearViews() {
        this.dupBuffer = null;
        this.charBuffer = null;
        this.shortBuffer = null;
        this.intBuffer = null;
        this.longBuffer = null;
        this.floatBuffer = null;
        this.doubleBuffer = null;
    }

    private static final class Mark {
        final long position;
        final int bitOffset;
        final Mark next;

        Mark(long l, int n, Mark mark) {
            this.position = l;
            this.bitOffset = n;
            this.next = mark;
        }
    }
}

