/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.plugin;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.media.jai.iterator.RectIter;
import org.apache.sis.util.CharSequences;
import org.geotoolkit.image.ImageDimension;
import org.geotoolkit.image.io.TextImageWriter;
import org.geotoolkit.image.io.plugin.TextMatrixImageReader;
import org.geotoolkit.resources.Descriptions;

public class TextMatrixImageWriter
extends TextImageWriter {
    private static final int SEPARATOR_WIDTH = 1;

    protected TextMatrixImageWriter(Spi spi) {
        super(spi);
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.processImageStarted();
        BufferedWriter bufferedWriter = this.getWriter(imageWriteParam);
        String string = this.getLineSeparator(imageWriteParam);
        NumberFormat numberFormat = this.createNumberFormat(iIOImage, imageWriteParam);
        FieldPosition fieldPosition = this.getExpectedFractionPosition(numberFormat);
        int n = fieldPosition.getEndIndex() - fieldPosition.getBeginIndex();
        int n2 = fieldPosition.getEndIndex() + 1;
        StringBuffer stringBuffer = new StringBuffer(n2);
        RectIter rectIter = TextMatrixImageWriter.createRectIter(iIOImage, imageWriteParam);
        ImageDimension imageDimension = TextMatrixImageWriter.computeSize(iIOImage, imageWriteParam);
        float f = 100.0f / (float)imageDimension.getNumSampleValues();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if (!rectIter.finishedBands()) {
            do {
                if (bl) {
                    bufferedWriter.write(string);
                }
                if (!rectIter.finishedLines()) {
                    do {
                        if (n3 >= n4) {
                            this.processImageProgress(f * (float)n3);
                            n4 = n3 + 2000;
                        }
                        if (this.abortRequested()) {
                            this.processWriteAborted();
                            return;
                        }
                        if (!rectIter.finishedPixels()) {
                            do {
                                stringBuffer.setLength(0);
                                String string2 = numberFormat.format(rectIter.getSampleDouble(), stringBuffer, fieldPosition).toString();
                                int n5 = Math.max(0, n - (fieldPosition.getEndIndex() - fieldPosition.getBeginIndex()));
                                bufferedWriter.append(CharSequences.spaces((int)(n2 - string2.length() - n5)));
                                bufferedWriter.write(string2);
                                bufferedWriter.append(CharSequences.spaces((int)n5));
                            } while (!rectIter.nextPixelDone());
                        }
                        bufferedWriter.write(string);
                        n3 += imageDimension.width;
                        rectIter.startPixels();
                    } while (!rectIter.nextLineDone());
                }
                rectIter.startLines();
                bl = true;
            } while (!rectIter.nextBandDone());
        }
        bufferedWriter.flush();
        this.processImageComplete();
    }

    public static class Spi
    extends TextImageWriter.Spi {
        private static final String[] READERS = new String[]{"org.geotoolkit.image.io.plugin.TextMatrixImageReader$Spi"};

        public Spi() {
            this.names = TextMatrixImageReader.Spi.NAMES;
            this.MIMETypes = TextMatrixImageReader.Spi.MIME_TYPES;
            this.pluginClassName = "org.geotoolkit.image.io.plugin.TextMatrixImageWriter";
            this.readerSpiNames = READERS;
            this.nativeStreamMetadataFormatName = null;
        }

        @Override
        public String getDescription(Locale locale) {
            return Descriptions.getResources((Locale)locale).getString(1);
        }

        @Override
        public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
            return imageTypeSpecifier.getNumBands() == 1;
        }

        @Override
        public ImageWriter createWriterInstance(Object object) throws IOException {
            return new TextMatrixImageWriter(this);
        }
    }
}

