/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.plugin;

import com.sun.media.imageio.stream.RawImageInputStream;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.image.SampleModels;
import org.geotoolkit.image.io.SampleConverter;
import org.geotoolkit.image.io.SpatialImageReader;
import org.geotoolkit.image.io.UnsupportedImageFormatException;
import org.geotoolkit.lang.SystemOverride;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;

public class RawImageReader
extends SpatialImageReader {
    public RawImageReader(Spi spi) {
        super(spi);
    }

    @Override
    public int getNumImages(boolean bl) throws IllegalStateException, IOException {
        if (this.input instanceof RawImageInputStream) {
            return ((RawImageInputStream)this.input).getNumImages();
        }
        return super.getNumImages(bl);
    }

    @Override
    public int getWidth(int n) throws IOException {
        Dimension dimension;
        this.checkImageIndex(n);
        if (this.input instanceof RawImageInputStream && (dimension = ((RawImageInputStream)this.input).getImageDimension(n)) != null) {
            return dimension.width;
        }
        throw new IIOException(Errors.format((int)235));
    }

    @Override
    public int getHeight(int n) throws IOException {
        Dimension dimension;
        this.checkImageIndex(n);
        if (this.input instanceof RawImageInputStream && (dimension = ((RawImageInputStream)this.input).getImageDimension(n)) != null) {
            return dimension.height;
        }
        throw new IIOException(Errors.format((int)235));
    }

    @Override
    public int getNumBands(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier;
        if (this.input instanceof RawImageInputStream && (imageTypeSpecifier = ((RawImageInputStream)this.input).getImageType()) != null) {
            return imageTypeSpecifier.getSampleModel().getNumBands();
        }
        return super.getNumBands(n);
    }

    @Override
    protected int getRawDataType(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier;
        this.checkImageIndex(n);
        if (this.input instanceof RawImageInputStream && (imageTypeSpecifier = ((RawImageInputStream)this.input).getImageType()) != null) {
            return imageTypeSpecifier.getSampleModel().getDataType();
        }
        return super.getRawDataType(n);
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier;
        this.checkImageIndex(n);
        if (this.input instanceof RawImageInputStream && (imageTypeSpecifier = ((RawImageInputStream)this.input).getImageType()) != null) {
            return imageTypeSpecifier;
        }
        return super.getRawImageType(n);
    }

    @Override
    public boolean isRandomAccessEasy(int n) throws IOException {
        this.checkImageIndex(n);
        return true;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int[] nArray;
        DataBuffer dataBuffer;
        WritableRectIter writableRectIter;
        int n2;
        int n3;
        int[] nArray2;
        int[] nArray3;
        this.checkImageIndex(n);
        this.clearAbortRequest();
        ImageInputStream imageInputStream = (ImageInputStream)this.getInput();
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        if (SampleModels.getPixelStride((SampleModel)sampleModel) != 1.0f) {
            throw new UnsupportedImageFormatException(Errors.format((int)242, (Object)(Classes.getShortClassName((Object)sampleModel) + "[pixelStride = " + SampleModels.getPixelStride((SampleModel)sampleModel) + ']')));
        }
        int n4 = this.getWidth(n);
        int n5 = this.getHeight(n);
        int n6 = this.getNumBands(n);
        int n7 = sampleModel.getDataType();
        int n8 = Math.max(SampleModels.getScanlineStride((SampleModel)sampleModel), n4);
        int n9 = SampleModels.getDataTypeSize((SampleModel)sampleModel) / 8;
        long l = (long)n8 * (long)n9;
        if (imageReadParam != null) {
            nArray3 = imageReadParam.getSourceBands();
            nArray2 = imageReadParam.getDestinationBands();
            n3 = imageReadParam.getSourceXSubsampling();
            n2 = imageReadParam.getSourceYSubsampling();
        } else {
            nArray3 = null;
            nArray2 = null;
            n3 = 1;
            n2 = 1;
        }
        int n10 = nArray2 != null ? nArray2.length : n6;
        SampleConverter[] sampleConverterArray = new SampleConverter[n10];
        BufferedImage bufferedImage = this.getDestination(n, imageReadParam, n4, n5, sampleConverterArray);
        SampleModel sampleModel2 = bufferedImage.getSampleModel();
        RawImageReader.checkReadParamBandSettings(imageReadParam, n6, sampleModel2.getNumBands());
        this.processImageStarted(n);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        RawImageReader.computeRegions(imageReadParam, n4, n5, bufferedImage, rectangle, rectangle2);
        int n11 = SampleModels.getScanlineStride((SampleModel)sampleModel2);
        int n12 = SampleModels.getDataTypeSize((SampleModel)sampleModel2) * (n3 - 1) / 8;
        boolean bl = n3 == 1 && SampleModels.getPixelStride((SampleModel)sampleModel) == 1.0f && SampleModels.getPixelStride((SampleModel)sampleModel2) == 1.0f && sampleModel2.getDataType() == n7;
        boolean bl2 = bl && n2 == 1 && n11 == n8;
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (bl) {
            writableRectIter = null;
            dataBuffer = writableRaster.getDataBuffer();
            nArray = dataBuffer.getOffsets();
        } else {
            writableRectIter = RectIterFactory.createWritable((WritableRaster)writableRaster, (Rectangle)rectangle2);
            dataBuffer = null;
            nArray = null;
        }
        for (int i = 0; i < n10; ++i) {
            int n13;
            int n14;
            int n15;
            long l2;
            int n16 = nArray3 != null ? nArray3[i] : i;
            int n17 = nArray2 != null ? nArray2[i] : i;
            SampleConverter sampleConverter = sampleConverterArray[i];
            if (imageInputStream instanceof RawImageInputStream) {
                l2 = ((RawImageInputStream)imageInputStream).getImageOffset(n);
                l2 += l * (long)n5 * (long)n16;
            } else {
                l2 = l * (long)n5 * (long)(n6 * n + n16);
            }
            l2 += l * (long)rectangle.y + (long)(n9 * rectangle.x);
            if (bl) {
                int n18 = nArray.length == 1 ? 0 : n17;
                n15 = nArray[n18];
                if (bl2) {
                    n14 = 1;
                    n13 = n8 * rectangle2.height;
                } else {
                    n14 = rectangle2.height;
                    n13 = rectangle2.width;
                }
                float f = 100.0f / (float)(n14 * n10);
                int n19 = Math.max(1, Math.round(1.0f / f));
                for (int j = 0; j < n14; ++j) {
                    if (this.abortRequested()) {
                        this.processReadAborted();
                        return bufferedImage;
                    }
                    if (j % n19 == 0) {
                        this.processImageProgress((float)(j + i * n14) * f);
                    }
                    imageInputStream.seek(l2);
                    switch (n7) {
                        case 0: {
                            Object[] objectArray = ((DataBufferByte)dataBuffer).getData(n18);
                            imageInputStream.readFully((byte[])objectArray, n15, n13);
                            sampleConverter.convertUnsigned((byte[])objectArray, n15, n13);
                            break;
                        }
                        case 1: {
                            Object[] objectArray = ((DataBufferUShort)dataBuffer).getData(n18);
                            imageInputStream.readFully((short[])objectArray, n15, n13);
                            sampleConverter.convertUnsigned((short[])objectArray, n15, n13);
                            break;
                        }
                        case 2: {
                            Object[] objectArray = ((DataBufferShort)dataBuffer).getData(n18);
                            imageInputStream.readFully((short[])objectArray, n15, n13);
                            sampleConverter.convert((short[])objectArray, n15, n13);
                            break;
                        }
                        case 3: {
                            Object[] objectArray = ((DataBufferInt)dataBuffer).getData(n18);
                            imageInputStream.readFully((int[])objectArray, n15, n13);
                            sampleConverter.convert((int[])objectArray, n15, n13);
                            break;
                        }
                        case 4: {
                            Object[] objectArray = ((DataBufferFloat)dataBuffer).getData(n18);
                            imageInputStream.readFully((float[])objectArray, n15, n13);
                            sampleConverter.convert((float[])objectArray, n15, n13);
                            break;
                        }
                        case 5: {
                            Object[] objectArray = ((DataBufferDouble)dataBuffer).getData(n18);
                            imageInputStream.readFully((double[])objectArray, n15, n13);
                            sampleConverter.convert((double[])objectArray, n15, n13);
                            break;
                        }
                        default: {
                            throw new UnsupportedImageFormatException(Errors.format((int)239));
                        }
                    }
                    l2 += l * (long)n2;
                    n15 += n11;
                }
                continue;
            }
            float f = 100.0f / (float)(rectangle2.height * n10);
            n14 = Math.max(1, Math.round(1.0f / f));
            n13 = i * rectangle2.height;
            writableRectIter.startBands();
            n15 = n17;
            while (--n15 >= 0) {
                if (!writableRectIter.nextBandDone()) continue;
                throw new IIOException(Errors.format((int)5, (Object)n17));
            }
            writableRectIter.startLines();
            if (writableRectIter.finishedLines()) continue;
            do {
                block36: {
                    if (this.abortRequested()) {
                        this.processReadAborted();
                        return bufferedImage;
                    }
                    if (++n13 % n14 == 0) {
                        this.processImageProgress((float)n13 * f);
                    }
                    imageInputStream.seek(l2);
                    writableRectIter.startPixels();
                    if (!writableRectIter.finishedPixels()) {
                        do {
                            switch (n7) {
                                case 0: {
                                    writableRectIter.setSample(sampleConverter.convert(imageInputStream.readUnsignedByte()));
                                    break;
                                }
                                case 1: {
                                    writableRectIter.setSample(sampleConverter.convert(imageInputStream.readUnsignedShort()));
                                    break;
                                }
                                case 2: {
                                    writableRectIter.setSample(sampleConverter.convert(imageInputStream.readShort()));
                                    break;
                                }
                                case 3: {
                                    writableRectIter.setSample(sampleConverter.convert(imageInputStream.readInt()));
                                    break;
                                }
                                case 4: {
                                    writableRectIter.setSample(sampleConverter.convert(imageInputStream.readFloat()));
                                    break;
                                }
                                case 5: {
                                    writableRectIter.setSample(sampleConverter.convert(imageInputStream.readDouble()));
                                    break;
                                }
                                default: {
                                    throw new UnsupportedImageFormatException(Errors.format((int)239));
                                }
                            }
                            if (writableRectIter.nextPixelDone()) break block36;
                        } while (imageInputStream.skipBytes(n12) == n12);
                        throw new EOFException();
                    }
                }
                l2 += l * (long)n2;
            } while (!writableRectIter.nextLineDone());
        }
        this.processImageComplete();
        return bufferedImage;
    }

    public static class Spi
    extends SpatialImageReader.Spi
    implements SystemOverride {
        private static final String[] SUFFIXES = new String[]{"raw"};
        private static final String[] MIME_TYPES = new String[]{"image/x-raw"};
        private static final Class<?>[] INPUT_TYPES = new Class[]{RawImageInputStream.class};

        public Spi() {
            this.names = SUFFIXES;
            this.suffixes = SUFFIXES;
            this.inputTypes = INPUT_TYPES;
            this.MIMETypes = MIME_TYPES;
            this.pluginClassName = "org.geotoolkit.image.io.plugin.RawImageReader";
            this.nativeStreamMetadataFormatName = null;
            this.nativeImageMetadataFormatName = null;
        }

        @Override
        public String getDescription(Locale locale) {
            return Descriptions.getResources((Locale)locale).getString(2);
        }

        @Override
        public boolean canDecodeInput(Object object) throws IOException {
            RawImageInputStream rawImageInputStream;
            SampleModel sampleModel;
            return object instanceof RawImageInputStream && SampleModels.getPixelStride((SampleModel)(sampleModel = (rawImageInputStream = (RawImageInputStream)object).getImageType().getSampleModel())) == 1.0f;
        }

        @Override
        public ImageReader createReaderInstance(Object object) throws IOException {
            return new RawImageReader(this);
        }

        @Override
        public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
            super.onRegistration(serviceRegistry, clazz);
            if (clazz.equals(ImageReaderSpi.class)) {
                Iterator<ImageReaderSpi> iterator = serviceRegistry.getServiceProviders(ImageReaderSpi.class, false);
                while (iterator.hasNext()) {
                    ImageReaderSpi imageReaderSpi = iterator.next();
                    if (imageReaderSpi == this || !ArraysExt.contains((Object[])imageReaderSpi.getFormatNames(), (Object)"raw") || !imageReaderSpi.getClass().getName().startsWith("com.sun.media.")) continue;
                    ImageReaderSpi imageReaderSpi2 = this;
                    try {
                        if (Boolean.getBoolean("geotk.system.override")) {
                            imageReaderSpi2 = imageReaderSpi;
                            imageReaderSpi = this;
                        }
                    }
                    catch (SecurityException securityException) {
                        Logging.recoverableException(Spi.class, (String)"onRegistration", (Throwable)securityException);
                    }
                    serviceRegistry.setOrdering(ImageReaderSpi.class, imageReaderSpi, imageReaderSpi2);
                }
            }
        }
    }
}

