/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.plugin;

import com.sun.media.imageio.stream.RawImageInputStream;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import org.apache.sis.util.Localized;
import org.geotoolkit.image.io.ImageMetadataException;
import org.geotoolkit.image.io.SampleConverter;
import org.geotoolkit.image.io.TextImageReader;
import org.geotoolkit.image.io.WarningProducer;
import org.geotoolkit.image.io.metadata.SpatialMetadata;
import org.geotoolkit.image.io.plugin.RawImageReader;
import org.geotoolkit.image.io.stream.ChannelImageInputStream;
import org.geotoolkit.internal.image.io.DataTypes;
import org.geotoolkit.internal.image.io.DimensionAccessor;
import org.geotoolkit.internal.image.io.GridDomainAccessor;
import org.geotoolkit.internal.image.io.Warnings;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.resources.Errors;
import org.opengis.metadata.spatial.PixelOrientation;

public class AsciiGridReader
extends TextImageReader {
    private static final int BUFFER_SIZE = 16384;
    private boolean headerValid;
    private int width;
    private int height;
    private double xll;
    private double yll;
    private boolean xCenter;
    private boolean yCenter;
    private double scaleX;
    private double scaleY;
    private double fillValue;
    private double minValue;
    private double maxValue;
    private int binaryType;
    private transient ImageReader binaryReader;
    private transient ByteBuffer buffer;

    protected AsciiGridReader(Spi spi) {
        super(spi);
    }

    private static double parseDouble(String string) throws NumberFormatException {
        return Double.parseDouble(string.replace(',', '.'));
    }

    private void ensureHeaderRead() throws IOException {
        if (!this.headerValid) {
            String string;
            this.xCenter = true;
            this.yCenter = true;
            Map<String, String> map = this.readHeader();
            this.processHeader(map);
            String string2 = null;
            try {
                string2 = "NCOLS";
                this.width = Integer.parseInt(this.ensureDefined("NCOLS", map.remove(string2)));
                string2 = "NROWS";
                this.height = Integer.parseInt(this.ensureDefined("NROWS", map.remove(string2)));
                string2 = "CELLSIZE";
                string = map.remove("CELLSIZE");
                if (string != null) {
                    this.scaleX = this.scaleY = AsciiGridReader.parseDouble(string);
                } else {
                    string2 = "DX";
                    this.scaleX = AsciiGridReader.parseDouble(this.ensureDefined("CELLSIZE", map.remove("DX")));
                    string2 = "DY";
                    this.scaleY = AsciiGridReader.parseDouble(this.ensureDefined("CELLSIZE", map.remove("DY")));
                }
                string2 = "NODATA_VALUE";
                string = map.remove("NODATA_VALUE");
                this.fillValue = string != null ? AsciiGridReader.parseDouble(string) : super.getPadValue(0);
                string2 = "MIN_VALUE";
                string = map.remove("MIN_VALUE");
                this.minValue = string != null ? AsciiGridReader.parseDouble(string) : Double.NEGATIVE_INFINITY;
                string2 = "MAX_VALUE";
                string = map.remove("MAX_VALUE");
                this.maxValue = string != null ? AsciiGridReader.parseDouble(string) : Double.POSITIVE_INFINITY;
                string2 = "XLLCENTER";
                string = map.remove("XLLCENTER");
                if (string == null) {
                    string2 = "XLLCORNER";
                    string = map.remove("XLLCORNER");
                    this.xCenter = false;
                }
                this.xll = AsciiGridReader.parseDouble(this.ensureDefined(string2, string));
                string2 = "YLLCENTER";
                string = map.remove("YLLCENTER");
                if (string == null) {
                    string2 = "YLLCORNER";
                    string = map.remove("YLLCORNER");
                    this.yCenter = false;
                }
                this.yll = AsciiGridReader.parseDouble(this.ensureDefined(string2, string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IIOException(Warnings.message((Localized)this, 232, string2), numberFormatException);
            }
            this.binaryType = 32;
            string = map.remove("BINARY_TYPE");
            if (string != null) {
                this.binaryType = DataTypes.getDataBufferType(string);
                if (this.binaryType == 32) {
                    Warnings.log(this, null, AsciiGridReader.class, "readHeader", 12, "BINARY_TYPE", string);
                }
            }
            this.headerValid = true;
            for (String string3 : map.keySet()) {
                Warnings.log(this, null, AsciiGridReader.class, "readHeader", 223, string3);
            }
        }
    }

    private String ensureDefined(String string, String string2) throws IIOException {
        if (string2 == null || string2.isEmpty()) {
            throw new ImageMetadataException(Warnings.message((Localized)this, 119, string));
        }
        return string2;
    }

    private Map<String, String> readHeader() throws IOException {
        HashMap<String, String> hashMap;
        block15: {
            String string;
            ReadableByteChannel readableByteChannel = this.getChannel();
            StringBuilder stringBuilder = new StringBuilder(32);
            hashMap = new HashMap<String, String>();
            ByteBuffer byteBuffer = this.buffer;
            if (byteBuffer == null) {
                this.buffer = byteBuffer = ByteBuffer.allocateDirect(16384);
            }
            byteBuffer.clear();
            byteBuffer.limit(byteBuffer.position());
            while (true) {
                Object object;
                int n = byteBuffer.position();
                boolean bl = true;
                block5: while (true) {
                    int n2;
                    if (!byteBuffer.hasRemaining()) {
                        int n3;
                        n2 = byteBuffer.position();
                        if (n2 >= (n3 = byteBuffer.capacity())) {
                            throw new ImageMetadataException(Errors.format((int)69, (Object)n3));
                        }
                        byteBuffer.limit(Math.min(n3, Math.max(512, 2 * n2)));
                        if (readableByteChannel.read(byteBuffer) < 0) {
                            if (!bl) break;
                            break block15;
                        }
                        byteBuffer.flip().position(n2);
                    }
                    n2 = (char)(byteBuffer.get() & 0xFF);
                    switch (n2) {
                        case 10: {
                            break block5;
                        }
                        case 13: {
                            if (!byteBuffer.hasRemaining() || (n2 = (char)(byteBuffer.get() & 0xFF)) == 10) break block5;
                            byteBuffer.position(byteBuffer.position() - 1);
                            break block5;
                        }
                        default: {
                            if (bl) {
                                if (n2 >= 43 && n2 <= 57) {
                                    byteBuffer.position(n);
                                    break block15;
                                }
                                if (n2 > 32) {
                                    bl = false;
                                }
                            }
                            stringBuilder.append((char)n2);
                            continue block5;
                        }
                    }
                    break;
                }
                String string2 = stringBuilder.toString().trim();
                stringBuilder.setLength(0);
                if (string2.isEmpty() || this.isComment(string2)) continue;
                string = string2;
                String string3 = null;
                int n4 = string2.length();
                for (int i = 0; i < n4; ++i) {
                    char c = string2.charAt(i);
                    if (c > ' ' && c != ':' && c != '=') continue;
                    string = string2.substring(0, i).toUpperCase(Locale.US);
                    while (c <= ' ' && ++i <= n4) {
                        c = string2.charAt(i);
                        if (c != ':' && c != '=') continue;
                        ++i;
                        break;
                    }
                    string3 = string2.substring(i).trim();
                    break;
                }
                if ((object = hashMap.put(string, string3)) != null && !object.equals(string3)) break;
            }
            throw new ImageMetadataException(Errors.format((int)245, (Object)string));
        }
        return hashMap;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.checkImageIndex(n);
        this.ensureHeaderRead();
        return this.width;
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.checkImageIndex(n);
        this.ensureHeaderRead();
        return this.height;
    }

    @Override
    protected int getRawDataType(int n) throws IOException {
        this.checkImageIndex(n);
        this.ensureHeaderRead();
        return this.binaryType != 32 ? this.binaryType : 4;
    }

    @Override
    protected SpatialMetadata createMetadata(int n) throws IOException {
        boolean bl;
        if (n < 0) {
            return null;
        }
        this.ensureHeaderRead();
        PixelOrientation pixelOrientation = this.xCenter ? (this.yCenter ? PixelOrientation.CENTER : PixelOrientation.valueOf((String)"UPPER")) : (this.yCenter ? PixelOrientation.valueOf((String)"LEFT") : PixelOrientation.UPPER_LEFT);
        double[] dArray = new double[]{this.xll, this.yll + this.scaleX * (double)(this.height - (this.yCenter ? 1 : 0))};
        double[] dArray2 = new double[]{this.xll + this.scaleY * (double)(this.width - (this.xCenter ? 1 : 0)), this.yll};
        SpatialMetadata spatialMetadata = new SpatialMetadata(false, (ImageReader)this, null);
        GridDomainAccessor gridDomainAccessor = new GridDomainAccessor(spatialMetadata);
        gridDomainAccessor.setOrigin(dArray);
        gridDomainAccessor.addOffsetVector(this.scaleX, 0.0);
        gridDomainAccessor.addOffsetVector(0.0, -this.scaleY);
        gridDomainAccessor.setLimits(new int[2], new int[]{this.width - 1, this.height - 1});
        gridDomainAccessor.setSpatialRepresentation(dArray, dArray2, null, pixelOrientation);
        boolean bl2 = !Double.isInfinite(this.minValue) && !Double.isInfinite(this.maxValue);
        boolean bl3 = bl = !Double.isNaN(this.fillValue);
        if (bl2 || bl) {
            DimensionAccessor dimensionAccessor = new DimensionAccessor(spatialMetadata);
            dimensionAccessor.selectChild(dimensionAccessor.appendChild());
            if (bl2) {
                dimensionAccessor.setValueRange(this.minValue, this.maxValue);
            }
            if (bl) {
                dimensionAccessor.setFillSampleValues(this.fillValue);
            }
        }
        return spatialMetadata;
    }

    protected void processHeader(Map<String, String> map) throws IOException {
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        int n3;
        int n4;
        int[] nArray;
        int[] nArray2;
        BufferedImage bufferedImage;
        this.clearAbortRequest();
        this.checkImageIndex(n);
        this.processImageStarted(n);
        this.ensureHeaderRead();
        if (this.binaryType != 32 && (bufferedImage = this.readBinary(n, imageReadParam)) != null) {
            return bufferedImage;
        }
        if (imageReadParam != null) {
            nArray2 = imageReadParam.getSourceBands();
            nArray = imageReadParam.getDestinationBands();
            n4 = imageReadParam.getSourceXSubsampling();
            n3 = imageReadParam.getSourceYSubsampling();
        } else {
            nArray2 = null;
            nArray = null;
            n4 = 1;
            n3 = 1;
        }
        int n5 = this.width;
        int n6 = this.height;
        int n7 = nArray != null ? nArray.length : 1;
        SampleConverter[] sampleConverterArray = new SampleConverter[n7];
        BufferedImage bufferedImage2 = this.getDestination(n, imageReadParam, n5, n6, sampleConverterArray);
        WritableRaster writableRaster = bufferedImage2.getRaster();
        AsciiGridReader.checkReadParamBandSettings(imageReadParam, 1, writableRaster.getNumBands());
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        AsciiGridReader.computeRegions(imageReadParam, n5, n6, bufferedImage2, rectangle, rectangle2);
        WritableRectIter writableRectIter = RectIterFactory.createWritable((WritableRaster)writableRaster, (Rectangle)rectangle2);
        int n8 = n2 = nArray != null ? nArray[0] : 0;
        while (--n8 >= 0) {
            if (!writableRectIter.nextBandDone()) continue;
            throw new IIOException(Errors.format((int)5, (Object)n2));
        }
        if (!(writableRectIter.finishedBands() || writableRectIter.finishedLines() || writableRectIter.finishedPixels())) {
            n8 = writableRaster.getSampleModel().getDataType();
            char[] cArray = new char[48];
            ByteBuffer byteBuffer = this.buffer;
            ReadableByteChannel readableByteChannel = this.getChannel();
            SampleConverter sampleConverter = sampleConverterArray[0];
            this.minIndex = n + 1;
            float f = 100.0f / (float)((rectangle.x + rectangle.height) * n5);
            int n9 = 1 + rectangle.y;
            int n10 = 0;
            block7: while (true) {
                boolean bl;
                if (this.abortRequested()) {
                    this.processReadAborted();
                    return bufferedImage2;
                }
                boolean bl2 = bl = --n9 == 0;
                if (bl) {
                    n9 = n3;
                }
                int n11 = 1 + rectangle.x;
                for (int i = 0; i < n5; ++i) {
                    int n12 = 0;
                    while (true) {
                        int n13;
                        if (!byteBuffer.hasRemaining()) {
                            this.processImageProgress((float)(n10 * n5 + i) * f);
                            byteBuffer.clear();
                            if (readableByteChannel.read(byteBuffer) < 0) {
                                throw new EOFException(Errors.format((int)61));
                            }
                            byteBuffer.flip();
                        }
                        if ((n13 = (int)(byteBuffer.get() & 0xFF)) > 32) {
                            if (n12 >= cArray.length) {
                                throw new IIOException(Warnings.message((Localized)this, 12, "cell(" + i + ',' + n10 + ')', String.valueOf(cArray)));
                            }
                            if (n13 == 44) {
                                n13 = 46;
                            }
                            cArray[n12++] = n13;
                            continue;
                        }
                        if (n12 != 0) break;
                    }
                    if (!bl || --n11 != 0) continue;
                    n11 = n4;
                    String string = new String(cArray, 0, n12);
                    try {
                        switch (n8) {
                            case 5: {
                                writableRectIter.setSample(sampleConverter.convert(Double.parseDouble(string)));
                                break;
                            }
                            case 4: {
                                writableRectIter.setSample(sampleConverter.convert(Float.parseFloat(string)));
                                break;
                            }
                            default: {
                                writableRectIter.setSample(sampleConverter.convert(Integer.parseInt(string)));
                                break;
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IIOException(Warnings.message((Localized)this, 232, string), numberFormatException);
                    }
                    if (!writableRectIter.nextPixelDone()) continue;
                    if (writableRectIter.nextLineDone()) break block7;
                    writableRectIter.startPixels();
                    bl = false;
                }
                assert (!bl) : rectangle2;
                ++n10;
            }
        }
        this.processImageComplete();
        return bufferedImage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readBinary(int n, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage;
        InputStream inputStream;
        Object object;
        Object object2 = IOUtilities.changeExtension((Object)this.input, (String)"raw");
        if (object2 == null || object2 == this.input) {
            return null;
        }
        if (!(!(object2 instanceof File) || ((File)(object = (File)object2)).isFile() && ((File)object).canRead())) {
            return null;
        }
        object = this.binaryReader;
        if (object == null) {
            object = new RawReader(null);
            this.binaryReader = object;
        }
        try {
            inputStream = IOUtilities.open((Object)object2);
        }
        catch (IOException iOException) {
            Warnings.log((WarningProducer)this, null, AsciiGridReader.class, "readBinary", iOException);
            return null;
        }
        try {
            this.buffer.clear().limit(0);
            ChannelImageInputStream channelImageInputStream = new ChannelImageInputStream(Channels.newChannel(inputStream), this.buffer);
            RawImageInputStream rawImageInputStream = new RawImageInputStream((ImageInputStream)channelImageInputStream, this.getRawImageType(n), new long[1], new Dimension[]{new Dimension(this.width, this.height)});
            try {
                ((ImageReader)object).setInput(rawImageInputStream, true, true);
                bufferedImage = ((ImageReader)object).read(n, imageReadParam);
            }
            finally {
                rawImageInputStream.close();
            }
        }
        finally {
            inputStream.close();
            ((ImageReader)object).reset();
        }
        return bufferedImage;
    }

    @Override
    protected void close() throws IOException {
        this.headerValid = false;
        super.close();
        ImageReader imageReader = this.binaryReader;
        if (imageReader != null) {
            imageReader.reset();
        }
    }

    @Override
    public void dispose() {
        this.buffer = null;
        ImageReader imageReader = this.binaryReader;
        if (imageReader != null) {
            this.binaryReader = null;
            imageReader.dispose();
        }
        super.dispose();
    }

    public static class Spi
    extends TextImageReader.Spi {
        static final String[] NAMES = new String[]{"ASCII-Grid", "ascii-grid"};
        static final String[] SUFFIXES = new String[]{"asc", "ASC", "grd", "GRD", "agr", "AGR"};
        static final String[] MIME_TYPES = new String[]{"text/plain", "text/x-ascii-grid"};
        private static final String[] WRITERS = new String[]{"org.geotoolkit.image.io.plugin.AsciiGridWriter$Spi"};

        public Spi() {
            this.names = NAMES;
            this.suffixes = SUFFIXES;
            this.MIMETypes = MIME_TYPES;
            this.pluginClassName = "org.geotoolkit.image.io.plugin.AsciiGridReader";
            this.writerSpiNames = WRITERS;
            this.locale = Locale.US;
            this.charset = Charset.forName("US-ASCII");
            this.nativeStreamMetadataFormatName = null;
        }

        @Override
        public String getDescription(Locale locale) {
            return "ASCII grid";
        }

        @Override
        public ImageReader createReaderInstance(Object object) throws IOException {
            return new AsciiGridReader(this);
        }

        @Override
        protected boolean isValidHeader(Set<String> set) {
            return !(!set.contains("NCOLS") || !set.contains("NROWS") || !set.contains("XLLCORNER") && !set.contains("XLLCENTER") || !set.contains("YLLCORNER") && !set.contains("YLLCENTER") || !set.contains("CELLSIZE") && (!set.contains("DX") || !set.contains("DY")));
        }

        @Override
        protected boolean isValidContent(double[][] dArray) {
            return true;
        }
    }

    private final class RawReader
    extends RawImageReader {
        RawReader(RawImageReader.Spi spi) {
            super(spi);
        }

        @Override
        public SpatialMetadata getStreamMetadata() throws IOException {
            return AsciiGridReader.this.getStreamMetadata();
        }

        @Override
        public SpatialMetadata getImageMetadata(int n) throws IOException {
            return AsciiGridReader.this.getImageMetadata(n);
        }

        @Override
        protected void processImageComplete() {
            AsciiGridReader.this.processImageComplete();
        }

        @Override
        protected void processImageProgress(float f) {
            AsciiGridReader.this.processImageProgress(f);
        }

        @Override
        protected void processReadAborted() {
            AsciiGridReader.this.processReadAborted();
        }
    }
}

