/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import org.geotoolkit.coverage.grid.ImageGeometry;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.image.io.mosaic.ComparedTileManager;
import org.geotoolkit.image.io.mosaic.GDALTileManager;
import org.geotoolkit.image.io.mosaic.GridTileManager;
import org.geotoolkit.image.io.mosaic.ImageFileFilter;
import org.geotoolkit.image.io.mosaic.RegionCalculator;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.image.io.mosaic.TileManager;
import org.geotoolkit.image.io.mosaic.TileReaderPool;
import org.geotoolkit.image.io.mosaic.TreeTileManager;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.logging.Logging;

public class TileManagerFactory
extends Factory {
    public static final TileManagerFactory DEFAULT = new TileManagerFactory(EMPTY_HINTS);

    protected TileManagerFactory(Hints hints) {
    }

    public TileManager[] createFromObject(Object object) throws IOException, IllegalArgumentException {
        TileManager[] tileManagerArray;
        if (object == null) {
            tileManagerArray = null;
        } else if (object instanceof File) {
            tileManagerArray = this.create((File)object);
        } else if (object instanceof TileManager[]) {
            tileManagerArray = (TileManager[])((TileManager[])object).clone();
        } else if (object instanceof TileManager) {
            tileManagerArray = new TileManager[]{(TileManager)object};
        } else if (object instanceof Tile[]) {
            tileManagerArray = this.create((Tile[])object);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            tileManagerArray = this.create(collection);
        } else {
            throw new IllegalArgumentException(Errors.format((int)256, (Object)"tiles", object.getClass(), TileManager.class));
        }
        if (tileManagerArray != null) {
            for (int i = 0; i < tileManagerArray.length; ++i) {
                if (tileManagerArray[i] != null) continue;
                throw new NullArgumentException(Errors.format((int)172, (Object)("input[" + i + ']')));
            }
        }
        return tileManagerArray;
    }

    public TileManager[] create(File file) throws IOException {
        if (file.isFile()) {
            Object object;
            String string = file.getName();
            if (!string.endsWith(".serialized")) {
                throw new IOException(Errors.format((int)219, (Object)string));
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            try {
                object = objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                InvalidClassException invalidClassException = new InvalidClassException(classNotFoundException.getLocalizedMessage());
                invalidClassException.initCause(classNotFoundException);
                throw invalidClassException;
            }
            objectInputStream.close();
            return TileManagerFactory.setSourceFile(this.createFromObject(object), file);
        }
        if (file.isDirectory()) {
            return this.create(file, null, null);
        }
        throw new IOException(Errors.format((int)143, (Object)file));
    }

    public TileManager[] create(File file, FileFilter fileFilter, ImageReaderSpi imageReaderSpi) throws IOException {
        if (fileFilter == null) {
            fileFilter = new ImageFileFilter(imageReaderSpi);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        TileManagerFactory.listFiles(file, fileFilter, arrayList);
        return TileManagerFactory.setSourceFile(this.create(this.listTiles(imageReaderSpi, arrayList.toArray(new File[arrayList.size()]))), file);
    }

    private static TileManager[] setSourceFile(TileManager[] tileManagerArray, File file) {
        for (TileManager tileManager : tileManagerArray) {
            tileManager.setSourceFile(file);
        }
        return tileManagerArray;
    }

    private static void listFiles(File file, FileFilter fileFilter, ArrayList<File> arrayList) throws IOException {
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray == null) {
            throw new IOException(Errors.format((int)143, (Object)file));
        }
        arrayList.ensureCapacity(arrayList.size() + fileArray.length);
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                TileManagerFactory.listFiles(file2, fileFilter, arrayList);
                continue;
            }
            arrayList.add(file2);
        }
    }

    public TileManager[] create(Tile ... tileArray) throws IOException {
        return this.create(Arrays.asList(tileArray));
    }

    public TileManager[] create(Collection<Tile> object) throws IOException {
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        TileManager[] tileManagerArray;
        int n = 0;
        if (!TileManagerFactory.hasPendingGridToCRS((Collection<Tile>)object)) {
            if (!object.isEmpty()) {
                n = 1;
            }
            tileManagerArray = new TileManager[n];
        } else {
            serializable = new ArrayList(Math.min(16, object.size()));
            object4 = new RegionCalculator();
            object3 = object.iterator();
            while (object3.hasNext()) {
                object2 = (Tile)object3.next();
                if (((RegionCalculator)object4).add((Tile)object2)) continue;
                serializable.add(object2);
            }
            if (!serializable.isEmpty()) {
                n = 1;
            }
            object3 = ((RegionCalculator)object4).tiles();
            tileManagerArray = new TileManager[object3.size() + n];
            for (Map.Entry entry : object3.entrySet()) {
                TileManager tileManager = this.createGeneric((Tile[])entry.getValue());
                tileManager.setGridGeometry((ImageGeometry)entry.getKey());
                tileManagerArray[n++] = tileManager;
            }
            object = serializable;
        }
        if (!object.isEmpty()) {
            serializable = this.createGeneric(object.toArray(new Tile[object.size()]));
            object4 = new Rectangle(-1, -1);
            object3 = null;
            object2 = null;
            double d = Double.POSITIVE_INFINITY;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Tile tile = (Tile)iterator.next();
                ((Rectangle)object4).add(tile.getAbsoluteRegion());
                AffineTransform affineTransform = tile.getGridToCRS();
                if (affineTransform == null || affineTransform.equals(object3)) continue;
                double d2 = XAffineTransform.getScale((AffineTransform)affineTransform);
                if (d2 < d) {
                    d = d2;
                    object3 = affineTransform;
                    object2 = tile.getSubsampling();
                    continue;
                }
                if (d2 != d) continue;
                object3 = null;
                break;
            }
            if (object3 != null) {
                if (((Dimension)object2).width != 1 || ((Dimension)object2).height != 1) {
                    object3 = new AffineTransform((AffineTransform)object3);
                    ((AffineTransform)object3).scale(((Dimension)object2).width, ((Dimension)object2).height);
                }
                ((TileManager)serializable).setGridGeometry(new ImageGeometry((Rectangle)object4, (AffineTransform)object3));
            }
            tileManagerArray[0] = serializable;
        }
        return tileManagerArray;
    }

    private static boolean hasPendingGridToCRS(Collection<Tile> collection) {
        for (Tile tile : collection) {
            if (tile.getPendingGridToCRS(false) == null) continue;
            return true;
        }
        return false;
    }

    protected TileManager createGeneric(Tile[] tileArray) throws IOException {
        TileManager tileManager;
        try {
            tileManager = new GridTileManager(tileArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.recoverableException((Logger)Tile.LOGGER, GridTileManager.class, (String)"<init>", (Throwable)illegalArgumentException);
            try {
                tileManager = new GDALTileManager(tileArray);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                Logging.recoverableException((Logger)Tile.LOGGER, GDALTileManager.class, (String)"<init>", (Throwable)illegalArgumentException2);
                return new TreeTileManager(tileArray);
            }
        }
        assert ((tileManager = new ComparedTileManager(tileManager, new TreeTileManager(tileArray))) != null);
        return tileManager;
    }

    public List<Tile> listTiles(ImageReaderSpi imageReaderSpi, File ... fileArray) throws IOException {
        TileReaderPool tileReaderPool = new TileReaderPool();
        HashSet<ImageReaderSpi> hashSet = new HashSet<ImageReaderSpi>();
        ArrayList<Tile> arrayList = new ArrayList<Tile>(fileArray.length);
        AffineTransform affineTransform = new AffineTransform();
        block2: for (File file : fileArray) {
            Tile tile = new Tile(imageReaderSpi, file, 0);
            if (hashSet.add(tile.getImageReaderSpi())) {
                tileReaderPool.setProviders(hashSet);
            }
            AffineTransform affineTransform2 = tile.getPendingGridToCRS(false);
            ImageReader imageReader = tile.getImageReader(tileReaderPool, true, true);
            int n = imageReader.getNumImages(false);
            for (int i = 0; i != n; ++i) {
                Tile tile2;
                int n2;
                int n3;
                try {
                    n3 = imageReader.getWidth(i);
                    n2 = imageReader.getHeight(i);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue block2;
                }
                if (i == 0) {
                    tile2 = tile;
                } else {
                    Rectangle rectangle = tile.getRegion();
                    affineTransform.setTransform(new AffineTransform(affineTransform2));
                    affineTransform.scale((double)rectangle.width / (double)n3, (double)rectangle.height / (double)n2);
                    tile2 = new Tile(tile.getImageReaderSpi(), (Object)file, i, rectangle, affineTransform);
                }
                tile2.setSize(n3, n2);
                arrayList.add(tile2);
            }
        }
        tileReaderPool.close();
        tileReaderPool.dispose();
        return arrayList;
    }
}

