/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.coverage.grid.ImageGeometry;
import org.geotoolkit.image.io.mosaic.LargeTile;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.FrequencySortedSet;
import org.geotoolkit.util.collection.XCollections;

@ThreadSafe
public abstract class TileManager
implements Serializable {
    private static final long serialVersionUID = -7645850962821189968L;
    public static final String SERIALIZED_FILENAME = "TileManager.serialized";
    private ImageGeometry geometry;
    transient Set<ImageReaderSpi> providers;
    private transient File sourceFile;

    protected TileManager() {
    }

    final synchronized void setSourceFile(File file) {
        if (this.sourceFile != null) {
            throw new IllegalStateException();
        }
        this.sourceFile = file;
    }

    final synchronized File getSourceFile() {
        return this.sourceFile;
    }

    public synchronized void setGridToCRS(AffineTransform affineTransform) throws IllegalStateException, IOException {
        if (this.geometry != null) {
            throw new IllegalStateException();
        }
        HashMap<Dimension, Object> hashMap = new HashMap<Dimension, Object>();
        Object object = new XAffineTransform(affineTransform);
        hashMap.put(new Dimension(1, 1), object);
        this.geometry = new ImageGeometry(this.getRegion(), (AffineTransform)object);
        for (Tile tile : this.getInternalTiles()) {
            Dimension dimension = tile.getSubsampling();
            object = (AffineTransform)hashMap.get(dimension);
            if (object == null) {
                object = new AffineTransform(affineTransform);
                ((AffineTransform)object).scale(dimension.width, dimension.height);
                object = new XAffineTransform((AffineTransform)object);
                hashMap.put(dimension, object);
            }
            tile.setGridToCRS((AffineTransform)object);
        }
    }

    synchronized void setGridGeometry(ImageGeometry imageGeometry) {
        if (this.geometry != null) {
            throw new IllegalStateException();
        }
        this.geometry = imageGeometry;
    }

    public synchronized ImageGeometry getGridGeometry() throws IOException {
        return this.geometry;
    }

    Rectangle getRegion() throws IOException {
        return this.getGridGeometry().getExtent();
    }

    Dimension getTileSize() throws IOException {
        return this.getRegion().getSize();
    }

    boolean isImageTiled() throws IOException {
        return true;
    }

    public synchronized Set<ImageReaderSpi> getImageReaderSpis() throws IOException {
        if (this.providers == null) {
            FrequencySortedSet frequencySortedSet = new FrequencySortedSet(4, true);
            Collection<Tile> collection = this.getInternalTiles();
            int[] nArray = null;
            if (collection instanceof FrequencySortedSet) {
                nArray = ((FrequencySortedSet)collection).frequencies();
            }
            int n = 0;
            for (Tile tile : collection) {
                int n2 = nArray != null ? nArray[n++] : 1;
                frequencySortedSet.add((Object)tile.getImageReaderSpi(), n2);
            }
            this.providers = XCollections.unmodifiableSet((Set)frequencySortedSet);
        }
        return this.providers;
    }

    public Tile createGlobalTile(ImageReaderSpi object, Object object2, int n) throws NoSuchElementException, IOException {
        Object object3;
        Object object4;
        if (object == null) {
            List<String> list;
            object = this.getImageReaderSpis().iterator().next();
            object4 = Tile.getImageReaderSpi(object2);
            if (object4 != null && object4 != object && !(object3 = Arrays.asList(((ImageReaderWriterSpi)object).getFormatNames())).containsAll(list = Arrays.asList(((ImageReaderWriterSpi)object4).getFormatNames()))) {
                object = object4;
            }
        }
        if ((object3 = this.getGridGeometry()) == null) {
            object4 = new LargeTile((ImageReaderSpi)object, object2, n, this.getRegion());
        } else {
            object4 = new LargeTile((ImageReaderSpi)object, object2, n, (Rectangle)object3.getExtent());
            ((Tile)object4).setGridToCRS((AffineTransform)object3.getGridToCRS());
        }
        return object4;
    }

    Collection<Tile> getInternalTiles() throws IOException {
        return this.getTiles();
    }

    public abstract Collection<Tile> getTiles() throws IOException;

    public abstract Collection<Tile> getTiles(Rectangle var1, Dimension var2, boolean var3) throws IOException;

    public boolean intersects(Rectangle rectangle, Dimension dimension) throws IOException {
        return !this.getTiles(rectangle, dimension, false).isEmpty();
    }

    public void printErrors(PrintWriter printWriter) {
        Collection<Tile> collection;
        if (printWriter == null) {
            printWriter = new PrintWriter(System.out, true);
        }
        try {
            collection = this.getTiles();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(printWriter);
            return;
        }
        for (Tile tile : collection) {
            int n = tile.getImageIndex();
            ImageReader imageReader = null;
            String string = null;
            try {
                Dimension dimension = tile.getSize();
                imageReader = tile.getImageReader();
                int n2 = imageReader.getWidth(n);
                int n3 = imageReader.getHeight(n);
                if (n2 != dimension.width || n3 != dimension.height) {
                    string = Errors.format((int)209);
                }
                Tile.dispose(imageReader);
                imageReader = null;
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (RuntimeException runtimeException) {
                string = runtimeException.toString();
            }
            if (string != null) {
                printWriter.println(tile);
                printWriter.print("    ");
                printWriter.println(string);
            }
            if (imageReader == null) continue;
            imageReader.dispose();
        }
    }

    final long largestTileArea() throws IOException {
        long l = 0L;
        for (Tile tile : this.getInternalTiles()) {
            Dimension dimension = tile.getSize();
            long l2 = (long)dimension.width * (long)dimension.height;
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    final File rootDirectory() throws IOException {
        File file = null;
        for (Tile tile : this.getInternalTiles()) {
            File file2;
            Object object = tile.getInput();
            if (object instanceof String) {
                URL uRL;
                String string = (String)object;
                if (!string.regionMatches(true, 0, "file:", 0, 5)) continue;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    continue;
                }
                file2 = new File(uRL.getPath()).getParentFile();
            } else {
                if (!(object instanceof File)) continue;
                file2 = ((File)object).getParentFile();
            }
            if (file2 == null) {
                return new File(".");
            }
            if (file == null) {
                file = file2;
                continue;
            }
            file = IOUtilities.commonParent((File)file, (File)file2);
        }
        return file;
    }

    final long diskUsage() throws IOException {
        long l = 0L;
        Collection<Tile> collection = this.getInternalTiles();
        FrequencySortedSet frequencySortedSet = collection instanceof FrequencySortedSet ? (FrequencySortedSet)collection : null;
        for (Tile tile : collection) {
            Dimension dimension = tile.getSize();
            long l2 = (long)dimension.width * (long)dimension.height;
            if (frequencySortedSet != null) {
                l2 *= (long)frequencySortedSet.frequency((Object)tile);
            }
            l += l2;
        }
        return l;
    }

    boolean canWriteInPlace(ImageReaderSpi imageReaderSpi) {
        if (imageReaderSpi == null) {
            return true;
        }
        String string = imageReaderSpi.getClass().getName();
        return !string.equals("com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi");
    }

    public String toString() {
        Collection<Tile> collection;
        try {
            collection = this.getTiles();
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
        return Tile.toString(collection, 10000);
    }
}

