/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import com.sun.media.imageio.stream.FileChannelImageOutputStream;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import org.geotoolkit.image.io.UnsupportedImageFormatException;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.internal.image.io.RawFile;
import org.geotoolkit.internal.io.ObjectStream;
import org.geotoolkit.internal.io.TemporaryFile;
import org.geotoolkit.internal.rmi.RMI;
import org.geotoolkit.internal.rmi.ShareableTask;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.Utilities;

final class TileCopier
extends ShareableTask<Tile, Map<Tile, RawFile>> {
    private static final long serialVersionUID = 6264132661340879616L;
    private final BufferedImageOp filter;
    private final Map<Tile, RawFile> temporaryFiles;

    TileCopier(Collection<Tile> collection, BufferedImageOp bufferedImageOp) {
        super(collection);
        this.filter = bufferedImageOp;
        this.temporaryFiles = new HashMap<Tile, RawFile>();
    }

    private static ImageWriter getTemporaryTileWriter() throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("raw");
        if (!iterator.hasNext()) {
            throw new UnsupportedImageFormatException(Errors.format((int)159));
        }
        return iterator.next();
    }

    private static <T> T share(Map<T, T> map, T t) {
        T t2 = map.get(t);
        if (t2 != null) {
            return t2;
        }
        map.put(t, t);
        return t;
    }

    public Map<Tile, RawFile> call() throws IOException {
        Tile tile;
        ObjectStream objectStream = this.inputs();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        ImageWriter imageWriter = TileCopier.getTemporaryTileWriter();
        File file = RMI.getSharedTemporaryDirectory();
        ImageTypeSpecifier imageTypeSpecifier = null;
        BufferedImage bufferedImage = null;
        BufferedImage bufferedImage2 = null;
        while ((tile = (Tile)objectStream.next()) != null) {
            LogRecord logRecord = Loggings.format((Level)Level.FINE, (int)5, (Object)tile);
            logRecord.setSourceClassName("MosaicImageWriter");
            logRecord.setSourceMethodName("writeFromInput");
            Tile.LOGGER.log(logRecord);
            int n = tile.getImageIndex();
            ImageReader imageReader = tile.getImageReader();
            ImageReadParam imageReadParam = null;
            ImageTypeSpecifier imageTypeSpecifier2 = imageReader.getRawImageType(n);
            if (bufferedImage != null) {
                if (imageReader.getWidth(n) == bufferedImage.getWidth() && imageReader.getHeight(n) == bufferedImage.getHeight() && Utilities.equals((Object)imageTypeSpecifier, (Object)imageTypeSpecifier2)) {
                    imageReadParam = imageReader.getDefaultReadParam();
                    imageReadParam.setDestination(bufferedImage);
                } else {
                    bufferedImage = null;
                    bufferedImage2 = null;
                    System.gc();
                }
            }
            imageTypeSpecifier = imageTypeSpecifier2;
            bufferedImage = imageReader.read(n, imageReadParam);
            Tile.dispose(imageReader);
            BufferedImage bufferedImage3 = this.filter != null ? (bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2)) : bufferedImage;
            File file2 = TemporaryFile.createTempFile((String)"IMW", (String)".raw", (File)file);
            RawFile rawFile = new RawFile(file2, TileCopier.share(hashMap, ImageTypeSpecifier.createFromRenderedImage(bufferedImage3)), TileCopier.share(hashMap2, new Dimension(bufferedImage3.getWidth(), bufferedImage3.getHeight())));
            if (this.temporaryFiles.put(tile, rawFile) != null) {
                throw new IllegalArgumentException(Errors.format((int)55, (Object)tile));
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
            FileChannel fileChannel = randomAccessFile.getChannel();
            FileChannelImageOutputStream fileChannelImageOutputStream = new FileChannelImageOutputStream(fileChannel);
            imageWriter.setOutput(fileChannelImageOutputStream);
            imageWriter.write(bufferedImage3);
            imageWriter.setOutput(null);
            fileChannelImageOutputStream.close();
            fileChannel.close();
            randomAccessFile.close();
        }
        imageWriter.dispose();
        objectStream.close();
        return this.temporaryFiles;
    }

    public Map<Tile, RawFile> aggregate(Collection<Map<Tile, RawFile>> collection) {
        return TileCopier.aggregateMap(collection);
    }

    public void rollback() {
        for (RawFile rawFile : this.temporaryFiles.values()) {
            File file = rawFile.file;
            if (TemporaryFile.delete((File)file)) continue;
            file.deleteOnExit();
        }
        this.temporaryFiles.clear();
    }
}

