/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotoolkit.coverage.grid.ImageGeometry;
import org.geotoolkit.image.io.mosaic.Tile;
import org.geotoolkit.image.io.mosaic.TranslatedTransform;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.util.logging.Logging;

final class RegionCalculator {
    private static final double EPS = 1.0E-10;
    private final int xLocation;
    private final int yLocation;
    private final Map<AffineTransform, Tile> tiles;
    private static final Comparator<AffineTransform> X_COMPARATOR = new Comparator<AffineTransform>(){

        @Override
        public int compare(AffineTransform affineTransform, AffineTransform affineTransform2) {
            return Double.compare(XAffineTransform.getScaleX0((AffineTransform)affineTransform), XAffineTransform.getScaleX0((AffineTransform)affineTransform2));
        }
    };
    private static final Comparator<AffineTransform> Y_COMPARATOR = new Comparator<AffineTransform>(){

        @Override
        public int compare(AffineTransform affineTransform, AffineTransform affineTransform2) {
            return Double.compare(XAffineTransform.getScaleY0((AffineTransform)affineTransform), XAffineTransform.getScaleY0((AffineTransform)affineTransform2));
        }
    };

    public RegionCalculator() {
        this(null);
    }

    public RegionCalculator(Point point) {
        if (point != null) {
            this.xLocation = point.x;
            this.yLocation = point.y;
        } else {
            this.yLocation = 0;
            this.xLocation = 0;
        }
        this.tiles = new IdentityHashMap<AffineTransform, Tile>();
    }

    public Point getLocation() {
        return new Point(this.xLocation, this.yLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Tile tile) {
        AffineTransform affineTransform;
        Tile tile2 = tile;
        synchronized (tile2) {
            affineTransform = tile.getPendingGridToCRS(true);
        }
        if (affineTransform == null) {
            return false;
        }
        if (this.tiles.put(affineTransform, tile) != null) {
            throw new AssertionError();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ImageGeometry, Tile[]> tiles() {
        HashMap<ImageGeometry, Tile[]> hashMap = new HashMap<ImageGeometry, Tile[]>(4);
        for (Map<AffineTransform, Dimension> map : RegionCalculator.computePyramidLevels(this.tiles.keySet())) {
            Serializable serializable;
            AffineTransform affineTransform;
            Object object;
            AffineTransform affineTransform2 = null;
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            double d4 = Double.POSITIVE_INFINITY;
            for (AffineTransform affineTransform3 : map.keySet()) {
                double d5 = XAffineTransform.getScale((AffineTransform)affineTransform3);
                double d6 = affineTransform3.getTranslateY();
                if (affineTransform3.getScaleY() < 0.0 || affineTransform3.getShearY() < 0.0) {
                    d6 = -d6;
                }
                double d7 = affineTransform3.getTranslateX();
                if (affineTransform3.getScaleX() < 0.0 || affineTransform3.getShearX() < 0.0) {
                    d7 = -d7;
                }
                if (!(Math.abs(d5 - d4) <= 1.0E-10)) {
                    if (!(d5 < d4)) continue;
                    d4 = d5;
                    d3 = d6;
                    d = d7;
                } else {
                    if (d7 < d) {
                        d = d7;
                    }
                    if (!(Math.abs(d6 - d3) <= 1.0E-10)) {
                        if (!(d6 < d3)) continue;
                        d3 = d6;
                    } else if (!(d7 < d2)) continue;
                }
                d2 = d7;
                affineTransform2 = affineTransform3;
            }
            if (affineTransform2 == null) continue;
            if ((d2 -= d) > 1.0E-10) {
                object = new double[6];
                affineTransform2.getMatrix((double[])object);
                object[4] = d;
                affineTransform2 = new AffineTransform((double[])object);
            } else {
                affineTransform2 = new AffineTransform(affineTransform2);
            }
            try {
                object = affineTransform2.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new IllegalStateException(noninvertibleTransformException);
            }
            int n = 0;
            Object object2 = null;
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Tile[] tileArray = new Tile[map.size()];
            for (Map.Entry<AffineTransform, Dimension> entry : map.entrySet()) {
                Object object3;
                affineTransform = entry.getKey();
                serializable = this.tiles.remove(affineTransform);
                affineTransform.preConcatenate((AffineTransform)object);
                Tile tile = serializable;
                synchronized (tile) {
                    ((Tile)serializable).setSubsampling(entry.getValue());
                    try {
                        object3 = ((Tile)serializable).getRegion();
                    }
                    catch (IOException iOException) {
                        object3 = null;
                        Logging.unexpectedException((Logger)Tile.LOGGER, RegionCalculator.class, (String)"tiles", (Throwable)iOException);
                    }
                    if (object3 != null) {
                        XAffineTransform.transform((AffineTransform)affineTransform, (Rectangle2D)object3, (Rectangle2D)double_);
                        ((Rectangle)object3).x = (int)Math.round(double_.x);
                        ((Rectangle)object3).y = (int)Math.round(double_.y);
                        ((Rectangle)object3).width = (int)Math.round(double_.width);
                        ((Rectangle)object3).height = (int)Math.round(double_.height);
                    } else {
                        Point point = ((Tile)serializable).getLocation();
                        affineTransform.transform(point, point);
                        object3 = new Rectangle(point.x, point.y, 0, 0);
                    }
                    ((Tile)serializable).setAbsoluteRegion((Rectangle)object3);
                }
                if (object2 == null) {
                    object2 = object3;
                } else {
                    ((Rectangle)object2).add((Rectangle)object3);
                }
                tileArray[n++] = serializable;
            }
            map.clear();
            if (object2 == null) continue;
            int n2 = this.xLocation - ((Rectangle)object2).x;
            int n3 = this.yLocation - ((Rectangle)object2).y;
            if (n2 != 0 || n3 != 0) {
                affineTransform2.translate(-n2, -n3);
                ((Rectangle)object2).translate(n2, n3);
            }
            affineTransform = new ImageGeometry(object2, affineTransform2);
            affineTransform2 = affineTransform.getGridToCRS();
            serializable = new HashMap();
            for (Tile tile : tileArray) {
                Dimension dimension = tile.getSubsampling();
                TranslatedTransform translatedTransform = (TranslatedTransform)serializable.get(dimension);
                if (translatedTransform == null) {
                    translatedTransform = new TranslatedTransform(dimension, affineTransform2, n2, n3);
                    serializable.put(dimension, translatedTransform);
                }
                translatedTransform.applyTo(tile);
            }
            hashMap.put((ImageGeometry)affineTransform, tileArray);
        }
        return hashMap;
    }

    private static List<Map<AffineTransform, Dimension>> computePyramidLevels(Collection<AffineTransform> collection) {
        IdentityHashMap identityHashMap;
        ArrayList<Map<AffineTransform, Dimension>> arrayList = new ArrayList<Map<AffineTransform, Dimension>>(2);
        AffineTransform[] affineTransformArray = collection.toArray(new AffineTransform[collection.size()]);
        Arrays.sort(affineTransformArray, X_COMPARATOR);
        int n = affineTransformArray.length;
        while (n != 0) {
            identityHashMap = new IdentityHashMap();
            if (n <= (n = RegionCalculator.computePyramidLevels(affineTransformArray, n, identityHashMap, false))) {
                throw new AssertionError(n);
            }
            arrayList.add(identityHashMap);
        }
        identityHashMap = arrayList.iterator();
        while (identityHashMap.hasNext()) {
            Map map = (Map)identityHashMap.next();
            n = map.size();
            affineTransformArray = map.keySet().toArray(affineTransformArray);
            Arrays.sort(affineTransformArray, 0, n, Y_COMPARATOR);
            n = RegionCalculator.computePyramidLevels(affineTransformArray, n, map, true);
            while (--n >= 0) {
                if (map.remove(affineTransformArray[n]) == null) {
                    throw new AssertionError(n);
                }
            }
            if (!map.isEmpty()) continue;
            identityHashMap.remove();
        }
        return arrayList;
    }

    private static int computePyramidLevels(AffineTransform[] affineTransformArray, int n, Map<AffineTransform, Dimension> map, boolean bl) {
        double d;
        double d2;
        AffineTransform affineTransform;
        boolean bl2;
        boolean bl3;
        int n2 = 0;
        int n3 = 0;
        do {
            if (n2 >= n) {
                return n3;
            }
            affineTransform = affineTransformArray[n2++];
            if (bl) {
                d2 = affineTransform.getScaleY();
                d = affineTransform.getShearY();
            } else {
                d2 = affineTransform.getScaleX();
                d = affineTransform.getShearX();
            }
            bl3 = Math.abs(d2) < 1.0E-10;
            boolean bl4 = bl2 = Math.abs(d) < 1.0E-10;
        } while (bl3 && bl2 && RegionCalculator.redo(map.remove(affineTransform)));
        if (bl) {
            map.get((Object)affineTransform).height = 1;
        } else {
            assert (map.isEmpty()) : map;
            map.put(affineTransform, new Dimension(1, 0));
        }
        while (n2 < n) {
            int n4;
            double d3;
            double d4;
            AffineTransform affineTransform2 = affineTransformArray[n2++];
            if (bl) {
                d4 = affineTransform2.getScaleY();
                d3 = affineTransform2.getShearY();
            } else {
                d4 = affineTransform2.getScaleX();
                d3 = affineTransform2.getShearX();
            }
            if (bl3) {
                if (!(Math.abs(d4) < 1.0E-10)) {
                    affineTransformArray[n3++] = affineTransform2;
                    continue;
                }
                n4 = RegionCalculator.level(d3 / d);
            } else {
                n4 = RegionCalculator.level(d4 / d2);
                if (bl2 ? !(Math.abs(d3) < 1.0E-10) : RegionCalculator.level(d3 / d) != n4) {
                    affineTransformArray[n3++] = affineTransform2;
                    continue;
                }
            }
            if (n4 == 0) {
                affineTransformArray[n3++] = affineTransform2;
                continue;
            }
            if (bl) {
                map.get((Object)affineTransform2).height = n4;
                continue;
            }
            if (map.put(affineTransform2, new Dimension(n4, 0)) != null) {
                throw new AssertionError(affineTransform2);
            }
        }
        Arrays.fill(affineTransformArray, n3, n, null);
        return n3;
    }

    private static int level(double d) {
        if (d > 0.0 && d < Double.POSITIVE_INFINITY) {
            double d2;
            boolean bl;
            boolean bl2 = bl = d < 0.75;
            if (bl) {
                d = 1.0 / d;
            }
            if ((d2 = Math.rint(d)) < 2.147483647E9 && Math.abs(d - d2) < 1.0E-10) {
                int n = (int)d2;
                if (bl) {
                    n = -n;
                }
                return n;
            }
        }
        return 0;
    }

    private static boolean redo(Dimension dimension) {
        return true;
    }

    public String toString() {
        ArrayList<Tile> arrayList = new ArrayList<Tile>(this.tiles.values());
        Collections.sort(arrayList);
        return Tile.toString(arrayList, 400);
    }
}

